// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.serde

import aws.sdk.kotlin.services.lexmodelsv2.model.AssociatedTranscriptFilter
import aws.sdk.kotlin.services.lexmodelsv2.model.SearchAssociatedTranscriptsRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.SearchOrder
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class SearchAssociatedTranscriptsOperationSerializer: HttpSerialize<SearchAssociatedTranscriptsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: SearchAssociatedTranscriptsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.botId) { "botId is bound to the URI and must not be null" }
            requireNotNull(input.botVersion) { "botVersion is bound to the URI and must not be null" }
            requireNotNull(input.localeId) { "localeId is bound to the URI and must not be null" }
            requireNotNull(input.botRecommendationId) { "botRecommendationId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("bots"))
                add(PercentEncoding.SmithyLabel.encode("${input.botId}"))
                add(PercentEncoding.Path.encode("botversions"))
                add(PercentEncoding.SmithyLabel.encode("${input.botVersion}"))
                add(PercentEncoding.Path.encode("botlocales"))
                add(PercentEncoding.SmithyLabel.encode("${input.localeId}"))
                add(PercentEncoding.Path.encode("botrecommendations"))
                add(PercentEncoding.SmithyLabel.encode("${input.botRecommendationId}"))
                add(PercentEncoding.Path.encode("associatedtranscripts"))
            }
        }

        val payload = serializeSearchAssociatedTranscriptsOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeSearchAssociatedTranscriptsOperationBody(context: ExecutionContext, input: SearchAssociatedTranscriptsRequest): ByteArray {
    val serializer = JsonSerializer()
    val FILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("filters"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maxResults"))
    val NEXTINDEX_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("nextIndex"))
    val SEARCHORDER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("searchOrder"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FILTERS_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(NEXTINDEX_DESCRIPTOR)
        field(SEARCHORDER_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.filters != null) {
            listField(FILTERS_DESCRIPTOR) {
                for (el0 in input.filters) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAssociatedTranscriptFilterDocument))
                }
            }
        }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        input.nextIndex?.let { field(NEXTINDEX_DESCRIPTOR, it) }
        input.searchOrder?.let { field(SEARCHORDER_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
