// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.serde

import aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsBinBySpecification
import aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsUtteranceAttribute
import aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsUtteranceFilter
import aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsUtteranceGroupBySpecification
import aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsUtteranceMetric
import aws.sdk.kotlin.services.lexmodelsv2.model.ListUtteranceMetricsRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class ListUtteranceMetricsOperationSerializer: HttpSerialize<ListUtteranceMetricsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListUtteranceMetricsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.botId) { "botId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("bots"))
                add(PercentEncoding.SmithyLabel.encode("${input.botId}"))
                add(PercentEncoding.Path.encode("analytics"))
                add(PercentEncoding.Path.encode("utterancemetrics"))
            }
        }

        val payload = serializeListUtteranceMetricsOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeListUtteranceMetricsOperationBody(context: ExecutionContext, input: ListUtteranceMetricsRequest): ByteArray {
    val serializer = JsonSerializer()
    val ATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("attributes"))
    val BINBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("binBy"))
    val ENDDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("endDateTime"))
    val FILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("filters"))
    val GROUPBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("groupBy"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maxResults"))
    val METRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("metrics"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val STARTDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("startDateTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTRIBUTES_DESCRIPTOR)
        field(BINBY_DESCRIPTOR)
        field(ENDDATETIME_DESCRIPTOR)
        field(FILTERS_DESCRIPTOR)
        field(GROUPBY_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(METRICS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(STARTDATETIME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.attributes != null) {
            listField(ATTRIBUTES_DESCRIPTOR) {
                for (el0 in input.attributes) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAnalyticsUtteranceAttributeDocument))
                }
            }
        }
        if (input.binBy != null) {
            listField(BINBY_DESCRIPTOR) {
                for (el0 in input.binBy) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAnalyticsBinBySpecificationDocument))
                }
            }
        }
        input.endDateTime?.let { field(ENDDATETIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        if (input.filters != null) {
            listField(FILTERS_DESCRIPTOR) {
                for (el0 in input.filters) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAnalyticsUtteranceFilterDocument))
                }
            }
        }
        if (input.groupBy != null) {
            listField(GROUPBY_DESCRIPTOR) {
                for (el0 in input.groupBy) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAnalyticsUtteranceGroupBySpecificationDocument))
                }
            }
        }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        if (input.metrics != null) {
            listField(METRICS_DESCRIPTOR) {
                for (el0 in input.metrics) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAnalyticsUtteranceMetricDocument))
                }
            }
        }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        input.startDateTime?.let { field(STARTDATETIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
    }
    return serializer.toByteArray()
}
