// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.serde

import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeTestSetGenerationResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.LexModelsV2Exception
import aws.sdk.kotlin.services.lexmodelsv2.model.TestSetGenerationDataSource
import aws.sdk.kotlin.services.lexmodelsv2.model.TestSetGenerationStatus
import aws.sdk.kotlin.services.lexmodelsv2.model.TestSetStorageLocation
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DescribeTestSetGenerationOperationDeserializer: HttpDeserialize<DescribeTestSetGenerationResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeTestSetGenerationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeTestSetGenerationError(context, call)
        }
        val builder = DescribeTestSetGenerationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeTestSetGenerationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeTestSetGenerationError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LexModelsV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall)
        else -> LexModelsV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeTestSetGenerationOperationBody(builder: DescribeTestSetGenerationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDateTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val FAILUREREASONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failureReasons"))
    val GENERATIONDATASOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("generationDataSource"))
    val LASTUPDATEDDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedDateTime"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val STORAGELOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("storageLocation"))
    val TESTSETGENERATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("testSetGenerationId"))
    val TESTSETGENERATIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("testSetGenerationStatus"))
    val TESTSETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("testSetId"))
    val TESTSETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("testSetName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONDATETIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(FAILUREREASONS_DESCRIPTOR)
        field(GENERATIONDATASOURCE_DESCRIPTOR)
        field(LASTUPDATEDDATETIME_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STORAGELOCATION_DESCRIPTOR)
        field(TESTSETGENERATIONID_DESCRIPTOR)
        field(TESTSETGENERATIONSTATUS_DESCRIPTOR)
        field(TESTSETID_DESCRIPTOR)
        field(TESTSETNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONDATETIME_DESCRIPTOR.index -> builder.creationDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                FAILUREREASONS_DESCRIPTOR.index -> builder.failureReasons =
                    deserializer.deserializeList(FAILUREREASONS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                GENERATIONDATASOURCE_DESCRIPTOR.index -> builder.generationDataSource = deserializeTestSetGenerationDataSourceDocument(deserializer)
                LASTUPDATEDDATETIME_DESCRIPTOR.index -> builder.lastUpdatedDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                STORAGELOCATION_DESCRIPTOR.index -> builder.storageLocation = deserializeTestSetStorageLocationDocument(deserializer)
                TESTSETGENERATIONID_DESCRIPTOR.index -> builder.testSetGenerationId = deserializeString()
                TESTSETGENERATIONSTATUS_DESCRIPTOR.index -> builder.testSetGenerationStatus = deserializeString().let { TestSetGenerationStatus.fromValue(it) }
                TESTSETID_DESCRIPTOR.index -> builder.testSetId = deserializeString()
                TESTSETNAME_DESCRIPTOR.index -> builder.testSetName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
