// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.serde

import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotResourceGenerationResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.GenerationStatus
import aws.sdk.kotlin.services.lexmodelsv2.model.LexModelsV2Exception
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DescribeBotResourceGenerationOperationDeserializer: HttpDeserialize<DescribeBotResourceGenerationResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeBotResourceGenerationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeBotResourceGenerationError(context, call)
        }
        val builder = DescribeBotResourceGenerationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeBotResourceGenerationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeBotResourceGenerationError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LexModelsV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        else -> LexModelsV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeBotResourceGenerationOperationBody(builder: DescribeBotResourceGenerationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BOTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botId"))
    val BOTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botVersion"))
    val CREATIONDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDateTime"))
    val FAILUREREASONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failureReasons"))
    val GENERATEDBOTLOCALEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("generatedBotLocaleUrl"))
    val GENERATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("generationId"))
    val GENERATIONINPUTPROMPT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("generationInputPrompt"))
    val GENERATIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("generationStatus"))
    val LASTUPDATEDDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedDateTime"))
    val LOCALEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("localeId"))
    val MODELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("modelArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BOTID_DESCRIPTOR)
        field(BOTVERSION_DESCRIPTOR)
        field(CREATIONDATETIME_DESCRIPTOR)
        field(FAILUREREASONS_DESCRIPTOR)
        field(GENERATEDBOTLOCALEURL_DESCRIPTOR)
        field(GENERATIONID_DESCRIPTOR)
        field(GENERATIONINPUTPROMPT_DESCRIPTOR)
        field(GENERATIONSTATUS_DESCRIPTOR)
        field(LASTUPDATEDDATETIME_DESCRIPTOR)
        field(LOCALEID_DESCRIPTOR)
        field(MODELARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BOTID_DESCRIPTOR.index -> builder.botId = deserializeString()
                BOTVERSION_DESCRIPTOR.index -> builder.botVersion = deserializeString()
                CREATIONDATETIME_DESCRIPTOR.index -> builder.creationDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                FAILUREREASONS_DESCRIPTOR.index -> builder.failureReasons =
                    deserializer.deserializeList(FAILUREREASONS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                GENERATEDBOTLOCALEURL_DESCRIPTOR.index -> builder.generatedBotLocaleUrl = deserializeString()
                GENERATIONID_DESCRIPTOR.index -> builder.generationId = deserializeString()
                GENERATIONINPUTPROMPT_DESCRIPTOR.index -> builder.generationInputPrompt = deserializeString()
                GENERATIONSTATUS_DESCRIPTOR.index -> builder.generationStatus = deserializeString().let { GenerationStatus.fromValue(it) }
                LASTUPDATEDDATETIME_DESCRIPTOR.index -> builder.lastUpdatedDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LOCALEID_DESCRIPTOR.index -> builder.localeId = deserializeString()
                MODELARN_DESCRIPTOR.index -> builder.modelArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
