// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.serde

import aws.sdk.kotlin.services.lexmodelsv2.model.CreateSlotResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.LexModelsV2Exception
import aws.sdk.kotlin.services.lexmodelsv2.model.MultipleValuesSetting
import aws.sdk.kotlin.services.lexmodelsv2.model.ObfuscationSetting
import aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueElicitationSetting
import aws.sdk.kotlin.services.lexmodelsv2.model.SubSlotSetting
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class CreateSlotOperationDeserializer: HttpDeserialize<CreateSlotResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateSlotResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateSlotError(context, call)
        }
        val builder = CreateSlotResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateSlotOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateSlotError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LexModelsV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "PreconditionFailedException" -> PreconditionFailedExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall)
        else -> LexModelsV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateSlotOperationBody(builder: CreateSlotResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BOTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botId"))
    val BOTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botVersion"))
    val CREATIONDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDateTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val INTENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("intentId"))
    val LOCALEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("localeId"))
    val MULTIPLEVALUESSETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("multipleValuesSetting"))
    val OBFUSCATIONSETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("obfuscationSetting"))
    val SLOTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("slotId"))
    val SLOTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("slotName"))
    val SLOTTYPEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("slotTypeId"))
    val SUBSLOTSETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("subSlotSetting"))
    val VALUEELICITATIONSETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("valueElicitationSetting"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BOTID_DESCRIPTOR)
        field(BOTVERSION_DESCRIPTOR)
        field(CREATIONDATETIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(INTENTID_DESCRIPTOR)
        field(LOCALEID_DESCRIPTOR)
        field(MULTIPLEVALUESSETTING_DESCRIPTOR)
        field(OBFUSCATIONSETTING_DESCRIPTOR)
        field(SLOTID_DESCRIPTOR)
        field(SLOTNAME_DESCRIPTOR)
        field(SLOTTYPEID_DESCRIPTOR)
        field(SUBSLOTSETTING_DESCRIPTOR)
        field(VALUEELICITATIONSETTING_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BOTID_DESCRIPTOR.index -> builder.botId = deserializeString()
                BOTVERSION_DESCRIPTOR.index -> builder.botVersion = deserializeString()
                CREATIONDATETIME_DESCRIPTOR.index -> builder.creationDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                INTENTID_DESCRIPTOR.index -> builder.intentId = deserializeString()
                LOCALEID_DESCRIPTOR.index -> builder.localeId = deserializeString()
                MULTIPLEVALUESSETTING_DESCRIPTOR.index -> builder.multipleValuesSetting = deserializeMultipleValuesSettingDocument(deserializer)
                OBFUSCATIONSETTING_DESCRIPTOR.index -> builder.obfuscationSetting = deserializeObfuscationSettingDocument(deserializer)
                SLOTID_DESCRIPTOR.index -> builder.slotId = deserializeString()
                SLOTNAME_DESCRIPTOR.index -> builder.slotName = deserializeString()
                SLOTTYPEID_DESCRIPTOR.index -> builder.slotTypeId = deserializeString()
                SUBSLOTSETTING_DESCRIPTOR.index -> builder.subSlotSetting = deserializeSubSlotSettingDocument(deserializer)
                VALUEELICITATIONSETTING_DESCRIPTOR.index -> builder.valueElicitationSetting = deserializeSlotValueElicitationSettingDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
