// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.serde

import aws.sdk.kotlin.services.lexmodelsv2.model.BotMember
import aws.sdk.kotlin.services.lexmodelsv2.model.BotStatus
import aws.sdk.kotlin.services.lexmodelsv2.model.BotType
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DataPrivacy
import aws.sdk.kotlin.services.lexmodelsv2.model.LexModelsV2Exception
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class CreateBotOperationDeserializer: HttpDeserialize<CreateBotResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateBotResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateBotError(context, call)
        }
        val builder = CreateBotResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateBotOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateBotError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LexModelsV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "PreconditionFailedException" -> PreconditionFailedExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall)
        else -> LexModelsV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateBotOperationBody(builder: CreateBotResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BOTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botId"))
    val BOTMEMBERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("botMembers"))
    val BOTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botName"))
    val BOTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("botStatus"))
    val BOTTAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("botTags"))
    val BOTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("botType"))
    val CREATIONDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDateTime"))
    val DATAPRIVACY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("dataPrivacy"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val IDLESESSIONTTLINSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("idleSessionTTLInSeconds"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val TESTBOTALIASTAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("testBotAliasTags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BOTID_DESCRIPTOR)
        field(BOTMEMBERS_DESCRIPTOR)
        field(BOTNAME_DESCRIPTOR)
        field(BOTSTATUS_DESCRIPTOR)
        field(BOTTAGS_DESCRIPTOR)
        field(BOTTYPE_DESCRIPTOR)
        field(CREATIONDATETIME_DESCRIPTOR)
        field(DATAPRIVACY_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(IDLESESSIONTTLINSECONDS_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(TESTBOTALIASTAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BOTID_DESCRIPTOR.index -> builder.botId = deserializeString()
                BOTMEMBERS_DESCRIPTOR.index -> builder.botMembers =
                    deserializer.deserializeList(BOTMEMBERS_DESCRIPTOR) {
                        val col0 = mutableListOf<BotMember>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBotMemberDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                BOTNAME_DESCRIPTOR.index -> builder.botName = deserializeString()
                BOTSTATUS_DESCRIPTOR.index -> builder.botStatus = deserializeString().let { BotStatus.fromValue(it) }
                BOTTAGS_DESCRIPTOR.index -> builder.botTags =
                    deserializer.deserializeMap(BOTTAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                BOTTYPE_DESCRIPTOR.index -> builder.botType = deserializeString().let { BotType.fromValue(it) }
                CREATIONDATETIME_DESCRIPTOR.index -> builder.creationDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DATAPRIVACY_DESCRIPTOR.index -> builder.dataPrivacy = deserializeDataPrivacyDocument(deserializer)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                IDLESESSIONTTLINSECONDS_DESCRIPTOR.index -> builder.idleSessionTtlInSeconds = deserializeInt()
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                TESTBOTALIASTAGS_DESCRIPTOR.index -> builder.testBotAliasTags =
                    deserializer.deserializeMap(TESTBOTALIASTAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
