// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object containing information about a specific utterance.
 */
public class UtteranceSpecification private constructor(builder: Builder) {
    /**
     * The name of the intent that the utterance is associated to.
     */
    public val associatedIntentName: kotlin.String? = builder.associatedIntentName
    /**
     * The name of the slot that the utterance is associated to.
     */
    public val associatedSlotName: kotlin.String? = builder.associatedSlotName
    /**
     * The duration in milliseconds of the audio associated with the utterance.
     */
    public val audioVoiceDurationMillis: kotlin.Long? = builder.audioVoiceDurationMillis
    /**
     * The identifier of the alias of the bot that the utterance was made to.
     */
    public val botAliasId: kotlin.String? = builder.botAliasId
    /**
     * The identifier for the audio of the bot response.
     */
    public val botResponseAudioVoiceId: kotlin.String? = builder.botResponseAudioVoiceId
    /**
     * A list of objects containing information about the bot response to the utterance.
     */
    public val botResponses: List<UtteranceBotResponse>? = builder.botResponses
    /**
     * The version of the bot that the utterance was made to.
     */
    public val botVersion: kotlin.String? = builder.botVersion
    /**
     * The channel that is integrated with the bot that the utterance was made to.
     */
    public val channel: kotlin.String? = builder.channel
    /**
     * The date and time when the conversation in which the utterance took place ended. A conversation is defined as a unique combination of a `sessionId` and an `originatingRequestId`.
     */
    public val conversationEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.conversationEndTime
    /**
     * The date and time when the conversation in which the utterance took place began. A conversation is defined as a unique combination of a `sessionId` and an `originatingRequestId`.
     */
    public val conversationStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.conversationStartTime
    /**
     * The type of dialog action that the utterance is associated to. See the `type` field in [DialogAction](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_DialogAction.html) for more information.
     */
    public val dialogActionType: kotlin.String? = builder.dialogActionType
    /**
     * The input type of the utterance. The possible values are as follows:
     * + PCM format: audio data must be in little-endian byte order.
     *    + `audio/l16; rate=16000; channels=1`
     *    + `audio/x-l16; sample-rate=16000; channel-count=1`
     *    + `audio/lpcm; sample-rate=8000; sample-size-bits=16; channel-count=1; is-big-endian=false`
     * + Opus format
     *    + `audio/x-cbr-opus-with-preamble;preamble-size=0;bit-rate=256000;frame-size-milliseconds=4`
     * + Text format
     *    + `text/plain; charset=utf-8`
     */
    public val inputType: kotlin.String? = builder.inputType
    /**
     * The state of the intent that the utterance is associated to.
     */
    public val intentState: aws.sdk.kotlin.services.lexmodelsv2.model.IntentState? = builder.intentState
    /**
     * The locale of the bot that the utterance was made to.
     */
    public val localeId: kotlin.String? = builder.localeId
    /**
     * The mode of the session. The possible values are as follows:
     * + `Speech` – The session consisted of spoken dialogue.
     * + `Text` – The session consisted of written dialogue.
     * + `DTMF` – The session consisted of touch-tone keypad (Dual Tone Multi-Frequency) key presses.
     * + `MultiMode` – The session consisted of multiple modes.
     */
    public val mode: aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsModality? = builder.mode
    /**
     * The output type of the utterance. The possible values are as follows:
     * + `audio/mpeg`
     * + `audio/ogg`
     * + `audio/pcm (16 KHz)`
     * + `audio/` (defaults to `mpeg`)
     * + `text/plain; charset=utf-8`
     */
    public val outputType: kotlin.String? = builder.outputType
    /**
     * The identifier of the session that the utterance was made in.
     */
    public val sessionId: kotlin.String? = builder.sessionId
    /**
     * The slots that have been filled in the session by the time of the utterance.
     */
    public val slotsFilledInSession: kotlin.String? = builder.slotsFilledInSession
    /**
     * The text of the utterance.
     */
    public val utterance: kotlin.String? = builder.utterance
    /**
     * The identifier of the request associated with the utterance.
     */
    public val utteranceRequestId: kotlin.String? = builder.utteranceRequestId
    /**
     * The date and time when the utterance took place.
     */
    public val utteranceTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.utteranceTimestamp
    /**
     * Specifies whether the bot understood the utterance or not.
     */
    public val utteranceUnderstood: kotlin.Boolean = builder.utteranceUnderstood

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.UtteranceSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UtteranceSpecification(")
        append("associatedIntentName=$associatedIntentName,")
        append("associatedSlotName=$associatedSlotName,")
        append("audioVoiceDurationMillis=$audioVoiceDurationMillis,")
        append("botAliasId=$botAliasId,")
        append("botResponseAudioVoiceId=$botResponseAudioVoiceId,")
        append("botResponses=$botResponses,")
        append("botVersion=$botVersion,")
        append("channel=$channel,")
        append("conversationEndTime=$conversationEndTime,")
        append("conversationStartTime=$conversationStartTime,")
        append("dialogActionType=$dialogActionType,")
        append("inputType=$inputType,")
        append("intentState=$intentState,")
        append("localeId=$localeId,")
        append("mode=$mode,")
        append("outputType=$outputType,")
        append("sessionId=$sessionId,")
        append("slotsFilledInSession=$slotsFilledInSession,")
        append("utterance=$utterance,")
        append("utteranceRequestId=$utteranceRequestId,")
        append("utteranceTimestamp=$utteranceTimestamp,")
        append("utteranceUnderstood=$utteranceUnderstood")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatedIntentName?.hashCode() ?: 0
        result = 31 * result + (associatedSlotName?.hashCode() ?: 0)
        result = 31 * result + (audioVoiceDurationMillis?.hashCode() ?: 0)
        result = 31 * result + (botAliasId?.hashCode() ?: 0)
        result = 31 * result + (botResponseAudioVoiceId?.hashCode() ?: 0)
        result = 31 * result + (botResponses?.hashCode() ?: 0)
        result = 31 * result + (botVersion?.hashCode() ?: 0)
        result = 31 * result + (channel?.hashCode() ?: 0)
        result = 31 * result + (conversationEndTime?.hashCode() ?: 0)
        result = 31 * result + (conversationStartTime?.hashCode() ?: 0)
        result = 31 * result + (dialogActionType?.hashCode() ?: 0)
        result = 31 * result + (inputType?.hashCode() ?: 0)
        result = 31 * result + (intentState?.hashCode() ?: 0)
        result = 31 * result + (localeId?.hashCode() ?: 0)
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (outputType?.hashCode() ?: 0)
        result = 31 * result + (sessionId?.hashCode() ?: 0)
        result = 31 * result + (slotsFilledInSession?.hashCode() ?: 0)
        result = 31 * result + (utterance?.hashCode() ?: 0)
        result = 31 * result + (utteranceRequestId?.hashCode() ?: 0)
        result = 31 * result + (utteranceTimestamp?.hashCode() ?: 0)
        result = 31 * result + (utteranceUnderstood.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UtteranceSpecification

        if (associatedIntentName != other.associatedIntentName) return false
        if (associatedSlotName != other.associatedSlotName) return false
        if (audioVoiceDurationMillis != other.audioVoiceDurationMillis) return false
        if (botAliasId != other.botAliasId) return false
        if (botResponseAudioVoiceId != other.botResponseAudioVoiceId) return false
        if (botResponses != other.botResponses) return false
        if (botVersion != other.botVersion) return false
        if (channel != other.channel) return false
        if (conversationEndTime != other.conversationEndTime) return false
        if (conversationStartTime != other.conversationStartTime) return false
        if (dialogActionType != other.dialogActionType) return false
        if (inputType != other.inputType) return false
        if (intentState != other.intentState) return false
        if (localeId != other.localeId) return false
        if (mode != other.mode) return false
        if (outputType != other.outputType) return false
        if (sessionId != other.sessionId) return false
        if (slotsFilledInSession != other.slotsFilledInSession) return false
        if (utterance != other.utterance) return false
        if (utteranceRequestId != other.utteranceRequestId) return false
        if (utteranceTimestamp != other.utteranceTimestamp) return false
        if (utteranceUnderstood != other.utteranceUnderstood) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.UtteranceSpecification = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the intent that the utterance is associated to.
         */
        public var associatedIntentName: kotlin.String? = null
        /**
         * The name of the slot that the utterance is associated to.
         */
        public var associatedSlotName: kotlin.String? = null
        /**
         * The duration in milliseconds of the audio associated with the utterance.
         */
        public var audioVoiceDurationMillis: kotlin.Long? = null
        /**
         * The identifier of the alias of the bot that the utterance was made to.
         */
        public var botAliasId: kotlin.String? = null
        /**
         * The identifier for the audio of the bot response.
         */
        public var botResponseAudioVoiceId: kotlin.String? = null
        /**
         * A list of objects containing information about the bot response to the utterance.
         */
        public var botResponses: List<UtteranceBotResponse>? = null
        /**
         * The version of the bot that the utterance was made to.
         */
        public var botVersion: kotlin.String? = null
        /**
         * The channel that is integrated with the bot that the utterance was made to.
         */
        public var channel: kotlin.String? = null
        /**
         * The date and time when the conversation in which the utterance took place ended. A conversation is defined as a unique combination of a `sessionId` and an `originatingRequestId`.
         */
        public var conversationEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time when the conversation in which the utterance took place began. A conversation is defined as a unique combination of a `sessionId` and an `originatingRequestId`.
         */
        public var conversationStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of dialog action that the utterance is associated to. See the `type` field in [DialogAction](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_DialogAction.html) for more information.
         */
        public var dialogActionType: kotlin.String? = null
        /**
         * The input type of the utterance. The possible values are as follows:
         * + PCM format: audio data must be in little-endian byte order.
         *    + `audio/l16; rate=16000; channels=1`
         *    + `audio/x-l16; sample-rate=16000; channel-count=1`
         *    + `audio/lpcm; sample-rate=8000; sample-size-bits=16; channel-count=1; is-big-endian=false`
         * + Opus format
         *    + `audio/x-cbr-opus-with-preamble;preamble-size=0;bit-rate=256000;frame-size-milliseconds=4`
         * + Text format
         *    + `text/plain; charset=utf-8`
         */
        public var inputType: kotlin.String? = null
        /**
         * The state of the intent that the utterance is associated to.
         */
        public var intentState: aws.sdk.kotlin.services.lexmodelsv2.model.IntentState? = null
        /**
         * The locale of the bot that the utterance was made to.
         */
        public var localeId: kotlin.String? = null
        /**
         * The mode of the session. The possible values are as follows:
         * + `Speech` – The session consisted of spoken dialogue.
         * + `Text` – The session consisted of written dialogue.
         * + `DTMF` – The session consisted of touch-tone keypad (Dual Tone Multi-Frequency) key presses.
         * + `MultiMode` – The session consisted of multiple modes.
         */
        public var mode: aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsModality? = null
        /**
         * The output type of the utterance. The possible values are as follows:
         * + `audio/mpeg`
         * + `audio/ogg`
         * + `audio/pcm (16 KHz)`
         * + `audio/` (defaults to `mpeg`)
         * + `text/plain; charset=utf-8`
         */
        public var outputType: kotlin.String? = null
        /**
         * The identifier of the session that the utterance was made in.
         */
        public var sessionId: kotlin.String? = null
        /**
         * The slots that have been filled in the session by the time of the utterance.
         */
        public var slotsFilledInSession: kotlin.String? = null
        /**
         * The text of the utterance.
         */
        public var utterance: kotlin.String? = null
        /**
         * The identifier of the request associated with the utterance.
         */
        public var utteranceRequestId: kotlin.String? = null
        /**
         * The date and time when the utterance took place.
         */
        public var utteranceTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies whether the bot understood the utterance or not.
         */
        public var utteranceUnderstood: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.UtteranceSpecification) : this() {
            this.associatedIntentName = x.associatedIntentName
            this.associatedSlotName = x.associatedSlotName
            this.audioVoiceDurationMillis = x.audioVoiceDurationMillis
            this.botAliasId = x.botAliasId
            this.botResponseAudioVoiceId = x.botResponseAudioVoiceId
            this.botResponses = x.botResponses
            this.botVersion = x.botVersion
            this.channel = x.channel
            this.conversationEndTime = x.conversationEndTime
            this.conversationStartTime = x.conversationStartTime
            this.dialogActionType = x.dialogActionType
            this.inputType = x.inputType
            this.intentState = x.intentState
            this.localeId = x.localeId
            this.mode = x.mode
            this.outputType = x.outputType
            this.sessionId = x.sessionId
            this.slotsFilledInSession = x.slotsFilledInSession
            this.utterance = x.utterance
            this.utteranceRequestId = x.utteranceRequestId
            this.utteranceTimestamp = x.utteranceTimestamp
            this.utteranceUnderstood = x.utteranceUnderstood
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.UtteranceSpecification = UtteranceSpecification(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
