// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



/**
 * An object that contains a response to the utterance from the bot.
 */
public class UtteranceBotResponse private constructor(builder: Builder) {
    /**
     * The text of the response to the utterance from the bot.
     */
    public val content: kotlin.String? = builder.content
    /**
     * The type of the response. The following values are possible:
     * + `PlainText` – A plain text string.
     * + `CustomPayload` – A response string that you can customize to include data or metadata for your application.
     * + `SSML` – A string that includes Speech Synthesis Markup Language to customize the audio response.
     * + `ImageResponseCard` – An image with buttons that the customer can select. See [ImageResponseCard](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_ImageResponseCard.html) for more information.
     */
    public val contentType: aws.sdk.kotlin.services.lexmodelsv2.model.UtteranceContentType? = builder.contentType
    /**
     * A card that is shown to the user by a messaging platform. You define the contents of the card, the card is displayed by the platform.
     *
     * When you use a response card, the response from the user is constrained to the text associated with a button on the card.
     */
    public val imageResponseCard: aws.sdk.kotlin.services.lexmodelsv2.model.ImageResponseCard? = builder.imageResponseCard

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.UtteranceBotResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UtteranceBotResponse(")
        append("content=$content,")
        append("contentType=$contentType,")
        append("imageResponseCard=$imageResponseCard")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = content?.hashCode() ?: 0
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (imageResponseCard?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UtteranceBotResponse

        if (content != other.content) return false
        if (contentType != other.contentType) return false
        if (imageResponseCard != other.imageResponseCard) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.UtteranceBotResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The text of the response to the utterance from the bot.
         */
        public var content: kotlin.String? = null
        /**
         * The type of the response. The following values are possible:
         * + `PlainText` – A plain text string.
         * + `CustomPayload` – A response string that you can customize to include data or metadata for your application.
         * + `SSML` – A string that includes Speech Synthesis Markup Language to customize the audio response.
         * + `ImageResponseCard` – An image with buttons that the customer can select. See [ImageResponseCard](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_ImageResponseCard.html) for more information.
         */
        public var contentType: aws.sdk.kotlin.services.lexmodelsv2.model.UtteranceContentType? = null
        /**
         * A card that is shown to the user by a messaging platform. You define the contents of the card, the card is displayed by the platform.
         *
         * When you use a response card, the response from the user is constrained to the text associated with a button on the card.
         */
        public var imageResponseCard: aws.sdk.kotlin.services.lexmodelsv2.model.ImageResponseCard? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.UtteranceBotResponse) : this() {
            this.content = x.content
            this.contentType = x.contentType
            this.imageResponseCard = x.imageResponseCard
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.UtteranceBotResponse = UtteranceBotResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ImageResponseCard] inside the given [block]
         */
        public fun imageResponseCard(block: aws.sdk.kotlin.services.lexmodelsv2.model.ImageResponseCard.Builder.() -> kotlin.Unit) {
            this.imageResponseCard = aws.sdk.kotlin.services.lexmodelsv2.model.ImageResponseCard.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
