// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



public class UpdateResourcePolicyRequest private constructor(builder: Builder) {
    /**
     * The identifier of the revision of the policy to update. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception.
     *
     * If you don't specify a revision, Amazon Lex overwrites the contents of the policy with the new values.
     */
    public val expectedRevisionId: kotlin.String? = builder.expectedRevisionId
    /**
     * A resource policy to add to the resource. The policy is a JSON structure that contains one or more statements that define the policy. The policy must follow the IAM syntax. For more information about the contents of a JSON policy document, see [ IAM JSON policy reference ](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html).
     *
     * If the policy isn't valid, Amazon Lex returns a validation exception.
     */
    public val policy: kotlin.String? = builder.policy
    /**
     * The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.UpdateResourcePolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateResourcePolicyRequest(")
        append("expectedRevisionId=$expectedRevisionId,")
        append("policy=$policy,")
        append("resourceArn=$resourceArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = expectedRevisionId?.hashCode() ?: 0
        result = 31 * result + (policy?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateResourcePolicyRequest

        if (expectedRevisionId != other.expectedRevisionId) return false
        if (policy != other.policy) return false
        if (resourceArn != other.resourceArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.UpdateResourcePolicyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the revision of the policy to update. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception.
         *
         * If you don't specify a revision, Amazon Lex overwrites the contents of the policy with the new values.
         */
        public var expectedRevisionId: kotlin.String? = null
        /**
         * A resource policy to add to the resource. The policy is a JSON structure that contains one or more statements that define the policy. The policy must follow the IAM syntax. For more information about the contents of a JSON policy document, see [ IAM JSON policy reference ](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html).
         *
         * If the policy isn't valid, Amazon Lex returns a validation exception.
         */
        public var policy: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.
         */
        public var resourceArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.UpdateResourcePolicyRequest) : this() {
            this.expectedRevisionId = x.expectedRevisionId
            this.policy = x.policy
            this.resourceArn = x.resourceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.UpdateResourcePolicyRequest = UpdateResourcePolicyRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
