// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



public class UpdateBotLocaleRequest private constructor(builder: Builder) {
    /**
     * The unique identifier of the bot that contains the locale.
     */
    public val botId: kotlin.String? = builder.botId
    /**
     * The version of the bot that contains the locale to be updated. The version can only be the `DRAFT` version.
     */
    public val botVersion: kotlin.String? = builder.botVersion
    /**
     * The new description of the locale.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Contains settings for generative AI features powered by Amazon Bedrock for your bot locale. Use this object to turn generative AI features on and off. Pricing may differ if you turn a feature on. For more information, see LINK.
     */
    public val generativeAiSettings: aws.sdk.kotlin.services.lexmodelsv2.model.GenerativeAiSettings? = builder.generativeAiSettings
    /**
     * The identifier of the language and locale to update. The string must match one of the supported locales. For more information, see [Supported languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
     */
    public val localeId: kotlin.String? = builder.localeId
    /**
     * The new confidence threshold where Amazon Lex inserts the `AMAZON.FallbackIntent` and `AMAZON.KendraSearchIntent` intents in the list of possible intents for an utterance.
     */
    public val nluIntentConfidenceThreshold: kotlin.Double? = builder.nluIntentConfidenceThreshold
    /**
     * The new Amazon Polly voice Amazon Lex should use for voice interaction with the user.
     */
    public val voiceSettings: aws.sdk.kotlin.services.lexmodelsv2.model.VoiceSettings? = builder.voiceSettings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.UpdateBotLocaleRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateBotLocaleRequest(")
        append("botId=$botId,")
        append("botVersion=$botVersion,")
        append("description=$description,")
        append("generativeAiSettings=$generativeAiSettings,")
        append("localeId=$localeId,")
        append("nluIntentConfidenceThreshold=$nluIntentConfidenceThreshold,")
        append("voiceSettings=$voiceSettings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = botId?.hashCode() ?: 0
        result = 31 * result + (botVersion?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (generativeAiSettings?.hashCode() ?: 0)
        result = 31 * result + (localeId?.hashCode() ?: 0)
        result = 31 * result + (nluIntentConfidenceThreshold?.hashCode() ?: 0)
        result = 31 * result + (voiceSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateBotLocaleRequest

        if (botId != other.botId) return false
        if (botVersion != other.botVersion) return false
        if (description != other.description) return false
        if (generativeAiSettings != other.generativeAiSettings) return false
        if (localeId != other.localeId) return false
        if (nluIntentConfidenceThreshold != other.nluIntentConfidenceThreshold) return false
        if (voiceSettings != other.voiceSettings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.UpdateBotLocaleRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier of the bot that contains the locale.
         */
        public var botId: kotlin.String? = null
        /**
         * The version of the bot that contains the locale to be updated. The version can only be the `DRAFT` version.
         */
        public var botVersion: kotlin.String? = null
        /**
         * The new description of the locale.
         */
        public var description: kotlin.String? = null
        /**
         * Contains settings for generative AI features powered by Amazon Bedrock for your bot locale. Use this object to turn generative AI features on and off. Pricing may differ if you turn a feature on. For more information, see LINK.
         */
        public var generativeAiSettings: aws.sdk.kotlin.services.lexmodelsv2.model.GenerativeAiSettings? = null
        /**
         * The identifier of the language and locale to update. The string must match one of the supported locales. For more information, see [Supported languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
         */
        public var localeId: kotlin.String? = null
        /**
         * The new confidence threshold where Amazon Lex inserts the `AMAZON.FallbackIntent` and `AMAZON.KendraSearchIntent` intents in the list of possible intents for an utterance.
         */
        public var nluIntentConfidenceThreshold: kotlin.Double? = null
        /**
         * The new Amazon Polly voice Amazon Lex should use for voice interaction with the user.
         */
        public var voiceSettings: aws.sdk.kotlin.services.lexmodelsv2.model.VoiceSettings? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.UpdateBotLocaleRequest) : this() {
            this.botId = x.botId
            this.botVersion = x.botVersion
            this.description = x.description
            this.generativeAiSettings = x.generativeAiSettings
            this.localeId = x.localeId
            this.nluIntentConfidenceThreshold = x.nluIntentConfidenceThreshold
            this.voiceSettings = x.voiceSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.UpdateBotLocaleRequest = UpdateBotLocaleRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.GenerativeAiSettings] inside the given [block]
         */
        public fun generativeAiSettings(block: aws.sdk.kotlin.services.lexmodelsv2.model.GenerativeAiSettings.Builder.() -> kotlin.Unit) {
            this.generativeAiSettings = aws.sdk.kotlin.services.lexmodelsv2.model.GenerativeAiSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.VoiceSettings] inside the given [block]
         */
        public fun voiceSettings(block: aws.sdk.kotlin.services.lexmodelsv2.model.VoiceSettings.Builder.() -> kotlin.Unit) {
            this.voiceSettings = aws.sdk.kotlin.services.lexmodelsv2.model.VoiceSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
