// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



/**
 * Subslot elicitation settings.
 *
 * `DefaultValueSpecification` is a list of default values for a constituent sub slot in a composite slot. Default values are used when Amazon Lex hasn't determined a value for a slot. You can specify default values from context variables, session attributes, and defined values. This is similar to `DefaultValueSpecification` for slots.
 *
 * `PromptSpecification` is the prompt that Amazon Lex uses to elicit the sub slot value from the user. This is similar to `PromptSpecification` for slots.
 */
public class SubSlotValueElicitationSetting private constructor(builder: Builder) {
    /**
     * Defines a list of values that Amazon Lex should use as the default value for a slot.
     */
    public val defaultValueSpecification: aws.sdk.kotlin.services.lexmodelsv2.model.SlotDefaultValueSpecification? = builder.defaultValueSpecification
    /**
     * Specifies a list of message groups that Amazon Lex sends to a user to elicit a response.
     */
    public val promptSpecification: aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification? = builder.promptSpecification
    /**
     * If you know a specific pattern that users might respond to an Amazon Lex request for a sub slot value, you can provide those utterances to improve accuracy. This is optional. In most cases Amazon Lex is capable of understanding user utterances. This is similar to `SampleUtterances` for slots.
     */
    public val sampleUtterances: List<SampleUtterance>? = builder.sampleUtterances
    /**
     * Specifies the prompts that Amazon Lex uses while a bot is waiting for customer input.
     */
    public val waitAndContinueSpecification: aws.sdk.kotlin.services.lexmodelsv2.model.WaitAndContinueSpecification? = builder.waitAndContinueSpecification

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.SubSlotValueElicitationSetting = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SubSlotValueElicitationSetting(")
        append("defaultValueSpecification=$defaultValueSpecification,")
        append("promptSpecification=$promptSpecification,")
        append("sampleUtterances=$sampleUtterances,")
        append("waitAndContinueSpecification=$waitAndContinueSpecification")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultValueSpecification?.hashCode() ?: 0
        result = 31 * result + (promptSpecification?.hashCode() ?: 0)
        result = 31 * result + (sampleUtterances?.hashCode() ?: 0)
        result = 31 * result + (waitAndContinueSpecification?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SubSlotValueElicitationSetting

        if (defaultValueSpecification != other.defaultValueSpecification) return false
        if (promptSpecification != other.promptSpecification) return false
        if (sampleUtterances != other.sampleUtterances) return false
        if (waitAndContinueSpecification != other.waitAndContinueSpecification) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.SubSlotValueElicitationSetting = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Defines a list of values that Amazon Lex should use as the default value for a slot.
         */
        public var defaultValueSpecification: aws.sdk.kotlin.services.lexmodelsv2.model.SlotDefaultValueSpecification? = null
        /**
         * Specifies a list of message groups that Amazon Lex sends to a user to elicit a response.
         */
        public var promptSpecification: aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification? = null
        /**
         * If you know a specific pattern that users might respond to an Amazon Lex request for a sub slot value, you can provide those utterances to improve accuracy. This is optional. In most cases Amazon Lex is capable of understanding user utterances. This is similar to `SampleUtterances` for slots.
         */
        public var sampleUtterances: List<SampleUtterance>? = null
        /**
         * Specifies the prompts that Amazon Lex uses while a bot is waiting for customer input.
         */
        public var waitAndContinueSpecification: aws.sdk.kotlin.services.lexmodelsv2.model.WaitAndContinueSpecification? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.SubSlotValueElicitationSetting) : this() {
            this.defaultValueSpecification = x.defaultValueSpecification
            this.promptSpecification = x.promptSpecification
            this.sampleUtterances = x.sampleUtterances
            this.waitAndContinueSpecification = x.waitAndContinueSpecification
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.SubSlotValueElicitationSetting = SubSlotValueElicitationSetting(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.SlotDefaultValueSpecification] inside the given [block]
         */
        public fun defaultValueSpecification(block: aws.sdk.kotlin.services.lexmodelsv2.model.SlotDefaultValueSpecification.Builder.() -> kotlin.Unit) {
            this.defaultValueSpecification = aws.sdk.kotlin.services.lexmodelsv2.model.SlotDefaultValueSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification] inside the given [block]
         */
        public fun promptSpecification(block: aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification.Builder.() -> kotlin.Unit) {
            this.promptSpecification = aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.WaitAndContinueSpecification] inside the given [block]
         */
        public fun waitAndContinueSpecification(block: aws.sdk.kotlin.services.lexmodelsv2.model.WaitAndContinueSpecification.Builder.() -> kotlin.Unit) {
            this.waitAndContinueSpecification = aws.sdk.kotlin.services.lexmodelsv2.model.WaitAndContinueSpecification.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
