// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



/**
 * Settings used when Amazon Lex successfully captures a slot value from a user.
 */
public class SlotCaptureSetting private constructor(builder: Builder) {
    /**
     * A list of conditional branches to evaluate after the slot value is captured.
     */
    public val captureConditional: aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification? = builder.captureConditional
    /**
     * Specifies the next step that the bot runs when the slot value is captured before the code hook times out.
     */
    public val captureNextStep: aws.sdk.kotlin.services.lexmodelsv2.model.DialogState? = builder.captureNextStep
    /**
     * Specifies a list of message groups that Amazon Lex uses to respond the user input.
     */
    public val captureResponse: aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification? = builder.captureResponse
    /**
     * Code hook called after Amazon Lex successfully captures a slot value.
     */
    public val codeHook: aws.sdk.kotlin.services.lexmodelsv2.model.DialogCodeHookInvocationSetting? = builder.codeHook
    /**
     * Code hook called when Amazon Lex doesn't capture a slot value.
     */
    public val elicitationCodeHook: aws.sdk.kotlin.services.lexmodelsv2.model.ElicitationCodeHookInvocationSetting? = builder.elicitationCodeHook
    /**
     * A list of conditional branches to evaluate when the slot value isn't captured.
     */
    public val failureConditional: aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification? = builder.failureConditional
    /**
     * Specifies the next step that the bot runs when the slot value code is not recognized.
     */
    public val failureNextStep: aws.sdk.kotlin.services.lexmodelsv2.model.DialogState? = builder.failureNextStep
    /**
     * Specifies a list of message groups that Amazon Lex uses to respond the user input.
     */
    public val failureResponse: aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification? = builder.failureResponse

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.SlotCaptureSetting = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SlotCaptureSetting(")
        append("captureConditional=$captureConditional,")
        append("captureNextStep=$captureNextStep,")
        append("captureResponse=$captureResponse,")
        append("codeHook=$codeHook,")
        append("elicitationCodeHook=$elicitationCodeHook,")
        append("failureConditional=$failureConditional,")
        append("failureNextStep=$failureNextStep,")
        append("failureResponse=$failureResponse")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = captureConditional?.hashCode() ?: 0
        result = 31 * result + (captureNextStep?.hashCode() ?: 0)
        result = 31 * result + (captureResponse?.hashCode() ?: 0)
        result = 31 * result + (codeHook?.hashCode() ?: 0)
        result = 31 * result + (elicitationCodeHook?.hashCode() ?: 0)
        result = 31 * result + (failureConditional?.hashCode() ?: 0)
        result = 31 * result + (failureNextStep?.hashCode() ?: 0)
        result = 31 * result + (failureResponse?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SlotCaptureSetting

        if (captureConditional != other.captureConditional) return false
        if (captureNextStep != other.captureNextStep) return false
        if (captureResponse != other.captureResponse) return false
        if (codeHook != other.codeHook) return false
        if (elicitationCodeHook != other.elicitationCodeHook) return false
        if (failureConditional != other.failureConditional) return false
        if (failureNextStep != other.failureNextStep) return false
        if (failureResponse != other.failureResponse) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.SlotCaptureSetting = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of conditional branches to evaluate after the slot value is captured.
         */
        public var captureConditional: aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification? = null
        /**
         * Specifies the next step that the bot runs when the slot value is captured before the code hook times out.
         */
        public var captureNextStep: aws.sdk.kotlin.services.lexmodelsv2.model.DialogState? = null
        /**
         * Specifies a list of message groups that Amazon Lex uses to respond the user input.
         */
        public var captureResponse: aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification? = null
        /**
         * Code hook called after Amazon Lex successfully captures a slot value.
         */
        public var codeHook: aws.sdk.kotlin.services.lexmodelsv2.model.DialogCodeHookInvocationSetting? = null
        /**
         * Code hook called when Amazon Lex doesn't capture a slot value.
         */
        public var elicitationCodeHook: aws.sdk.kotlin.services.lexmodelsv2.model.ElicitationCodeHookInvocationSetting? = null
        /**
         * A list of conditional branches to evaluate when the slot value isn't captured.
         */
        public var failureConditional: aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification? = null
        /**
         * Specifies the next step that the bot runs when the slot value code is not recognized.
         */
        public var failureNextStep: aws.sdk.kotlin.services.lexmodelsv2.model.DialogState? = null
        /**
         * Specifies a list of message groups that Amazon Lex uses to respond the user input.
         */
        public var failureResponse: aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.SlotCaptureSetting) : this() {
            this.captureConditional = x.captureConditional
            this.captureNextStep = x.captureNextStep
            this.captureResponse = x.captureResponse
            this.codeHook = x.codeHook
            this.elicitationCodeHook = x.elicitationCodeHook
            this.failureConditional = x.failureConditional
            this.failureNextStep = x.failureNextStep
            this.failureResponse = x.failureResponse
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.SlotCaptureSetting = SlotCaptureSetting(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification] inside the given [block]
         */
        public fun captureConditional(block: aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification.Builder.() -> kotlin.Unit) {
            this.captureConditional = aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.DialogState] inside the given [block]
         */
        public fun captureNextStep(block: aws.sdk.kotlin.services.lexmodelsv2.model.DialogState.Builder.() -> kotlin.Unit) {
            this.captureNextStep = aws.sdk.kotlin.services.lexmodelsv2.model.DialogState.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification] inside the given [block]
         */
        public fun captureResponse(block: aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification.Builder.() -> kotlin.Unit) {
            this.captureResponse = aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.DialogCodeHookInvocationSetting] inside the given [block]
         */
        public fun codeHook(block: aws.sdk.kotlin.services.lexmodelsv2.model.DialogCodeHookInvocationSetting.Builder.() -> kotlin.Unit) {
            this.codeHook = aws.sdk.kotlin.services.lexmodelsv2.model.DialogCodeHookInvocationSetting.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ElicitationCodeHookInvocationSetting] inside the given [block]
         */
        public fun elicitationCodeHook(block: aws.sdk.kotlin.services.lexmodelsv2.model.ElicitationCodeHookInvocationSetting.Builder.() -> kotlin.Unit) {
            this.elicitationCodeHook = aws.sdk.kotlin.services.lexmodelsv2.model.ElicitationCodeHookInvocationSetting.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification] inside the given [block]
         */
        public fun failureConditional(block: aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification.Builder.() -> kotlin.Unit) {
            this.failureConditional = aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.DialogState] inside the given [block]
         */
        public fun failureNextStep(block: aws.sdk.kotlin.services.lexmodelsv2.model.DialogState.Builder.() -> kotlin.Unit) {
            this.failureNextStep = aws.sdk.kotlin.services.lexmodelsv2.model.DialogState.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification] inside the given [block]
         */
        public fun failureResponse(block: aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification.Builder.() -> kotlin.Unit) {
            this.failureResponse = aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
