// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object containing information about a specific session.
 */
public class SessionSpecification private constructor(builder: Builder) {
    /**
     * The identifier of the alias of the bot that the session was held with.
     */
    public val botAliasId: kotlin.String? = builder.botAliasId
    /**
     * The version of the bot that the session was held with.
     */
    public val botVersion: kotlin.String? = builder.botVersion
    /**
     * The channel that is integrated with the bot that the session was held with.
     */
    public val channel: kotlin.String? = builder.channel
    /**
     * The duration of the conversation in seconds. A conversation is defined as a unique combination of a `sessionId` and an `originatingRequestId`.
     */
    public val conversationDurationSeconds: kotlin.Long? = builder.conversationDurationSeconds
    /**
     * The final state of the conversation. A conversation is defined as a unique combination of a `sessionId` and an `originatingRequestId`.
     */
    public val conversationEndState: aws.sdk.kotlin.services.lexmodelsv2.model.ConversationEndState? = builder.conversationEndState
    /**
     * The date and time when the conversation ended. A conversation is defined as a unique combination of a `sessionId` and an `originatingRequestId`.
     */
    public val conversationEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.conversationEndTime
    /**
     * The date and time when the conversation began. A conversation is defined as a unique combination of a `sessionId` and an `originatingRequestId`.
     */
    public val conversationStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.conversationStartTime
    /**
     * A list of objects containing the name of an intent that was invoked.
     */
    public val invokedIntentSamples: List<InvokedIntentSample>? = builder.invokedIntentSamples
    /**
     * The locale of the bot that the session was held with.
     */
    public val localeId: kotlin.String? = builder.localeId
    /**
     * The mode of the session. The possible values are as follows:
     * + `Speech` – The session was spoken.
     * + `Text` – The session was written.
     * + `DTMF` – The session used a touch-tone keypad (Dual Tone Multi-Frequency).
     * + `MultiMode` – The session used multiple modes.
     */
    public val mode: aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsModality? = builder.mode
    /**
     * The number of turns that the session took.
     */
    public val numberOfTurns: kotlin.Long? = builder.numberOfTurns
    /**
     * The identifier of the first request in a session.
     */
    public val originatingRequestId: kotlin.String? = builder.originatingRequestId
    /**
     * The identifier of the session.
     */
    public val sessionId: kotlin.String? = builder.sessionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.SessionSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SessionSpecification(")
        append("botAliasId=$botAliasId,")
        append("botVersion=$botVersion,")
        append("channel=$channel,")
        append("conversationDurationSeconds=$conversationDurationSeconds,")
        append("conversationEndState=$conversationEndState,")
        append("conversationEndTime=$conversationEndTime,")
        append("conversationStartTime=$conversationStartTime,")
        append("invokedIntentSamples=$invokedIntentSamples,")
        append("localeId=$localeId,")
        append("mode=$mode,")
        append("numberOfTurns=$numberOfTurns,")
        append("originatingRequestId=$originatingRequestId,")
        append("sessionId=$sessionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = botAliasId?.hashCode() ?: 0
        result = 31 * result + (botVersion?.hashCode() ?: 0)
        result = 31 * result + (channel?.hashCode() ?: 0)
        result = 31 * result + (conversationDurationSeconds?.hashCode() ?: 0)
        result = 31 * result + (conversationEndState?.hashCode() ?: 0)
        result = 31 * result + (conversationEndTime?.hashCode() ?: 0)
        result = 31 * result + (conversationStartTime?.hashCode() ?: 0)
        result = 31 * result + (invokedIntentSamples?.hashCode() ?: 0)
        result = 31 * result + (localeId?.hashCode() ?: 0)
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (numberOfTurns?.hashCode() ?: 0)
        result = 31 * result + (originatingRequestId?.hashCode() ?: 0)
        result = 31 * result + (sessionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SessionSpecification

        if (botAliasId != other.botAliasId) return false
        if (botVersion != other.botVersion) return false
        if (channel != other.channel) return false
        if (conversationDurationSeconds != other.conversationDurationSeconds) return false
        if (conversationEndState != other.conversationEndState) return false
        if (conversationEndTime != other.conversationEndTime) return false
        if (conversationStartTime != other.conversationStartTime) return false
        if (invokedIntentSamples != other.invokedIntentSamples) return false
        if (localeId != other.localeId) return false
        if (mode != other.mode) return false
        if (numberOfTurns != other.numberOfTurns) return false
        if (originatingRequestId != other.originatingRequestId) return false
        if (sessionId != other.sessionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.SessionSpecification = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the alias of the bot that the session was held with.
         */
        public var botAliasId: kotlin.String? = null
        /**
         * The version of the bot that the session was held with.
         */
        public var botVersion: kotlin.String? = null
        /**
         * The channel that is integrated with the bot that the session was held with.
         */
        public var channel: kotlin.String? = null
        /**
         * The duration of the conversation in seconds. A conversation is defined as a unique combination of a `sessionId` and an `originatingRequestId`.
         */
        public var conversationDurationSeconds: kotlin.Long? = null
        /**
         * The final state of the conversation. A conversation is defined as a unique combination of a `sessionId` and an `originatingRequestId`.
         */
        public var conversationEndState: aws.sdk.kotlin.services.lexmodelsv2.model.ConversationEndState? = null
        /**
         * The date and time when the conversation ended. A conversation is defined as a unique combination of a `sessionId` and an `originatingRequestId`.
         */
        public var conversationEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time when the conversation began. A conversation is defined as a unique combination of a `sessionId` and an `originatingRequestId`.
         */
        public var conversationStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of objects containing the name of an intent that was invoked.
         */
        public var invokedIntentSamples: List<InvokedIntentSample>? = null
        /**
         * The locale of the bot that the session was held with.
         */
        public var localeId: kotlin.String? = null
        /**
         * The mode of the session. The possible values are as follows:
         * + `Speech` – The session was spoken.
         * + `Text` – The session was written.
         * + `DTMF` – The session used a touch-tone keypad (Dual Tone Multi-Frequency).
         * + `MultiMode` – The session used multiple modes.
         */
        public var mode: aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsModality? = null
        /**
         * The number of turns that the session took.
         */
        public var numberOfTurns: kotlin.Long? = null
        /**
         * The identifier of the first request in a session.
         */
        public var originatingRequestId: kotlin.String? = null
        /**
         * The identifier of the session.
         */
        public var sessionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.SessionSpecification) : this() {
            this.botAliasId = x.botAliasId
            this.botVersion = x.botVersion
            this.channel = x.channel
            this.conversationDurationSeconds = x.conversationDurationSeconds
            this.conversationEndState = x.conversationEndState
            this.conversationEndTime = x.conversationEndTime
            this.conversationStartTime = x.conversationStartTime
            this.invokedIntentSamples = x.invokedIntentSamples
            this.localeId = x.localeId
            this.mode = x.mode
            this.numberOfTurns = x.numberOfTurns
            this.originatingRequestId = x.originatingRequestId
            this.sessionId = x.sessionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.SessionSpecification = SessionSpecification(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
