// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



/**
 * The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.
 */
public class S3BucketTranscriptSource private constructor(builder: Builder) {
    /**
     * The ARN of the KMS key that customer use to encrypt their Amazon S3 bucket. Only use this field if your bucket is encrypted using a customer managed KMS key.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The object that contains a path format that will be applied when Amazon Lex reads the transcript file in the bucket you provide. Specify this object if you only want Lex to read a subset of files in your Amazon S3 bucket.
     */
    public val pathFormat: aws.sdk.kotlin.services.lexmodelsv2.model.PathFormat? = builder.pathFormat
    /**
     * The name of the bucket containing the transcript and the associated metadata.
     */
    public val s3BucketName: kotlin.String = requireNotNull(builder.s3BucketName) { "A non-null value must be provided for s3BucketName" }
    /**
     * The object that contains the filter which will be applied when Amazon Lex reads through the Amazon S3 bucket. Specify this object if you want Amazon Lex to read only a subset of the Amazon S3 bucket based on the filter you provide.
     */
    public val transcriptFilter: aws.sdk.kotlin.services.lexmodelsv2.model.TranscriptFilter? = builder.transcriptFilter
    /**
     * The format of the transcript content. Currently, Genie only supports the Amazon Lex transcript format.
     */
    public val transcriptFormat: aws.sdk.kotlin.services.lexmodelsv2.model.TranscriptFormat = requireNotNull(builder.transcriptFormat) { "A non-null value must be provided for transcriptFormat" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.S3BucketTranscriptSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3BucketTranscriptSource(")
        append("kmsKeyArn=$kmsKeyArn,")
        append("pathFormat=$pathFormat,")
        append("s3BucketName=$s3BucketName,")
        append("transcriptFilter=$transcriptFilter,")
        append("transcriptFormat=$transcriptFormat")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyArn?.hashCode() ?: 0
        result = 31 * result + (pathFormat?.hashCode() ?: 0)
        result = 31 * result + (s3BucketName.hashCode())
        result = 31 * result + (transcriptFilter?.hashCode() ?: 0)
        result = 31 * result + (transcriptFormat.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3BucketTranscriptSource

        if (kmsKeyArn != other.kmsKeyArn) return false
        if (pathFormat != other.pathFormat) return false
        if (s3BucketName != other.s3BucketName) return false
        if (transcriptFilter != other.transcriptFilter) return false
        if (transcriptFormat != other.transcriptFormat) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.S3BucketTranscriptSource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the KMS key that customer use to encrypt their Amazon S3 bucket. Only use this field if your bucket is encrypted using a customer managed KMS key.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The object that contains a path format that will be applied when Amazon Lex reads the transcript file in the bucket you provide. Specify this object if you only want Lex to read a subset of files in your Amazon S3 bucket.
         */
        public var pathFormat: aws.sdk.kotlin.services.lexmodelsv2.model.PathFormat? = null
        /**
         * The name of the bucket containing the transcript and the associated metadata.
         */
        public var s3BucketName: kotlin.String? = null
        /**
         * The object that contains the filter which will be applied when Amazon Lex reads through the Amazon S3 bucket. Specify this object if you want Amazon Lex to read only a subset of the Amazon S3 bucket based on the filter you provide.
         */
        public var transcriptFilter: aws.sdk.kotlin.services.lexmodelsv2.model.TranscriptFilter? = null
        /**
         * The format of the transcript content. Currently, Genie only supports the Amazon Lex transcript format.
         */
        public var transcriptFormat: aws.sdk.kotlin.services.lexmodelsv2.model.TranscriptFormat? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.S3BucketTranscriptSource) : this() {
            this.kmsKeyArn = x.kmsKeyArn
            this.pathFormat = x.pathFormat
            this.s3BucketName = x.s3BucketName
            this.transcriptFilter = x.transcriptFilter
            this.transcriptFormat = x.transcriptFormat
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.S3BucketTranscriptSource = S3BucketTranscriptSource(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.PathFormat] inside the given [block]
         */
        public fun pathFormat(block: aws.sdk.kotlin.services.lexmodelsv2.model.PathFormat.Builder.() -> kotlin.Unit) {
            this.pathFormat = aws.sdk.kotlin.services.lexmodelsv2.model.PathFormat.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.TranscriptFilter] inside the given [block]
         */
        public fun transcriptFilter(block: aws.sdk.kotlin.services.lexmodelsv2.model.TranscriptFilter.Builder.() -> kotlin.Unit) {
            this.transcriptFilter = aws.sdk.kotlin.services.lexmodelsv2.model.TranscriptFilter.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (s3BucketName == null) s3BucketName = ""
            if (transcriptFormat == null) transcriptFormat = TranscriptFormat.SdkUnknown("no value provided")
            return this
        }
    }
}
