// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



/**
 * Specifies the time window that utterance statistics are returned for. The time window is always relative to the last time that the that utterances were aggregated. For example, if the `ListAggregatedUtterances` operation is called at 1600, the time window is set to 1 hour, and the last refresh time was 1530, only utterances made between 1430 and 1530 are returned.
 *
 * You can choose the time window that statistics should be returned for.
 * + **Hours** - You can request utterance statistics for 1, 3, 6, 12, or 24 hour time windows. Statistics are refreshed every half hour for 1 hour time windows, and hourly for the other time windows.
 * + **Days** - You can request utterance statistics for 3 days. Statistics are refreshed every 6 hours.
 * + **Weeks** - You can see statistics for one or two weeks. Statistics are refreshed every 12 hours for one week time windows, and once per day for two week time windows.
 */
public class RelativeAggregationDuration private constructor(builder: Builder) {
    /**
     * The type of time period that the `timeValue` field represents.
     */
    public val timeDimension: aws.sdk.kotlin.services.lexmodelsv2.model.TimeDimension = requireNotNull(builder.timeDimension) { "A non-null value must be provided for timeDimension" }
    /**
     * The period of the time window to gather statistics for. The valid value depends on the setting of the `timeDimension` field.
     * + `Hours` - 1/3/6/12/24
     * + `Days` - 3
     * + `Weeks` - 1/2
     */
    public val timeValue: kotlin.Int = requireNotNull(builder.timeValue) { "A non-null value must be provided for timeValue" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.RelativeAggregationDuration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RelativeAggregationDuration(")
        append("timeDimension=$timeDimension,")
        append("timeValue=$timeValue")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = timeDimension.hashCode()
        result = 31 * result + (timeValue)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RelativeAggregationDuration

        if (timeDimension != other.timeDimension) return false
        if (timeValue != other.timeValue) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.RelativeAggregationDuration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of time period that the `timeValue` field represents.
         */
        public var timeDimension: aws.sdk.kotlin.services.lexmodelsv2.model.TimeDimension? = null
        /**
         * The period of the time window to gather statistics for. The valid value depends on the setting of the `timeDimension` field.
         * + `Hours` - 1/3/6/12/24
         * + `Days` - 3
         * + `Weeks` - 1/2
         */
        public var timeValue: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.RelativeAggregationDuration) : this() {
            this.timeDimension = x.timeDimension
            this.timeValue = x.timeValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.RelativeAggregationDuration = RelativeAggregationDuration(this)

        internal fun correctErrors(): Builder {
            if (timeDimension == null) timeDimension = TimeDimension.SdkUnknown("no value provided")
            if (timeValue == null) timeValue = 0
            return this
        }
    }
}
