// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



/**
 * Specifies a list of message groups that Amazon Lex sends to a user to elicit a response.
 */
public class PromptSpecification private constructor(builder: Builder) {
    /**
     * Indicates whether the user can interrupt a speech prompt from the bot.
     */
    public val allowInterrupt: kotlin.Boolean? = builder.allowInterrupt
    /**
     * The maximum number of times the bot tries to elicit a response from the user using this prompt.
     */
    public val maxRetries: kotlin.Int = requireNotNull(builder.maxRetries) { "A non-null value must be provided for maxRetries" }
    /**
     * A collection of messages that Amazon Lex can send to the user. Amazon Lex chooses the actual message to send at runtime.
     */
    public val messageGroups: List<MessageGroup> = requireNotNull(builder.messageGroups) { "A non-null value must be provided for messageGroups" }
    /**
     * Indicates how a message is selected from a message group among retries.
     */
    public val messageSelectionStrategy: aws.sdk.kotlin.services.lexmodelsv2.model.MessageSelectionStrategy? = builder.messageSelectionStrategy
    /**
     * Specifies the advanced settings on each attempt of the prompt.
     */
    public val promptAttemptsSpecification: Map<String, PromptAttemptSpecification>? = builder.promptAttemptsSpecification

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PromptSpecification(")
        append("allowInterrupt=$allowInterrupt,")
        append("maxRetries=$maxRetries,")
        append("messageGroups=$messageGroups,")
        append("messageSelectionStrategy=$messageSelectionStrategy,")
        append("promptAttemptsSpecification=$promptAttemptsSpecification")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowInterrupt?.hashCode() ?: 0
        result = 31 * result + (maxRetries)
        result = 31 * result + (messageGroups.hashCode())
        result = 31 * result + (messageSelectionStrategy?.hashCode() ?: 0)
        result = 31 * result + (promptAttemptsSpecification?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PromptSpecification

        if (allowInterrupt != other.allowInterrupt) return false
        if (maxRetries != other.maxRetries) return false
        if (messageGroups != other.messageGroups) return false
        if (messageSelectionStrategy != other.messageSelectionStrategy) return false
        if (promptAttemptsSpecification != other.promptAttemptsSpecification) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether the user can interrupt a speech prompt from the bot.
         */
        public var allowInterrupt: kotlin.Boolean? = null
        /**
         * The maximum number of times the bot tries to elicit a response from the user using this prompt.
         */
        public var maxRetries: kotlin.Int? = null
        /**
         * A collection of messages that Amazon Lex can send to the user. Amazon Lex chooses the actual message to send at runtime.
         */
        public var messageGroups: List<MessageGroup>? = null
        /**
         * Indicates how a message is selected from a message group among retries.
         */
        public var messageSelectionStrategy: aws.sdk.kotlin.services.lexmodelsv2.model.MessageSelectionStrategy? = null
        /**
         * Specifies the advanced settings on each attempt of the prompt.
         */
        public var promptAttemptsSpecification: Map<String, PromptAttemptSpecification>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification) : this() {
            this.allowInterrupt = x.allowInterrupt
            this.maxRetries = x.maxRetries
            this.messageGroups = x.messageGroups
            this.messageSelectionStrategy = x.messageSelectionStrategy
            this.promptAttemptsSpecification = x.promptAttemptsSpecification
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification = PromptSpecification(this)

        internal fun correctErrors(): Builder {
            if (maxRetries == null) maxRetries = 0
            if (messageGroups == null) messageGroups = emptyList()
            return this
        }
    }
}
