// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



public class ListSlotsRequest private constructor(builder: Builder) {
    /**
     * The identifier of the bot that contains the slot.
     */
    public val botId: kotlin.String? = builder.botId
    /**
     * The version of the bot that contains the slot.
     */
    public val botVersion: kotlin.String? = builder.botVersion
    /**
     * Provides the specification of a filter used to limit the slots in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.
     */
    public val filters: List<SlotFilter>? = builder.filters
    /**
     * The unique identifier of the intent that contains the slot.
     */
    public val intentId: kotlin.String? = builder.intentId
    /**
     * The identifier of the language and locale of the slots to list. The string must match one of the supported locales. For more information, see [Supported languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
     */
    public val localeId: kotlin.String? = builder.localeId
    /**
     * The maximum number of slots to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * If the response from the `ListSlots` operation contains more results than specified in the `maxResults` parameter, a token is returned in the response. Use that token in the `nextToken` parameter to return the next page of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Determines the sort order for the response from the `ListSlots` operation. You can choose to sort by the slot name or last updated date in either ascending or descending order.
     */
    public val sortBy: aws.sdk.kotlin.services.lexmodelsv2.model.SlotSortBy? = builder.sortBy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.ListSlotsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListSlotsRequest(")
        append("botId=$botId,")
        append("botVersion=$botVersion,")
        append("filters=$filters,")
        append("intentId=$intentId,")
        append("localeId=$localeId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("sortBy=$sortBy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = botId?.hashCode() ?: 0
        result = 31 * result + (botVersion?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (intentId?.hashCode() ?: 0)
        result = 31 * result + (localeId?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListSlotsRequest

        if (botId != other.botId) return false
        if (botVersion != other.botVersion) return false
        if (filters != other.filters) return false
        if (intentId != other.intentId) return false
        if (localeId != other.localeId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (sortBy != other.sortBy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.ListSlotsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the bot that contains the slot.
         */
        public var botId: kotlin.String? = null
        /**
         * The version of the bot that contains the slot.
         */
        public var botVersion: kotlin.String? = null
        /**
         * Provides the specification of a filter used to limit the slots in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.
         */
        public var filters: List<SlotFilter>? = null
        /**
         * The unique identifier of the intent that contains the slot.
         */
        public var intentId: kotlin.String? = null
        /**
         * The identifier of the language and locale of the slots to list. The string must match one of the supported locales. For more information, see [Supported languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
         */
        public var localeId: kotlin.String? = null
        /**
         * The maximum number of slots to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * If the response from the `ListSlots` operation contains more results than specified in the `maxResults` parameter, a token is returned in the response. Use that token in the `nextToken` parameter to return the next page of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Determines the sort order for the response from the `ListSlots` operation. You can choose to sort by the slot name or last updated date in either ascending or descending order.
         */
        public var sortBy: aws.sdk.kotlin.services.lexmodelsv2.model.SlotSortBy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.ListSlotsRequest) : this() {
            this.botId = x.botId
            this.botVersion = x.botVersion
            this.filters = x.filters
            this.intentId = x.intentId
            this.localeId = x.localeId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.sortBy = x.sortBy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.ListSlotsRequest = ListSlotsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.SlotSortBy] inside the given [block]
         */
        public fun sortBy(block: aws.sdk.kotlin.services.lexmodelsv2.model.SlotSortBy.Builder.() -> kotlin.Unit) {
            this.sortBy = aws.sdk.kotlin.services.lexmodelsv2.model.SlotSortBy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
