// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



/**
 * Describes the Amazon S3 bucket name and location for the grammar that is the source for the slot type.
 */
public class GrammarSlotTypeSource private constructor(builder: Builder) {
    /**
     * The KMS key required to decrypt the contents of the grammar, if any.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The name of the Amazon S3 bucket that contains the grammar source.
     */
    public val s3BucketName: kotlin.String = requireNotNull(builder.s3BucketName) { "A non-null value must be provided for s3BucketName" }
    /**
     * The path to the grammar in the Amazon S3 bucket.
     */
    public val s3ObjectKey: kotlin.String = requireNotNull(builder.s3ObjectKey) { "A non-null value must be provided for s3ObjectKey" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.GrammarSlotTypeSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GrammarSlotTypeSource(")
        append("kmsKeyArn=$kmsKeyArn,")
        append("s3BucketName=$s3BucketName,")
        append("s3ObjectKey=$s3ObjectKey")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyArn?.hashCode() ?: 0
        result = 31 * result + (s3BucketName.hashCode())
        result = 31 * result + (s3ObjectKey.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GrammarSlotTypeSource

        if (kmsKeyArn != other.kmsKeyArn) return false
        if (s3BucketName != other.s3BucketName) return false
        if (s3ObjectKey != other.s3ObjectKey) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.GrammarSlotTypeSource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The KMS key required to decrypt the contents of the grammar, if any.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The name of the Amazon S3 bucket that contains the grammar source.
         */
        public var s3BucketName: kotlin.String? = null
        /**
         * The path to the grammar in the Amazon S3 bucket.
         */
        public var s3ObjectKey: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.GrammarSlotTypeSource) : this() {
            this.kmsKeyArn = x.kmsKeyArn
            this.s3BucketName = x.s3BucketName
            this.s3ObjectKey = x.s3ObjectKey
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.GrammarSlotTypeSource = GrammarSlotTypeSource(this)

        internal fun correctErrors(): Builder {
            if (s3BucketName == null) s3BucketName = ""
            if (s3ObjectKey == null) s3ObjectKey = ""
            return this
        }
    }
}
