// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



/**
 * Provides information for updating the user on the progress of fulfilling an intent.
 */
public class FulfillmentUpdatesSpecification private constructor(builder: Builder) {
    /**
     * Determines whether fulfillment updates are sent to the user. When this field is true, updates are sent.
     *
     * If the `active` field is set to true, the `startResponse`, `updateResponse`, and `timeoutInSeconds` fields are required.
     */
    public val active: kotlin.Boolean = requireNotNull(builder.active) { "A non-null value must be provided for active" }
    /**
     * Provides configuration information for the message sent to users when the fulfillment Lambda functions starts running.
     */
    public val startResponse: aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentStartResponseSpecification? = builder.startResponse
    /**
     * The length of time that the fulfillment Lambda function should run before it times out.
     */
    public val timeoutInSeconds: kotlin.Int? = builder.timeoutInSeconds
    /**
     * Provides configuration information for messages sent periodically to the user while the fulfillment Lambda function is running.
     */
    public val updateResponse: aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentUpdateResponseSpecification? = builder.updateResponse

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentUpdatesSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FulfillmentUpdatesSpecification(")
        append("active=$active,")
        append("startResponse=$startResponse,")
        append("timeoutInSeconds=$timeoutInSeconds,")
        append("updateResponse=$updateResponse")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = active.hashCode()
        result = 31 * result + (startResponse?.hashCode() ?: 0)
        result = 31 * result + (timeoutInSeconds ?: 0)
        result = 31 * result + (updateResponse?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FulfillmentUpdatesSpecification

        if (active != other.active) return false
        if (startResponse != other.startResponse) return false
        if (timeoutInSeconds != other.timeoutInSeconds) return false
        if (updateResponse != other.updateResponse) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentUpdatesSpecification = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Determines whether fulfillment updates are sent to the user. When this field is true, updates are sent.
         *
         * If the `active` field is set to true, the `startResponse`, `updateResponse`, and `timeoutInSeconds` fields are required.
         */
        public var active: kotlin.Boolean? = null
        /**
         * Provides configuration information for the message sent to users when the fulfillment Lambda functions starts running.
         */
        public var startResponse: aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentStartResponseSpecification? = null
        /**
         * The length of time that the fulfillment Lambda function should run before it times out.
         */
        public var timeoutInSeconds: kotlin.Int? = null
        /**
         * Provides configuration information for messages sent periodically to the user while the fulfillment Lambda function is running.
         */
        public var updateResponse: aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentUpdateResponseSpecification? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentUpdatesSpecification) : this() {
            this.active = x.active
            this.startResponse = x.startResponse
            this.timeoutInSeconds = x.timeoutInSeconds
            this.updateResponse = x.updateResponse
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentUpdatesSpecification = FulfillmentUpdatesSpecification(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentStartResponseSpecification] inside the given [block]
         */
        public fun startResponse(block: aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentStartResponseSpecification.Builder.() -> kotlin.Unit) {
            this.startResponse = aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentStartResponseSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentUpdateResponseSpecification] inside the given [block]
         */
        public fun updateResponse(block: aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentUpdateResponseSpecification.Builder.() -> kotlin.Unit) {
            this.updateResponse = aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentUpdateResponseSpecification.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (active == null) active = false
            return this
        }
    }
}
