// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



public class CreateResourcePolicyStatementRequest private constructor(builder: Builder) {
    /**
     * The Amazon Lex action that this policy either allows or denies. The action must apply to the resource type of the specified ARN. For more information, see [ Actions, resources, and condition keys for Amazon Lex V2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html).
     */
    public val action: List<String>? = builder.action
    /**
     * Specifies a condition when the policy is in effect. If the principal of the policy is a service principal, you must provide two condition blocks, one with a SourceAccount global condition key and one with a SourceArn global condition key.
     *
     * For more information, see [IAM JSON policy elements: Condition ](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html).
     */
    public val condition: Map<String, Map<String, String>>? = builder.condition
    /**
     * Determines whether the statement allows or denies access to the resource.
     */
    public val effect: aws.sdk.kotlin.services.lexmodelsv2.model.Effect? = builder.effect
    /**
     * The identifier of the revision of the policy to edit. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception.
     *
     * If you don't specify a revision, Amazon Lex overwrites the contents of the policy with the new values.
     */
    public val expectedRevisionId: kotlin.String? = builder.expectedRevisionId
    /**
     * An IAM principal, such as an IAM user, IAM role, or Amazon Web Services services that is allowed or denied access to a resource. For more information, see [Amazon Web Services JSON policy elements: Principal](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html).
     */
    public val principal: List<Principal>? = builder.principal
    /**
     * The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The name of the statement. The ID is the same as the `Sid` IAM property. The statement name must be unique within the policy. For more information, see [IAM JSON policy elements: Sid](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html).
     */
    public val statementId: kotlin.String? = builder.statementId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.CreateResourcePolicyStatementRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateResourcePolicyStatementRequest(")
        append("action=$action,")
        append("condition=$condition,")
        append("effect=$effect,")
        append("expectedRevisionId=$expectedRevisionId,")
        append("principal=$principal,")
        append("resourceArn=$resourceArn,")
        append("statementId=$statementId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (condition?.hashCode() ?: 0)
        result = 31 * result + (effect?.hashCode() ?: 0)
        result = 31 * result + (expectedRevisionId?.hashCode() ?: 0)
        result = 31 * result + (principal?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (statementId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateResourcePolicyStatementRequest

        if (action != other.action) return false
        if (condition != other.condition) return false
        if (effect != other.effect) return false
        if (expectedRevisionId != other.expectedRevisionId) return false
        if (principal != other.principal) return false
        if (resourceArn != other.resourceArn) return false
        if (statementId != other.statementId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.CreateResourcePolicyStatementRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Lex action that this policy either allows or denies. The action must apply to the resource type of the specified ARN. For more information, see [ Actions, resources, and condition keys for Amazon Lex V2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html).
         */
        public var action: List<String>? = null
        /**
         * Specifies a condition when the policy is in effect. If the principal of the policy is a service principal, you must provide two condition blocks, one with a SourceAccount global condition key and one with a SourceArn global condition key.
         *
         * For more information, see [IAM JSON policy elements: Condition ](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html).
         */
        public var condition: Map<String, Map<String, String>>? = null
        /**
         * Determines whether the statement allows or denies access to the resource.
         */
        public var effect: aws.sdk.kotlin.services.lexmodelsv2.model.Effect? = null
        /**
         * The identifier of the revision of the policy to edit. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception.
         *
         * If you don't specify a revision, Amazon Lex overwrites the contents of the policy with the new values.
         */
        public var expectedRevisionId: kotlin.String? = null
        /**
         * An IAM principal, such as an IAM user, IAM role, or Amazon Web Services services that is allowed or denied access to a resource. For more information, see [Amazon Web Services JSON policy elements: Principal](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html).
         */
        public var principal: List<Principal>? = null
        /**
         * The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The name of the statement. The ID is the same as the `Sid` IAM property. The statement name must be unique within the policy. For more information, see [IAM JSON policy elements: Sid](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html).
         */
        public var statementId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.CreateResourcePolicyStatementRequest) : this() {
            this.action = x.action
            this.condition = x.condition
            this.effect = x.effect
            this.expectedRevisionId = x.expectedRevisionId
            this.principal = x.principal
            this.resourceArn = x.resourceArn
            this.statementId = x.statementId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.CreateResourcePolicyStatementRequest = CreateResourcePolicyStatementRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
