// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



public class CreateBotLocaleRequest private constructor(builder: Builder) {
    /**
     * The identifier of the bot to create the locale for.
     */
    public val botId: kotlin.String? = builder.botId
    /**
     * The version of the bot to create the locale for. This can only be the draft version of the bot.
     */
    public val botVersion: kotlin.String? = builder.botVersion
    /**
     * A description of the bot locale. Use this to help identify the bot locale in lists.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Contains specifications about the generative AI capabilities from Amazon Bedrock that you can turn on for your bot.
     */
    public val generativeAiSettings: aws.sdk.kotlin.services.lexmodelsv2.model.GenerativeAiSettings? = builder.generativeAiSettings
    /**
     * The identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see [Supported languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
     */
    public val localeId: kotlin.String? = builder.localeId
    /**
     * Determines the threshold where Amazon Lex will insert the `AMAZON.FallbackIntent`, `AMAZON.KendraSearchIntent`, or both when returning alternative intents. `AMAZON.FallbackIntent` and `AMAZON.KendraSearchIntent` are only inserted if they are configured for the bot.
     *
     * For example, suppose a bot is configured with the confidence threshold of 0.80 and the `AMAZON.FallbackIntent`. Amazon Lex returns three alternative intents with the following confidence scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the `RecognizeText` operation would be:
     * + AMAZON.FallbackIntent
     * + IntentA
     * + IntentB
     * + IntentC
     */
    public val nluIntentConfidenceThreshold: kotlin.Double? = builder.nluIntentConfidenceThreshold
    /**
     * The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.
     */
    public val voiceSettings: aws.sdk.kotlin.services.lexmodelsv2.model.VoiceSettings? = builder.voiceSettings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotLocaleRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateBotLocaleRequest(")
        append("botId=$botId,")
        append("botVersion=$botVersion,")
        append("description=$description,")
        append("generativeAiSettings=$generativeAiSettings,")
        append("localeId=$localeId,")
        append("nluIntentConfidenceThreshold=$nluIntentConfidenceThreshold,")
        append("voiceSettings=$voiceSettings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = botId?.hashCode() ?: 0
        result = 31 * result + (botVersion?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (generativeAiSettings?.hashCode() ?: 0)
        result = 31 * result + (localeId?.hashCode() ?: 0)
        result = 31 * result + (nluIntentConfidenceThreshold?.hashCode() ?: 0)
        result = 31 * result + (voiceSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateBotLocaleRequest

        if (botId != other.botId) return false
        if (botVersion != other.botVersion) return false
        if (description != other.description) return false
        if (generativeAiSettings != other.generativeAiSettings) return false
        if (localeId != other.localeId) return false
        if (nluIntentConfidenceThreshold != other.nluIntentConfidenceThreshold) return false
        if (voiceSettings != other.voiceSettings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotLocaleRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the bot to create the locale for.
         */
        public var botId: kotlin.String? = null
        /**
         * The version of the bot to create the locale for. This can only be the draft version of the bot.
         */
        public var botVersion: kotlin.String? = null
        /**
         * A description of the bot locale. Use this to help identify the bot locale in lists.
         */
        public var description: kotlin.String? = null
        /**
         * Contains specifications about the generative AI capabilities from Amazon Bedrock that you can turn on for your bot.
         */
        public var generativeAiSettings: aws.sdk.kotlin.services.lexmodelsv2.model.GenerativeAiSettings? = null
        /**
         * The identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see [Supported languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
         */
        public var localeId: kotlin.String? = null
        /**
         * Determines the threshold where Amazon Lex will insert the `AMAZON.FallbackIntent`, `AMAZON.KendraSearchIntent`, or both when returning alternative intents. `AMAZON.FallbackIntent` and `AMAZON.KendraSearchIntent` are only inserted if they are configured for the bot.
         *
         * For example, suppose a bot is configured with the confidence threshold of 0.80 and the `AMAZON.FallbackIntent`. Amazon Lex returns three alternative intents with the following confidence scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the `RecognizeText` operation would be:
         * + AMAZON.FallbackIntent
         * + IntentA
         * + IntentB
         * + IntentC
         */
        public var nluIntentConfidenceThreshold: kotlin.Double? = null
        /**
         * The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.
         */
        public var voiceSettings: aws.sdk.kotlin.services.lexmodelsv2.model.VoiceSettings? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotLocaleRequest) : this() {
            this.botId = x.botId
            this.botVersion = x.botVersion
            this.description = x.description
            this.generativeAiSettings = x.generativeAiSettings
            this.localeId = x.localeId
            this.nluIntentConfidenceThreshold = x.nluIntentConfidenceThreshold
            this.voiceSettings = x.voiceSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotLocaleRequest = CreateBotLocaleRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.GenerativeAiSettings] inside the given [block]
         */
        public fun generativeAiSettings(block: aws.sdk.kotlin.services.lexmodelsv2.model.GenerativeAiSettings.Builder.() -> kotlin.Unit) {
            this.generativeAiSettings = aws.sdk.kotlin.services.lexmodelsv2.model.GenerativeAiSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.VoiceSettings] inside the given [block]
         */
        public fun voiceSettings(block: aws.sdk.kotlin.services.lexmodelsv2.model.VoiceSettings.Builder.() -> kotlin.Unit) {
            this.voiceSettings = aws.sdk.kotlin.services.lexmodelsv2.model.VoiceSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
