// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



public class CreateBotAliasRequest private constructor(builder: Builder) {
    /**
     * Maps configuration information to a specific locale. You can use this parameter to specify a specific Lambda function to run different functions in different locales.
     */
    public val botAliasLocaleSettings: Map<String, BotAliasLocaleSettings>? = builder.botAliasLocaleSettings
    /**
     * The alias to create. The name must be unique for the bot.
     */
    public val botAliasName: kotlin.String? = builder.botAliasName
    /**
     * The unique identifier of the bot that the alias applies to.
     */
    public val botId: kotlin.String? = builder.botId
    /**
     * The version of the bot that this alias points to. You can use the [UpdateBotAlias](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_UpdateBotAlias.html) operation to change the bot version associated with the alias.
     */
    public val botVersion: kotlin.String? = builder.botVersion
    /**
     * Specifies whether Amazon Lex logs text and audio for a conversation with the bot. When you enable conversation logs, text logs store text input, transcripts of audio input, and associated metadata in Amazon CloudWatch Logs. Audio logs store audio input in Amazon S3.
     */
    public val conversationLogSettings: aws.sdk.kotlin.services.lexmodelsv2.model.ConversationLogSettings? = builder.conversationLogSettings
    /**
     * A description of the alias. Use this description to help identify the alias.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.
     */
    public val sentimentAnalysisSettings: aws.sdk.kotlin.services.lexmodelsv2.model.SentimentAnalysisSettings? = builder.sentimentAnalysisSettings
    /**
     * A list of tags to add to the bot alias. You can only add tags when you create an alias, you can't use the `UpdateBotAlias` operation to update the tags on a bot alias. To update tags, use the `TagResource` operation.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotAliasRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateBotAliasRequest(")
        append("botAliasLocaleSettings=$botAliasLocaleSettings,")
        append("botAliasName=$botAliasName,")
        append("botId=$botId,")
        append("botVersion=$botVersion,")
        append("conversationLogSettings=$conversationLogSettings,")
        append("description=$description,")
        append("sentimentAnalysisSettings=$sentimentAnalysisSettings,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = botAliasLocaleSettings?.hashCode() ?: 0
        result = 31 * result + (botAliasName?.hashCode() ?: 0)
        result = 31 * result + (botId?.hashCode() ?: 0)
        result = 31 * result + (botVersion?.hashCode() ?: 0)
        result = 31 * result + (conversationLogSettings?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (sentimentAnalysisSettings?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateBotAliasRequest

        if (botAliasLocaleSettings != other.botAliasLocaleSettings) return false
        if (botAliasName != other.botAliasName) return false
        if (botId != other.botId) return false
        if (botVersion != other.botVersion) return false
        if (conversationLogSettings != other.conversationLogSettings) return false
        if (description != other.description) return false
        if (sentimentAnalysisSettings != other.sentimentAnalysisSettings) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotAliasRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Maps configuration information to a specific locale. You can use this parameter to specify a specific Lambda function to run different functions in different locales.
         */
        public var botAliasLocaleSettings: Map<String, BotAliasLocaleSettings>? = null
        /**
         * The alias to create. The name must be unique for the bot.
         */
        public var botAliasName: kotlin.String? = null
        /**
         * The unique identifier of the bot that the alias applies to.
         */
        public var botId: kotlin.String? = null
        /**
         * The version of the bot that this alias points to. You can use the [UpdateBotAlias](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_UpdateBotAlias.html) operation to change the bot version associated with the alias.
         */
        public var botVersion: kotlin.String? = null
        /**
         * Specifies whether Amazon Lex logs text and audio for a conversation with the bot. When you enable conversation logs, text logs store text input, transcripts of audio input, and associated metadata in Amazon CloudWatch Logs. Audio logs store audio input in Amazon S3.
         */
        public var conversationLogSettings: aws.sdk.kotlin.services.lexmodelsv2.model.ConversationLogSettings? = null
        /**
         * A description of the alias. Use this description to help identify the alias.
         */
        public var description: kotlin.String? = null
        /**
         * Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.
         */
        public var sentimentAnalysisSettings: aws.sdk.kotlin.services.lexmodelsv2.model.SentimentAnalysisSettings? = null
        /**
         * A list of tags to add to the bot alias. You can only add tags when you create an alias, you can't use the `UpdateBotAlias` operation to update the tags on a bot alias. To update tags, use the `TagResource` operation.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotAliasRequest) : this() {
            this.botAliasLocaleSettings = x.botAliasLocaleSettings
            this.botAliasName = x.botAliasName
            this.botId = x.botId
            this.botVersion = x.botVersion
            this.conversationLogSettings = x.conversationLogSettings
            this.description = x.description
            this.sentimentAnalysisSettings = x.sentimentAnalysisSettings
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotAliasRequest = CreateBotAliasRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ConversationLogSettings] inside the given [block]
         */
        public fun conversationLogSettings(block: aws.sdk.kotlin.services.lexmodelsv2.model.ConversationLogSettings.Builder.() -> kotlin.Unit) {
            this.conversationLogSettings = aws.sdk.kotlin.services.lexmodelsv2.model.ConversationLogSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.SentimentAnalysisSettings] inside the given [block]
         */
        public fun sentimentAnalysisSettings(block: aws.sdk.kotlin.services.lexmodelsv2.model.SentimentAnalysisSettings.Builder.() -> kotlin.Unit) {
            this.sentimentAnalysisSettings = aws.sdk.kotlin.services.lexmodelsv2.model.SentimentAnalysisSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
