// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



/**
 * Provides a list of conditional branches. Branches are evaluated in the order that they are entered in the list. The first branch with a condition that evaluates to true is executed. The last branch in the list is the default branch. The default branch should not have any condition expression. The default branch is executed if no other branch has a matching condition.
 */
public class ConditionalSpecification private constructor(builder: Builder) {
    /**
     * Determines whether a conditional branch is active. When `active` is false, the conditions are not evaluated.
     */
    public val active: kotlin.Boolean = requireNotNull(builder.active) { "A non-null value must be provided for active" }
    /**
     * A list of conditional branches. A conditional branch is made up of a condition, a response and a next step. The response and next step are executed when the condition is true.
     */
    public val conditionalBranches: List<ConditionalBranch> = requireNotNull(builder.conditionalBranches) { "A non-null value must be provided for conditionalBranches" }
    /**
     * The conditional branch that should be followed when the conditions for other branches are not satisfied. A conditional branch is made up of a condition, a response and a next step.
     */
    public val defaultBranch: aws.sdk.kotlin.services.lexmodelsv2.model.DefaultConditionalBranch? = builder.defaultBranch

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConditionalSpecification(")
        append("active=$active,")
        append("conditionalBranches=$conditionalBranches,")
        append("defaultBranch=$defaultBranch")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = active.hashCode()
        result = 31 * result + (conditionalBranches.hashCode())
        result = 31 * result + (defaultBranch?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConditionalSpecification

        if (active != other.active) return false
        if (conditionalBranches != other.conditionalBranches) return false
        if (defaultBranch != other.defaultBranch) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Determines whether a conditional branch is active. When `active` is false, the conditions are not evaluated.
         */
        public var active: kotlin.Boolean? = null
        /**
         * A list of conditional branches. A conditional branch is made up of a condition, a response and a next step. The response and next step are executed when the condition is true.
         */
        public var conditionalBranches: List<ConditionalBranch>? = null
        /**
         * The conditional branch that should be followed when the conditions for other branches are not satisfied. A conditional branch is made up of a condition, a response and a next step.
         */
        public var defaultBranch: aws.sdk.kotlin.services.lexmodelsv2.model.DefaultConditionalBranch? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification) : this() {
            this.active = x.active
            this.conditionalBranches = x.conditionalBranches
            this.defaultBranch = x.defaultBranch
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification = ConditionalSpecification(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.DefaultConditionalBranch] inside the given [block]
         */
        public fun defaultBranch(block: aws.sdk.kotlin.services.lexmodelsv2.model.DefaultConditionalBranch.Builder.() -> kotlin.Unit) {
            this.defaultBranch = aws.sdk.kotlin.services.lexmodelsv2.model.DefaultConditionalBranch.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (active == null) active = false
            if (conditionalBranches == null) conditionalBranches = emptyList()
            return this
        }
    }
}
