// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



/**
 * Provides the bot locale parameters required for importing a bot locale.
 */
public class BotLocaleImportSpecification private constructor(builder: Builder) {
    /**
     * The identifier of the bot to import the locale to.
     */
    public val botId: kotlin.String = requireNotNull(builder.botId) { "A non-null value must be provided for botId" }
    /**
     * The version of the bot to import the locale to. This can only be the `DRAFT` version of the bot.
     */
    public val botVersion: kotlin.String = requireNotNull(builder.botVersion) { "A non-null value must be provided for botVersion" }
    /**
     * The identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see [Supported languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
     */
    public val localeId: kotlin.String = requireNotNull(builder.localeId) { "A non-null value must be provided for localeId" }
    /**
     * Determines the threshold where Amazon Lex will insert the `AMAZON.FallbackIntent`, `AMAZON.KendraSearchIntent`, or both when returning alternative intents. `AMAZON.FallbackIntent` and `AMAZON.KendraSearchIntent` are only inserted if they are configured for the bot.
     *
     * For example, suppose a bot is configured with the confidence threshold of 0.80 and the `AMAZON.FallbackIntent`. Amazon Lex returns three alternative intents with the following confidence scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the `PostText` operation would be:
     * + `AMAZON.FallbackIntent`
     * + `IntentA`
     * + `IntentB`
     * + `IntentC`
     */
    public val nluIntentConfidenceThreshold: kotlin.Double? = builder.nluIntentConfidenceThreshold
    /**
     * Defines settings for using an Amazon Polly voice to communicate with a user.
     */
    public val voiceSettings: aws.sdk.kotlin.services.lexmodelsv2.model.VoiceSettings? = builder.voiceSettings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.BotLocaleImportSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BotLocaleImportSpecification(")
        append("botId=$botId,")
        append("botVersion=$botVersion,")
        append("localeId=$localeId,")
        append("nluIntentConfidenceThreshold=$nluIntentConfidenceThreshold,")
        append("voiceSettings=$voiceSettings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = botId.hashCode()
        result = 31 * result + (botVersion.hashCode())
        result = 31 * result + (localeId.hashCode())
        result = 31 * result + (nluIntentConfidenceThreshold?.hashCode() ?: 0)
        result = 31 * result + (voiceSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BotLocaleImportSpecification

        if (botId != other.botId) return false
        if (botVersion != other.botVersion) return false
        if (localeId != other.localeId) return false
        if (nluIntentConfidenceThreshold != other.nluIntentConfidenceThreshold) return false
        if (voiceSettings != other.voiceSettings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.BotLocaleImportSpecification = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the bot to import the locale to.
         */
        public var botId: kotlin.String? = null
        /**
         * The version of the bot to import the locale to. This can only be the `DRAFT` version of the bot.
         */
        public var botVersion: kotlin.String? = null
        /**
         * The identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see [Supported languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
         */
        public var localeId: kotlin.String? = null
        /**
         * Determines the threshold where Amazon Lex will insert the `AMAZON.FallbackIntent`, `AMAZON.KendraSearchIntent`, or both when returning alternative intents. `AMAZON.FallbackIntent` and `AMAZON.KendraSearchIntent` are only inserted if they are configured for the bot.
         *
         * For example, suppose a bot is configured with the confidence threshold of 0.80 and the `AMAZON.FallbackIntent`. Amazon Lex returns three alternative intents with the following confidence scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the `PostText` operation would be:
         * + `AMAZON.FallbackIntent`
         * + `IntentA`
         * + `IntentB`
         * + `IntentC`
         */
        public var nluIntentConfidenceThreshold: kotlin.Double? = null
        /**
         * Defines settings for using an Amazon Polly voice to communicate with a user.
         */
        public var voiceSettings: aws.sdk.kotlin.services.lexmodelsv2.model.VoiceSettings? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.BotLocaleImportSpecification) : this() {
            this.botId = x.botId
            this.botVersion = x.botVersion
            this.localeId = x.localeId
            this.nluIntentConfidenceThreshold = x.nluIntentConfidenceThreshold
            this.voiceSettings = x.voiceSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.BotLocaleImportSpecification = BotLocaleImportSpecification(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.VoiceSettings] inside the given [block]
         */
        public fun voiceSettings(block: aws.sdk.kotlin.services.lexmodelsv2.model.VoiceSettings.Builder.() -> kotlin.Unit) {
            this.voiceSettings = aws.sdk.kotlin.services.lexmodelsv2.model.VoiceSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (botId == null) botId = ""
            if (botVersion == null) botVersion = ""
            if (localeId == null) localeId = ""
            return this
        }
    }
}
