// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



/**
 * Contains the metric and the summary statistic you want to calculate, and the order in which to sort the results, for the utterances across the user sessions with the bot.
 */
public class AnalyticsUtteranceMetric private constructor(builder: Builder) {
    /**
     * The metric for which you want to get utterance summary statistics.
     * + `Count` – The number of utterances.
     * + `Missed` – The number of utterances that Amazon Lex failed to recognize.
     * + `Detected` – The number of utterances that Amazon Lex managed to detect.
     * + `UtteranceTimestamp` – The date and time of the utterance.
     */
    public val name: aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsUtteranceMetricName = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Specifies whether to sort the results in ascending or descending order.
     */
    public val order: aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsSortOrder? = builder.order
    /**
     * The summary statistic to calculate.
     * + `Sum` – The total count for the category you provide in `name`.
     * + `Average` – The total count divided by the number of utterances in the category you provide in `name`.
     * + `Max` – The highest count in the category you provide in `name`.
     */
    public val statistic: aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsMetricStatistic = requireNotNull(builder.statistic) { "A non-null value must be provided for statistic" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsUtteranceMetric = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AnalyticsUtteranceMetric(")
        append("name=$name,")
        append("order=$order,")
        append("statistic=$statistic")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name.hashCode()
        result = 31 * result + (order?.hashCode() ?: 0)
        result = 31 * result + (statistic.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AnalyticsUtteranceMetric

        if (name != other.name) return false
        if (order != other.order) return false
        if (statistic != other.statistic) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsUtteranceMetric = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The metric for which you want to get utterance summary statistics.
         * + `Count` – The number of utterances.
         * + `Missed` – The number of utterances that Amazon Lex failed to recognize.
         * + `Detected` – The number of utterances that Amazon Lex managed to detect.
         * + `UtteranceTimestamp` – The date and time of the utterance.
         */
        public var name: aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsUtteranceMetricName? = null
        /**
         * Specifies whether to sort the results in ascending or descending order.
         */
        public var order: aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsSortOrder? = null
        /**
         * The summary statistic to calculate.
         * + `Sum` – The total count for the category you provide in `name`.
         * + `Average` – The total count divided by the number of utterances in the category you provide in `name`.
         * + `Max` – The highest count in the category you provide in `name`.
         */
        public var statistic: aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsMetricStatistic? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsUtteranceMetric) : this() {
            this.name = x.name
            this.order = x.order
            this.statistic = x.statistic
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsUtteranceMetric = AnalyticsUtteranceMetric(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = AnalyticsUtteranceMetricName.SdkUnknown("no value provided")
            if (statistic == null) statistic = AnalyticsMetricStatistic.SdkUnknown("no value provided")
            return this
        }
    }
}
