// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



/**
 * Contains fields describing a condition by which to filter the intent stages. The expression may be understood as `name``operator``values`. For example:
 * + `IntentName CO Book` – The intent name contains the string "Book."
 * + `BotVersion EQ 2` – The bot version is equal to two.
 *
 * The operators that each filter supports are listed below:
 * + `BotAlias` – `EQ`.
 * + `BotVersion` – `EQ`.
 * + `LocaleId` – `EQ`.
 * + `Modality` – `EQ`.
 * + `Channel` – `EQ`.
 * + `SessionId` – `EQ`.
 * + `OriginatingRequestId` – `EQ`.
 * + `IntentName` – `EQ`, `CO`.
 * + `IntentStageName` – `EQ`, `CO`.
 */
public class AnalyticsIntentStageFilter private constructor(builder: Builder) {
    /**
     * The category by which to filter the intent stages. The descriptions for each option are as follows:
     * + `BotAlias` – The name of the bot alias.
     * + `BotVersion` – The version of the bot.
     * + `LocaleId` – The locale of the bot.
     * + `Modality` – The modality of the session with the bot (audio, DTMF, or text).
     * + `Channel` – The channel that the bot is integrated with.
     * + `SessionId` – The identifier of the session with the bot.
     * + `OriginatingRequestId` – The identifier of the first request in a session.
     * + `IntentName` – The name of the intent.
     * + `IntentStageName` – The stage in the intent.
     */
    public val name: aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsIntentStageFilterName = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The operation by which to filter the category. The following operations are possible:
     * + `CO` – Contains
     * + `EQ` – Equals
     * + `GT` – Greater than
     * + `LT` – Less than
     *
     * The operators that each filter supports are listed below:
     * + `BotAlias` – `EQ`.
     * + `BotVersion` – `EQ`.
     * + `LocaleId` – `EQ`.
     * + `Modality` – `EQ`.
     * + `Channel` – `EQ`.
     * + `SessionId` – `EQ`.
     * + `OriginatingRequestId` – `EQ`.
     * + `IntentName` – `EQ`, `CO`.
     * + `IntentStageName` – `EQ`, `CO`.
     */
    public val operator: aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsFilterOperator = requireNotNull(builder.operator) { "A non-null value must be provided for operator" }
    /**
     * An array containing the values of the category by which to apply the operator to filter the results. You can provide multiple values if the operator is `EQ` or `CO`. If you provide multiple values, you filter for results that equal/contain any of the values. For example, if the `name`, `operator`, and `values` fields are `Modality`, `EQ`, and `[Speech, Text]`, the operation filters for results where the modality was either `Speech` or `Text`.
     */
    public val values: List<String> = requireNotNull(builder.values) { "A non-null value must be provided for values" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsIntentStageFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AnalyticsIntentStageFilter(")
        append("name=$name,")
        append("operator=$operator,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name.hashCode()
        result = 31 * result + (operator.hashCode())
        result = 31 * result + (values.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AnalyticsIntentStageFilter

        if (name != other.name) return false
        if (operator != other.operator) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsIntentStageFilter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The category by which to filter the intent stages. The descriptions for each option are as follows:
         * + `BotAlias` – The name of the bot alias.
         * + `BotVersion` – The version of the bot.
         * + `LocaleId` – The locale of the bot.
         * + `Modality` – The modality of the session with the bot (audio, DTMF, or text).
         * + `Channel` – The channel that the bot is integrated with.
         * + `SessionId` – The identifier of the session with the bot.
         * + `OriginatingRequestId` – The identifier of the first request in a session.
         * + `IntentName` – The name of the intent.
         * + `IntentStageName` – The stage in the intent.
         */
        public var name: aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsIntentStageFilterName? = null
        /**
         * The operation by which to filter the category. The following operations are possible:
         * + `CO` – Contains
         * + `EQ` – Equals
         * + `GT` – Greater than
         * + `LT` – Less than
         *
         * The operators that each filter supports are listed below:
         * + `BotAlias` – `EQ`.
         * + `BotVersion` – `EQ`.
         * + `LocaleId` – `EQ`.
         * + `Modality` – `EQ`.
         * + `Channel` – `EQ`.
         * + `SessionId` – `EQ`.
         * + `OriginatingRequestId` – `EQ`.
         * + `IntentName` – `EQ`, `CO`.
         * + `IntentStageName` – `EQ`, `CO`.
         */
        public var operator: aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsFilterOperator? = null
        /**
         * An array containing the values of the category by which to apply the operator to filter the results. You can provide multiple values if the operator is `EQ` or `CO`. If you provide multiple values, you filter for results that equal/contain any of the values. For example, if the `name`, `operator`, and `values` fields are `Modality`, `EQ`, and `[Speech, Text]`, the operation filters for results where the modality was either `Speech` or `Text`.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsIntentStageFilter) : this() {
            this.name = x.name
            this.operator = x.operator
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsIntentStageFilter = AnalyticsIntentStageFilter(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = AnalyticsIntentStageFilterName.SdkUnknown("no value provided")
            if (operator == null) operator = AnalyticsFilterOperator.SdkUnknown("no value provided")
            if (values == null) values = emptyList()
            return this
        }
    }
}
