// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



/**
 * An object containing the results for the intent metric you requested.
 */
public class AnalyticsIntentMetricResult private constructor(builder: Builder) {
    /**
     * The metric that you requested. See [Key definitions](https://docs.aws.amazon.com/lexv2/latest/dg/analytics-key-definitions.html) for more details about these metrics.
     * + `Count` – The number of times the intent was invoked.
     * + `Success` – The number of times the intent succeeded.
     * + `Failure` – The number of times the intent failed.
     * + `Switched` – The number of times there was a switch to a different intent.
     * + `Dropped` – The number of times the user dropped the intent.
     */
    public val name: aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsIntentMetricName? = builder.name
    /**
     * The statistic that you requested to calculate.
     * + `Sum` – The total count for the category you provide in `name`.
     * + `Average` – The total count divided by the number of intents in the category you provide in `name`.
     * + `Max` – The highest count in the category you provide in `name`.
     */
    public val statistic: aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsMetricStatistic? = builder.statistic
    /**
     * The value of the summary statistic for the metric that you requested.
     */
    public val value: kotlin.Double? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsIntentMetricResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AnalyticsIntentMetricResult(")
        append("name=$name,")
        append("statistic=$statistic,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (statistic?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AnalyticsIntentMetricResult

        if (name != other.name) return false
        if (statistic != other.statistic) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsIntentMetricResult = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The metric that you requested. See [Key definitions](https://docs.aws.amazon.com/lexv2/latest/dg/analytics-key-definitions.html) for more details about these metrics.
         * + `Count` – The number of times the intent was invoked.
         * + `Success` – The number of times the intent succeeded.
         * + `Failure` – The number of times the intent failed.
         * + `Switched` – The number of times there was a switch to a different intent.
         * + `Dropped` – The number of times the user dropped the intent.
         */
        public var name: aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsIntentMetricName? = null
        /**
         * The statistic that you requested to calculate.
         * + `Sum` – The total count for the category you provide in `name`.
         * + `Average` – The total count divided by the number of intents in the category you provide in `name`.
         * + `Max` – The highest count in the category you provide in `name`.
         */
        public var statistic: aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsMetricStatistic? = null
        /**
         * The value of the summary statistic for the metric that you requested.
         */
        public var value: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsIntentMetricResult) : this() {
            this.name = x.name
            this.statistic = x.statistic
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsIntentMetricResult = AnalyticsIntentMetricResult(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
