// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.lexmodelsv2.auth.DefaultLexModelsV2AuthSchemeProvider
import aws.sdk.kotlin.services.lexmodelsv2.auth.LexModelsV2AuthSchemeProvider
import aws.sdk.kotlin.services.lexmodelsv2.endpoints.DefaultLexModelsV2EndpointProvider
import aws.sdk.kotlin.services.lexmodelsv2.endpoints.LexModelsV2EndpointParameters
import aws.sdk.kotlin.services.lexmodelsv2.endpoints.LexModelsV2EndpointProvider
import aws.sdk.kotlin.services.lexmodelsv2.model.BatchCreateCustomVocabularyItemRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.BatchCreateCustomVocabularyItemResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.BatchDeleteCustomVocabularyItemRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.BatchDeleteCustomVocabularyItemResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.BatchUpdateCustomVocabularyItemRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.BatchUpdateCustomVocabularyItemResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.BuildBotLocaleRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.BuildBotLocaleResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotAliasRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotAliasResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotLocaleRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotLocaleResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotVersionRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotVersionResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateExportRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateExportResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateIntentRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateIntentResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateResourcePolicyRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateResourcePolicyResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateResourcePolicyStatementRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateResourcePolicyStatementResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateSlotRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateSlotResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateSlotTypeRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateSlotTypeResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateTestSetDiscrepancyReportRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateTestSetDiscrepancyReportResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateUploadUrlRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateUploadUrlResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteBotAliasRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteBotAliasResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteBotLocaleRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteBotLocaleResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteBotRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteBotResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteBotVersionRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteBotVersionResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteCustomVocabularyRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteCustomVocabularyResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteExportRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteExportResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteImportRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteImportResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteIntentRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteIntentResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteResourcePolicyRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteResourcePolicyResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteResourcePolicyStatementRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteResourcePolicyStatementResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteSlotRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteSlotResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteSlotTypeRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteSlotTypeResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteTestSetRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteTestSetResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteUtterancesRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteUtterancesResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotAliasRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotAliasResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotLocaleRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotLocaleResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotRecommendationRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotRecommendationResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotResourceGenerationRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotResourceGenerationResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotVersionRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotVersionResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeCustomVocabularyMetadataRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeCustomVocabularyMetadataResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeExportRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeExportResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeImportRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeImportResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeIntentRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeIntentResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeResourcePolicyRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeResourcePolicyResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeSlotRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeSlotResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeSlotTypeRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeSlotTypeResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeTestExecutionRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeTestExecutionResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeTestSetDiscrepancyReportRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeTestSetDiscrepancyReportResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeTestSetGenerationRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeTestSetGenerationResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeTestSetRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeTestSetResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.GenerateBotElementRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.GenerateBotElementResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.GetTestExecutionArtifactsUrlRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.GetTestExecutionArtifactsUrlResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListAggregatedUtterancesRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListAggregatedUtterancesResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListBotAliasesRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListBotAliasesResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListBotLocalesRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListBotLocalesResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListBotRecommendationsRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListBotRecommendationsResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListBotResourceGenerationsRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListBotResourceGenerationsResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListBotVersionsRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListBotVersionsResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListBotsRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListBotsResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListBuiltInIntentsRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListBuiltInIntentsResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListCustomVocabularyItemsRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListCustomVocabularyItemsResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListExportsRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListExportsResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListImportsRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListImportsResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListIntentMetricsRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListIntentMetricsResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListIntentPathsRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListIntentPathsResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListIntentStageMetricsRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListIntentStageMetricsResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListIntentsRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListIntentsResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListRecommendedIntentsRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListRecommendedIntentsResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListSessionAnalyticsDataRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListSessionAnalyticsDataResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListSessionMetricsRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListSessionMetricsResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListSlotTypesRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListSlotTypesResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListSlotsRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListSlotsResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListTestExecutionResultItemsRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListTestExecutionResultItemsResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListTestExecutionsRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListTestExecutionsResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListTestSetRecordsRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListTestSetRecordsResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListTestSetsRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListTestSetsResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListUtteranceAnalyticsDataRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListUtteranceAnalyticsDataResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ListUtteranceMetricsRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.ListUtteranceMetricsResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.SearchAssociatedTranscriptsRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.SearchAssociatedTranscriptsResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.StartBotRecommendationRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.StartBotRecommendationResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.StartBotResourceGenerationRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.StartBotResourceGenerationResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.StartImportRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.StartImportResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.StartTestExecutionRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.StartTestExecutionResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.StartTestSetGenerationRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.StartTestSetGenerationResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.StopBotRecommendationRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.StopBotRecommendationResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.TagResourceRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.TagResourceResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.UntagResourceRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.UntagResourceResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.UpdateBotAliasRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.UpdateBotAliasResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.UpdateBotLocaleRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.UpdateBotLocaleResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.UpdateBotRecommendationRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.UpdateBotRecommendationResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.UpdateBotRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.UpdateBotResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.UpdateExportRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.UpdateExportResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.UpdateIntentRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.UpdateIntentResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.UpdateResourcePolicyRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.UpdateResourcePolicyResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.UpdateSlotRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.UpdateSlotResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.UpdateSlotTypeRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.UpdateSlotTypeResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.UpdateTestSetRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.UpdateTestSetResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Lex Models V2"
public const val SdkVersion: String = "1.0.19"
public const val ServiceApiVersion: String = "2020-08-07"

/**
 *
 */
public interface LexModelsV2Client : SdkClient {
    /**
     * LexModelsV2Client's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, LexModelsV2Client, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "LexModelsV2",
                "LEX_MODELS_V2",
                "lex_models_v2",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, LexModelsV2Client>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): LexModelsV2Client = DefaultLexModelsV2Client(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: LexModelsV2EndpointProvider = builder.endpointProvider ?: DefaultLexModelsV2EndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: LexModelsV2AuthSchemeProvider = builder.authSchemeProvider ?: DefaultLexModelsV2AuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Lex Models V2"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: LexModelsV2EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: LexModelsV2AuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Create a batch of custom vocabulary items for a given bot locale's custom vocabulary.
     */
    public suspend fun batchCreateCustomVocabularyItem(input: BatchCreateCustomVocabularyItemRequest): BatchCreateCustomVocabularyItemResponse

    /**
     * Delete a batch of custom vocabulary items for a given bot locale's custom vocabulary.
     */
    public suspend fun batchDeleteCustomVocabularyItem(input: BatchDeleteCustomVocabularyItemRequest): BatchDeleteCustomVocabularyItemResponse

    /**
     * Update a batch of custom vocabulary items for a given bot locale's custom vocabulary.
     */
    public suspend fun batchUpdateCustomVocabularyItem(input: BatchUpdateCustomVocabularyItemRequest): BatchUpdateCustomVocabularyItemResponse

    /**
     * Builds a bot, its intents, and its slot types into a specific locale. A bot can be built into multiple locales. At runtime the locale is used to choose a specific build of the bot.
     */
    public suspend fun buildBotLocale(input: BuildBotLocaleRequest): BuildBotLocaleResponse

    /**
     * Creates an Amazon Lex conversational bot.
     */
    public suspend fun createBot(input: CreateBotRequest): CreateBotResponse

    /**
     * Creates an alias for the specified version of a bot. Use an alias to enable you to change the version of a bot without updating applications that use the bot.
     *
     * For example, you can create an alias called "PROD" that your applications use to call the Amazon Lex bot.
     */
    public suspend fun createBotAlias(input: CreateBotAliasRequest): CreateBotAliasResponse

    /**
     * Creates a locale in the bot. The locale contains the intents and slot types that the bot uses in conversations with users in the specified language and locale. You must add a locale to a bot before you can add intents and slot types to the bot.
     */
    public suspend fun createBotLocale(input: CreateBotLocaleRequest): CreateBotLocaleResponse

    /**
     * Creates an immutable version of the bot. When you create the first version of a bot, Amazon Lex sets the version number to 1. Subsequent bot versions increase in an increment of 1. The version number will always represent the total number of versions created of the bot, not the current number of versions. If a bot version is deleted, that bot version number will not be reused.
     */
    public suspend fun createBotVersion(input: CreateBotVersionRequest): CreateBotVersionResponse

    /**
     * Creates a zip archive containing the contents of a bot or a bot locale. The archive contains a directory structure that contains JSON files that define the bot.
     *
     * You can create an archive that contains the complete definition of a bot, or you can specify that the archive contain only the definition of a single bot locale.
     *
     * For more information about exporting bots, and about the structure of the export archive, see [ Importing and exporting bots ](https://docs.aws.amazon.com/lexv2/latest/dg/importing-exporting.html)
     */
    public suspend fun createExport(input: CreateExportRequest): CreateExportResponse

    /**
     * Creates an intent.
     *
     * To define the interaction between the user and your bot, you define one or more intents. For example, for a pizza ordering bot you would create an `OrderPizza` intent.
     *
     * When you create an intent, you must provide a name. You can optionally provide the following:
     * + Sample utterances. For example, "I want to order a pizza" and "Can I order a pizza." You can't provide utterances for built-in intents.
     * + Information to be gathered. You specify slots for the information that you bot requests from the user. You can specify standard slot types, such as date and time, or custom slot types for your application.
     * + How the intent is fulfilled. You can provide a Lambda function or configure the intent to return the intent information to your client application. If you use a Lambda function, Amazon Lex invokes the function when all of the intent information is available.
     * + A confirmation prompt to send to the user to confirm an intent. For example, "Shall I order your pizza?"
     * + A conclusion statement to send to the user after the intent is fulfilled. For example, "I ordered your pizza."
     * + A follow-up prompt that asks the user for additional activity. For example, "Do you want a drink with your pizza?"
     */
    public suspend fun createIntent(input: CreateIntentRequest): CreateIntentResponse

    /**
     * Creates a new resource policy with the specified policy statements.
     */
    public suspend fun createResourcePolicy(input: CreateResourcePolicyRequest): CreateResourcePolicyResponse

    /**
     * Adds a new resource policy statement to a bot or bot alias. If a resource policy exists, the statement is added to the current resource policy. If a policy doesn't exist, a new policy is created.
     *
     * You can't create a resource policy statement that allows cross-account access.
     */
    public suspend fun createResourcePolicyStatement(input: CreateResourcePolicyStatementRequest): CreateResourcePolicyStatementResponse

    /**
     * Creates a slot in an intent. A slot is a variable needed to fulfill an intent. For example, an `OrderPizza` intent might need slots for size, crust, and number of pizzas. For each slot, you define one or more utterances that Amazon Lex uses to elicit a response from the user.
     */
    public suspend fun createSlot(input: CreateSlotRequest): CreateSlotResponse

    /**
     * Creates a custom slot type
     *
     *  To create a custom slot type, specify a name for the slot type and a set of enumeration values, the values that a slot of this type can assume.
     */
    public suspend fun createSlotType(input: CreateSlotTypeRequest): CreateSlotTypeResponse

    /**
     * Create a report that describes the differences between the bot and the test set.
     */
    public suspend fun createTestSetDiscrepancyReport(input: CreateTestSetDiscrepancyReportRequest): CreateTestSetDiscrepancyReportResponse

    /**
     * Gets a pre-signed S3 write URL that you use to upload the zip archive when importing a bot or a bot locale.
     */
    public suspend fun createUploadUrl(input: CreateUploadUrlRequest = CreateUploadUrlRequest { }): CreateUploadUrlResponse

    /**
     * Deletes all versions of a bot, including the `Draft` version. To delete a specific version, use the `DeleteBotVersion` operation.
     *
     * When you delete a bot, all of the resources contained in the bot are also deleted. Deleting a bot removes all locales, intents, slot, and slot types defined for the bot.
     *
     * If a bot has an alias, the `DeleteBot` operation returns a `ResourceInUseException` exception. If you want to delete the bot and the alias, set the `skipResourceInUseCheck` parameter to `true`.
     */
    public suspend fun deleteBot(input: DeleteBotRequest): DeleteBotResponse

    /**
     * Deletes the specified bot alias.
     */
    public suspend fun deleteBotAlias(input: DeleteBotAliasRequest): DeleteBotAliasResponse

    /**
     * Removes a locale from a bot.
     *
     * When you delete a locale, all intents, slots, and slot types defined for the locale are also deleted.
     */
    public suspend fun deleteBotLocale(input: DeleteBotLocaleRequest): DeleteBotLocaleResponse

    /**
     * Deletes a specific version of a bot. To delete all versions of a bot, use the [DeleteBot](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DeleteBot.html) operation.
     */
    public suspend fun deleteBotVersion(input: DeleteBotVersionRequest): DeleteBotVersionResponse

    /**
     * Removes a custom vocabulary from the specified locale in the specified bot.
     */
    public suspend fun deleteCustomVocabulary(input: DeleteCustomVocabularyRequest): DeleteCustomVocabularyResponse

    /**
     * Removes a previous export and the associated files stored in an S3 bucket.
     */
    public suspend fun deleteExport(input: DeleteExportRequest): DeleteExportResponse

    /**
     * Removes a previous import and the associated file stored in an S3 bucket.
     */
    public suspend fun deleteImport(input: DeleteImportRequest): DeleteImportResponse

    /**
     * Removes the specified intent.
     *
     * Deleting an intent also deletes the slots associated with the intent.
     */
    public suspend fun deleteIntent(input: DeleteIntentRequest): DeleteIntentResponse

    /**
     * Removes an existing policy from a bot or bot alias. If the resource doesn't have a policy attached, Amazon Lex returns an exception.
     */
    public suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse

    /**
     * Deletes a policy statement from a resource policy. If you delete the last statement from a policy, the policy is deleted. If you specify a statement ID that doesn't exist in the policy, or if the bot or bot alias doesn't have a policy attached, Amazon Lex returns an exception.
     */
    public suspend fun deleteResourcePolicyStatement(input: DeleteResourcePolicyStatementRequest): DeleteResourcePolicyStatementResponse

    /**
     * Deletes the specified slot from an intent.
     */
    public suspend fun deleteSlot(input: DeleteSlotRequest): DeleteSlotResponse

    /**
     * Deletes a slot type from a bot locale.
     *
     * If a slot is using the slot type, Amazon Lex throws a `ResourceInUseException` exception. To avoid the exception, set the `skipResourceInUseCheck` parameter to `true`.
     */
    public suspend fun deleteSlotType(input: DeleteSlotTypeRequest): DeleteSlotTypeResponse

    /**
     * The action to delete the selected test set.
     */
    public suspend fun deleteTestSet(input: DeleteTestSetRequest): DeleteTestSetResponse

    /**
     * Deletes stored utterances.
     *
     * Amazon Lex stores the utterances that users send to your bot. Utterances are stored for 15 days for use with the [ListAggregatedUtterances](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html) operation, and then stored indefinitely for use in improving the ability of your bot to respond to user input..
     *
     * Use the `DeleteUtterances` operation to manually delete utterances for a specific session. When you use the `DeleteUtterances` operation, utterances stored for improving your bot's ability to respond to user input are deleted immediately. Utterances stored for use with the `ListAggregatedUtterances` operation are deleted after 15 days.
     */
    public suspend fun deleteUtterances(input: DeleteUtterancesRequest): DeleteUtterancesResponse

    /**
     * Provides metadata information about a bot.
     */
    public suspend fun describeBot(input: DescribeBotRequest): DescribeBotResponse

    /**
     * Get information about a specific bot alias.
     */
    public suspend fun describeBotAlias(input: DescribeBotAliasRequest): DescribeBotAliasResponse

    /**
     * Describes the settings that a bot has for a specific locale.
     */
    public suspend fun describeBotLocale(input: DescribeBotLocaleRequest): DescribeBotLocaleResponse

    /**
     * Provides metadata information about a bot recommendation. This information will enable you to get a description on the request inputs, to download associated transcripts after processing is complete, and to download intents and slot-types generated by the bot recommendation.
     */
    public suspend fun describeBotRecommendation(input: DescribeBotRecommendationRequest): DescribeBotRecommendationResponse

    /**
     * Returns information about a request to generate a bot through natural language description, made through the `StartBotResource` API. Use the `generatedBotLocaleUrl` to retrieve the Amazon S3 object containing the bot locale configuration. You can then modify and import this configuration.
     */
    public suspend fun describeBotResourceGeneration(input: DescribeBotResourceGenerationRequest): DescribeBotResourceGenerationResponse

    /**
     * Provides metadata about a version of a bot.
     */
    public suspend fun describeBotVersion(input: DescribeBotVersionRequest): DescribeBotVersionResponse

    /**
     * Provides metadata information about a custom vocabulary.
     */
    public suspend fun describeCustomVocabularyMetadata(input: DescribeCustomVocabularyMetadataRequest): DescribeCustomVocabularyMetadataResponse

    /**
     * Gets information about a specific export.
     */
    public suspend fun describeExport(input: DescribeExportRequest): DescribeExportResponse

    /**
     * Gets information about a specific import.
     */
    public suspend fun describeImport(input: DescribeImportRequest): DescribeImportResponse

    /**
     * Returns metadata about an intent.
     */
    public suspend fun describeIntent(input: DescribeIntentRequest): DescribeIntentResponse

    /**
     * Gets the resource policy and policy revision for a bot or bot alias.
     */
    public suspend fun describeResourcePolicy(input: DescribeResourcePolicyRequest): DescribeResourcePolicyResponse

    /**
     * Gets metadata information about a slot.
     */
    public suspend fun describeSlot(input: DescribeSlotRequest): DescribeSlotResponse

    /**
     * Gets metadata information about a slot type.
     */
    public suspend fun describeSlotType(input: DescribeSlotTypeRequest): DescribeSlotTypeResponse

    /**
     * Gets metadata information about the test execution.
     */
    public suspend fun describeTestExecution(input: DescribeTestExecutionRequest): DescribeTestExecutionResponse

    /**
     * Gets metadata information about the test set.
     */
    public suspend fun describeTestSet(input: DescribeTestSetRequest): DescribeTestSetResponse

    /**
     * Gets metadata information about the test set discrepancy report.
     */
    public suspend fun describeTestSetDiscrepancyReport(input: DescribeTestSetDiscrepancyReportRequest): DescribeTestSetDiscrepancyReportResponse

    /**
     * Gets metadata information about the test set generation.
     */
    public suspend fun describeTestSetGeneration(input: DescribeTestSetGenerationRequest): DescribeTestSetGenerationResponse

    /**
     * Generates sample utterances for an intent.
     */
    public suspend fun generateBotElement(input: GenerateBotElementRequest): GenerateBotElementResponse

    /**
     * The pre-signed Amazon S3 URL to download the test execution result artifacts.
     */
    public suspend fun getTestExecutionArtifactsUrl(input: GetTestExecutionArtifactsUrlRequest): GetTestExecutionArtifactsUrlResponse

    /**
     * Provides a list of utterances that users have sent to the bot.
     *
     * Utterances are aggregated by the text of the utterance. For example, all instances where customers used the phrase "I want to order pizza" are aggregated into the same line in the response.
     *
     * You can see both detected utterances and missed utterances. A detected utterance is where the bot properly recognized the utterance and activated the associated intent. A missed utterance was not recognized by the bot and didn't activate an intent.
     *
     * Utterances can be aggregated for a bot alias or for a bot version, but not both at the same time.
     *
     * Utterances statistics are not generated under the following conditions:
     * + The `childDirected` field was set to true when the bot was created.
     * + You are using slot obfuscation with one or more slots.
     * + You opted out of participating in improving Amazon Lex.
     */
    public suspend fun listAggregatedUtterances(input: ListAggregatedUtterancesRequest): ListAggregatedUtterancesResponse

    /**
     * Gets a list of aliases for the specified bot.
     */
    public suspend fun listBotAliases(input: ListBotAliasesRequest): ListBotAliasesResponse

    /**
     * Gets a list of locales for the specified bot.
     */
    public suspend fun listBotLocales(input: ListBotLocalesRequest): ListBotLocalesResponse

    /**
     * Get a list of bot recommendations that meet the specified criteria.
     */
    public suspend fun listBotRecommendations(input: ListBotRecommendationsRequest): ListBotRecommendationsResponse

    /**
     * Lists the generation requests made for a bot locale.
     */
    public suspend fun listBotResourceGenerations(input: ListBotResourceGenerationsRequest): ListBotResourceGenerationsResponse

    /**
     * Gets information about all of the versions of a bot.
     *
     * The `ListBotVersions` operation returns a summary of each version of a bot. For example, if a bot has three numbered versions, the `ListBotVersions` operation returns for summaries, one for each numbered version and one for the `DRAFT` version.
     *
     * The `ListBotVersions` operation always returns at least one version, the `DRAFT` version.
     */
    public suspend fun listBotVersions(input: ListBotVersionsRequest): ListBotVersionsResponse

    /**
     * Gets a list of available bots.
     */
    public suspend fun listBots(input: ListBotsRequest = ListBotsRequest { }): ListBotsResponse

    /**
     * Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
     *
     * To use a built-in intent as a the base for your own intent, include the built-in intent signature in the `parentIntentSignature` parameter when you call the `CreateIntent` operation. For more information, see [CreateIntent](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateIntent.html).
     */
    public suspend fun listBuiltInIntents(input: ListBuiltInIntentsRequest): ListBuiltInIntentsResponse

    /**
     * Gets a list of built-in slot types that meet the specified criteria.
     */
    public suspend fun listBuiltInSlotTypes(input: ListBuiltInSlotTypesRequest): ListBuiltInSlotTypesResponse

    /**
     * Paginated list of custom vocabulary items for a given bot locale's custom vocabulary.
     */
    public suspend fun listCustomVocabularyItems(input: ListCustomVocabularyItemsRequest): ListCustomVocabularyItemsResponse

    /**
     * Lists the exports for a bot, bot locale, or custom vocabulary. Exports are kept in the list for 7 days.
     */
    public suspend fun listExports(input: ListExportsRequest = ListExportsRequest { }): ListExportsResponse

    /**
     * Lists the imports for a bot, bot locale, or custom vocabulary. Imports are kept in the list for 7 days.
     */
    public suspend fun listImports(input: ListImportsRequest = ListImportsRequest { }): ListImportsResponse

    /**
     * Retrieves summary metrics for the intents in your bot. The following fields are required:
     * + `metrics` – A list of [AnalyticsIntentMetric](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsIntentMetric.html) objects. In each object, use the `name` field to specify the metric to calculate, the `statistic` field to specify whether to calculate the `Sum`, `Average`, or `Max` number, and the `order` field to specify whether to sort the results in `Ascending` or `Descending` order.
     * + `startDateTime` and `endDateTime` – Define a time range for which you want to retrieve results.
     *
     * Of the optional fields, you can organize the results in the following ways:
     * + Use the `filters` field to filter the results, the `groupBy` field to specify categories by which to group the results, and the `binBy` field to specify time intervals by which to group the results.
     * + Use the `maxResults` field to limit the number of results to return in a single response and the `nextToken` field to return the next batch of results if the response does not return the full set of results.
     *
     * Note that an `order` field exists in both `binBy` and `metrics`. You can specify only one `order` in a given request.
     */
    public suspend fun listIntentMetrics(input: ListIntentMetricsRequest): ListIntentMetricsResponse

    /**
     * Retrieves summary statistics for a path of intents that users take over sessions with your bot. The following fields are required:
     * + `startDateTime` and `endDateTime` – Define a time range for which you want to retrieve results.
     * + `intentPath` – Define an order of intents for which you want to retrieve metrics. Separate intents in the path with a forward slash. For example, populate the `intentPath` field with `/BookCar/BookHotel` to see details about how many times users invoked the `BookCar` and `BookHotel` intents in that order.
     *
     * Use the optional `filters` field to filter the results.
     */
    public suspend fun listIntentPaths(input: ListIntentPathsRequest): ListIntentPathsResponse

    /**
     * Retrieves summary metrics for the stages within intents in your bot. The following fields are required:
     * + `metrics` – A list of [AnalyticsIntentStageMetric](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsIntentStageMetric.html) objects. In each object, use the `name` field to specify the metric to calculate, the `statistic` field to specify whether to calculate the `Sum`, `Average`, or `Max` number, and the `order` field to specify whether to sort the results in `Ascending` or `Descending` order.
     * + `startDateTime` and `endDateTime` – Define a time range for which you want to retrieve results.
     *
     * Of the optional fields, you can organize the results in the following ways:
     * + Use the `filters` field to filter the results, the `groupBy` field to specify categories by which to group the results, and the `binBy` field to specify time intervals by which to group the results.
     * + Use the `maxResults` field to limit the number of results to return in a single response and the `nextToken` field to return the next batch of results if the response does not return the full set of results.
     *
     * Note that an `order` field exists in both `binBy` and `metrics`. You can only specify one `order` in a given request.
     */
    public suspend fun listIntentStageMetrics(input: ListIntentStageMetricsRequest): ListIntentStageMetricsResponse

    /**
     * Get a list of intents that meet the specified criteria.
     */
    public suspend fun listIntents(input: ListIntentsRequest): ListIntentsResponse

    /**
     * Gets a list of recommended intents provided by the bot recommendation that you can use in your bot. Intents in the response are ordered by relevance.
     */
    public suspend fun listRecommendedIntents(input: ListRecommendedIntentsRequest): ListRecommendedIntentsResponse

    /**
     * Retrieves a list of metadata for individual user sessions with your bot. The `startDateTime` and `endDateTime` fields are required. These fields define a time range for which you want to retrieve results. Of the optional fields, you can organize the results in the following ways:
     * + Use the `filters` field to filter the results and the `sortBy` field to specify the values by which to sort the results.
     * + Use the `maxResults` field to limit the number of results to return in a single response and the `nextToken` field to return the next batch of results if the response does not return the full set of results.
     */
    public suspend fun listSessionAnalyticsData(input: ListSessionAnalyticsDataRequest): ListSessionAnalyticsDataResponse

    /**
     * Retrieves summary metrics for the user sessions with your bot. The following fields are required:
     * + `metrics` – A list of [AnalyticsSessionMetric](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsSessionMetric.html) objects. In each object, use the `name` field to specify the metric to calculate, the `statistic` field to specify whether to calculate the `Sum`, `Average`, or `Max` number, and the `order` field to specify whether to sort the results in `Ascending` or `Descending` order.
     * + `startDateTime` and `endDateTime` – Define a time range for which you want to retrieve results.
     *
     * Of the optional fields, you can organize the results in the following ways:
     * + Use the `filters` field to filter the results, the `groupBy` field to specify categories by which to group the results, and the `binBy` field to specify time intervals by which to group the results.
     * + Use the `maxResults` field to limit the number of results to return in a single response and the `nextToken` field to return the next batch of results if the response does not return the full set of results.
     *
     * Note that an `order` field exists in both `binBy` and `metrics`. Currently, you can specify it in either field, but not in both.
     */
    public suspend fun listSessionMetrics(input: ListSessionMetricsRequest): ListSessionMetricsResponse

    /**
     * Gets a list of slot types that match the specified criteria.
     */
    public suspend fun listSlotTypes(input: ListSlotTypesRequest): ListSlotTypesResponse

    /**
     * Gets a list of slots that match the specified criteria.
     */
    public suspend fun listSlots(input: ListSlotsRequest): ListSlotsResponse

    /**
     * Gets a list of tags associated with a resource. Only bots, bot aliases, and bot channels can have tags associated with them.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Gets a list of test execution result items.
     */
    public suspend fun listTestExecutionResultItems(input: ListTestExecutionResultItemsRequest): ListTestExecutionResultItemsResponse

    /**
     * The list of test set executions.
     */
    public suspend fun listTestExecutions(input: ListTestExecutionsRequest = ListTestExecutionsRequest { }): ListTestExecutionsResponse

    /**
     * The list of test set records.
     */
    public suspend fun listTestSetRecords(input: ListTestSetRecordsRequest): ListTestSetRecordsResponse

    /**
     * The list of the test sets
     */
    public suspend fun listTestSets(input: ListTestSetsRequest = ListTestSetsRequest { }): ListTestSetsResponse

    /**
     * To use this API operation, your IAM role must have permissions to perform the [ListAggregatedUtterances](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html) operation, which provides access to utterance-related analytics. See [Viewing utterance statistics](https://docs.aws.amazon.com/lexv2/latest/dg/monitoring-utterances.html) for the IAM policy to apply to the IAM role.
     *
     * Retrieves a list of metadata for individual user utterances to your bot. The following fields are required:
     * + `startDateTime` and `endDateTime` – Define a time range for which you want to retrieve results.
     *
     * Of the optional fields, you can organize the results in the following ways:
     * + Use the `filters` field to filter the results and the `sortBy` field to specify the values by which to sort the results.
     * + Use the `maxResults` field to limit the number of results to return in a single response and the `nextToken` field to return the next batch of results if the response does not return the full set of results.
     */
    public suspend fun listUtteranceAnalyticsData(input: ListUtteranceAnalyticsDataRequest): ListUtteranceAnalyticsDataResponse

    /**
     * To use this API operation, your IAM role must have permissions to perform the [ListAggregatedUtterances](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html) operation, which provides access to utterance-related analytics. See [Viewing utterance statistics](https://docs.aws.amazon.com/lexv2/latest/dg/monitoring-utterances.html) for the IAM policy to apply to the IAM role.
     *
     * Retrieves summary metrics for the utterances in your bot. The following fields are required:
     * + `metrics` – A list of [AnalyticsUtteranceMetric](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsUtteranceMetric.html) objects. In each object, use the `name` field to specify the metric to calculate, the `statistic` field to specify whether to calculate the `Sum`, `Average`, or `Max` number, and the `order` field to specify whether to sort the results in `Ascending` or `Descending` order.
     * + `startDateTime` and `endDateTime` – Define a time range for which you want to retrieve results.
     *
     * Of the optional fields, you can organize the results in the following ways:
     * + Use the `filters` field to filter the results, the `groupBy` field to specify categories by which to group the results, and the `binBy` field to specify time intervals by which to group the results.
     * + Use the `maxResults` field to limit the number of results to return in a single response and the `nextToken` field to return the next batch of results if the response does not return the full set of results.
     *
     * Note that an `order` field exists in both `binBy` and `metrics`. Currently, you can specify it in either field, but not in both.
     */
    public suspend fun listUtteranceMetrics(input: ListUtteranceMetricsRequest): ListUtteranceMetricsResponse

    /**
     * Search for associated transcripts that meet the specified criteria.
     */
    public suspend fun searchAssociatedTranscripts(input: SearchAssociatedTranscriptsRequest): SearchAssociatedTranscriptsResponse

    /**
     * Use this to provide your transcript data, and to start the bot recommendation process.
     */
    public suspend fun startBotRecommendation(input: StartBotRecommendationRequest): StartBotRecommendationResponse

    /**
     * Starts a request for the descriptive bot builder to generate a bot locale configuration based on the prompt you provide it. After you make this call, use the `DescribeBotResourceGeneration` operation to check on the status of the generation and for the `generatedBotLocaleUrl` when the generation is complete. Use that value to retrieve the Amazon S3 object containing the bot locale configuration. You can then modify and import this configuration.
     */
    public suspend fun startBotResourceGeneration(input: StartBotResourceGenerationRequest): StartBotResourceGenerationResponse

    /**
     * Starts importing a bot, bot locale, or custom vocabulary from a zip archive that you uploaded to an S3 bucket.
     */
    public suspend fun startImport(input: StartImportRequest): StartImportResponse

    /**
     * The action to start test set execution.
     */
    public suspend fun startTestExecution(input: StartTestExecutionRequest): StartTestExecutionResponse

    /**
     * The action to start the generation of test set.
     */
    public suspend fun startTestSetGeneration(input: StartTestSetGenerationRequest): StartTestSetGenerationResponse

    /**
     * Stop an already running Bot Recommendation request.
     */
    public suspend fun stopBotRecommendation(input: StopBotRecommendationRequest): StopBotRecommendationResponse

    /**
     * Adds the specified tags to the specified resource. If a tag key already exists, the existing value is replaced with the new value.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from a bot, bot alias, or bot channel.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the configuration of an existing bot.
     */
    public suspend fun updateBot(input: UpdateBotRequest): UpdateBotResponse

    /**
     * Updates the configuration of an existing bot alias.
     */
    public suspend fun updateBotAlias(input: UpdateBotAliasRequest): UpdateBotAliasResponse

    /**
     * Updates the settings that a bot has for a specific locale.
     */
    public suspend fun updateBotLocale(input: UpdateBotLocaleRequest): UpdateBotLocaleResponse

    /**
     * Updates an existing bot recommendation request.
     */
    public suspend fun updateBotRecommendation(input: UpdateBotRecommendationRequest): UpdateBotRecommendationResponse

    /**
     * Updates the password used to protect an export zip archive.
     *
     * The password is not required. If you don't supply a password, Amazon Lex generates a zip file that is not protected by a password. This is the archive that is available at the pre-signed S3 URL provided by the [DescribeExport](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html) operation.
     */
    public suspend fun updateExport(input: UpdateExportRequest): UpdateExportResponse

    /**
     * Updates the settings for an intent.
     */
    public suspend fun updateIntent(input: UpdateIntentRequest): UpdateIntentResponse

    /**
     * Replaces the existing resource policy for a bot or bot alias with a new one. If the policy doesn't exist, Amazon Lex returns an exception.
     */
    public suspend fun updateResourcePolicy(input: UpdateResourcePolicyRequest): UpdateResourcePolicyResponse

    /**
     * Updates the settings for a slot.
     */
    public suspend fun updateSlot(input: UpdateSlotRequest): UpdateSlotResponse

    /**
     * Updates the configuration of an existing slot type.
     */
    public suspend fun updateSlotType(input: UpdateSlotTypeRequest): UpdateSlotTypeResponse

    /**
     * The action to update the test set.
     */
    public suspend fun updateTestSet(input: UpdateTestSetRequest): UpdateTestSetResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun LexModelsV2Client.withConfig(block: LexModelsV2Client.Config.Builder.() -> Unit): LexModelsV2Client {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultLexModelsV2Client(newConfig)
}

/**
 * Create a batch of custom vocabulary items for a given bot locale's custom vocabulary.
 */
public suspend inline fun LexModelsV2Client.batchCreateCustomVocabularyItem(crossinline block: BatchCreateCustomVocabularyItemRequest.Builder.() -> Unit): BatchCreateCustomVocabularyItemResponse = batchCreateCustomVocabularyItem(BatchCreateCustomVocabularyItemRequest.Builder().apply(block).build())

/**
 * Delete a batch of custom vocabulary items for a given bot locale's custom vocabulary.
 */
public suspend inline fun LexModelsV2Client.batchDeleteCustomVocabularyItem(crossinline block: BatchDeleteCustomVocabularyItemRequest.Builder.() -> Unit): BatchDeleteCustomVocabularyItemResponse = batchDeleteCustomVocabularyItem(BatchDeleteCustomVocabularyItemRequest.Builder().apply(block).build())

/**
 * Update a batch of custom vocabulary items for a given bot locale's custom vocabulary.
 */
public suspend inline fun LexModelsV2Client.batchUpdateCustomVocabularyItem(crossinline block: BatchUpdateCustomVocabularyItemRequest.Builder.() -> Unit): BatchUpdateCustomVocabularyItemResponse = batchUpdateCustomVocabularyItem(BatchUpdateCustomVocabularyItemRequest.Builder().apply(block).build())

/**
 * Builds a bot, its intents, and its slot types into a specific locale. A bot can be built into multiple locales. At runtime the locale is used to choose a specific build of the bot.
 */
public suspend inline fun LexModelsV2Client.buildBotLocale(crossinline block: BuildBotLocaleRequest.Builder.() -> Unit): BuildBotLocaleResponse = buildBotLocale(BuildBotLocaleRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Lex conversational bot.
 */
public suspend inline fun LexModelsV2Client.createBot(crossinline block: CreateBotRequest.Builder.() -> Unit): CreateBotResponse = createBot(CreateBotRequest.Builder().apply(block).build())

/**
 * Creates an alias for the specified version of a bot. Use an alias to enable you to change the version of a bot without updating applications that use the bot.
 *
 * For example, you can create an alias called "PROD" that your applications use to call the Amazon Lex bot.
 */
public suspend inline fun LexModelsV2Client.createBotAlias(crossinline block: CreateBotAliasRequest.Builder.() -> Unit): CreateBotAliasResponse = createBotAlias(CreateBotAliasRequest.Builder().apply(block).build())

/**
 * Creates a locale in the bot. The locale contains the intents and slot types that the bot uses in conversations with users in the specified language and locale. You must add a locale to a bot before you can add intents and slot types to the bot.
 */
public suspend inline fun LexModelsV2Client.createBotLocale(crossinline block: CreateBotLocaleRequest.Builder.() -> Unit): CreateBotLocaleResponse = createBotLocale(CreateBotLocaleRequest.Builder().apply(block).build())

/**
 * Creates an immutable version of the bot. When you create the first version of a bot, Amazon Lex sets the version number to 1. Subsequent bot versions increase in an increment of 1. The version number will always represent the total number of versions created of the bot, not the current number of versions. If a bot version is deleted, that bot version number will not be reused.
 */
public suspend inline fun LexModelsV2Client.createBotVersion(crossinline block: CreateBotVersionRequest.Builder.() -> Unit): CreateBotVersionResponse = createBotVersion(CreateBotVersionRequest.Builder().apply(block).build())

/**
 * Creates a zip archive containing the contents of a bot or a bot locale. The archive contains a directory structure that contains JSON files that define the bot.
 *
 * You can create an archive that contains the complete definition of a bot, or you can specify that the archive contain only the definition of a single bot locale.
 *
 * For more information about exporting bots, and about the structure of the export archive, see [ Importing and exporting bots ](https://docs.aws.amazon.com/lexv2/latest/dg/importing-exporting.html)
 */
public suspend inline fun LexModelsV2Client.createExport(crossinline block: CreateExportRequest.Builder.() -> Unit): CreateExportResponse = createExport(CreateExportRequest.Builder().apply(block).build())

/**
 * Creates an intent.
 *
 * To define the interaction between the user and your bot, you define one or more intents. For example, for a pizza ordering bot you would create an `OrderPizza` intent.
 *
 * When you create an intent, you must provide a name. You can optionally provide the following:
 * + Sample utterances. For example, "I want to order a pizza" and "Can I order a pizza." You can't provide utterances for built-in intents.
 * + Information to be gathered. You specify slots for the information that you bot requests from the user. You can specify standard slot types, such as date and time, or custom slot types for your application.
 * + How the intent is fulfilled. You can provide a Lambda function or configure the intent to return the intent information to your client application. If you use a Lambda function, Amazon Lex invokes the function when all of the intent information is available.
 * + A confirmation prompt to send to the user to confirm an intent. For example, "Shall I order your pizza?"
 * + A conclusion statement to send to the user after the intent is fulfilled. For example, "I ordered your pizza."
 * + A follow-up prompt that asks the user for additional activity. For example, "Do you want a drink with your pizza?"
 */
public suspend inline fun LexModelsV2Client.createIntent(crossinline block: CreateIntentRequest.Builder.() -> Unit): CreateIntentResponse = createIntent(CreateIntentRequest.Builder().apply(block).build())

/**
 * Creates a new resource policy with the specified policy statements.
 */
public suspend inline fun LexModelsV2Client.createResourcePolicy(crossinline block: CreateResourcePolicyRequest.Builder.() -> Unit): CreateResourcePolicyResponse = createResourcePolicy(CreateResourcePolicyRequest.Builder().apply(block).build())

/**
 * Adds a new resource policy statement to a bot or bot alias. If a resource policy exists, the statement is added to the current resource policy. If a policy doesn't exist, a new policy is created.
 *
 * You can't create a resource policy statement that allows cross-account access.
 */
public suspend inline fun LexModelsV2Client.createResourcePolicyStatement(crossinline block: CreateResourcePolicyStatementRequest.Builder.() -> Unit): CreateResourcePolicyStatementResponse = createResourcePolicyStatement(CreateResourcePolicyStatementRequest.Builder().apply(block).build())

/**
 * Creates a slot in an intent. A slot is a variable needed to fulfill an intent. For example, an `OrderPizza` intent might need slots for size, crust, and number of pizzas. For each slot, you define one or more utterances that Amazon Lex uses to elicit a response from the user.
 */
public suspend inline fun LexModelsV2Client.createSlot(crossinline block: CreateSlotRequest.Builder.() -> Unit): CreateSlotResponse = createSlot(CreateSlotRequest.Builder().apply(block).build())

/**
 * Creates a custom slot type
 *
 *  To create a custom slot type, specify a name for the slot type and a set of enumeration values, the values that a slot of this type can assume.
 */
public suspend inline fun LexModelsV2Client.createSlotType(crossinline block: CreateSlotTypeRequest.Builder.() -> Unit): CreateSlotTypeResponse = createSlotType(CreateSlotTypeRequest.Builder().apply(block).build())

/**
 * Create a report that describes the differences between the bot and the test set.
 */
public suspend inline fun LexModelsV2Client.createTestSetDiscrepancyReport(crossinline block: CreateTestSetDiscrepancyReportRequest.Builder.() -> Unit): CreateTestSetDiscrepancyReportResponse = createTestSetDiscrepancyReport(CreateTestSetDiscrepancyReportRequest.Builder().apply(block).build())

/**
 * Gets a pre-signed S3 write URL that you use to upload the zip archive when importing a bot or a bot locale.
 */
public suspend inline fun LexModelsV2Client.createUploadUrl(crossinline block: CreateUploadUrlRequest.Builder.() -> Unit): CreateUploadUrlResponse = createUploadUrl(CreateUploadUrlRequest.Builder().apply(block).build())

/**
 * Deletes all versions of a bot, including the `Draft` version. To delete a specific version, use the `DeleteBotVersion` operation.
 *
 * When you delete a bot, all of the resources contained in the bot are also deleted. Deleting a bot removes all locales, intents, slot, and slot types defined for the bot.
 *
 * If a bot has an alias, the `DeleteBot` operation returns a `ResourceInUseException` exception. If you want to delete the bot and the alias, set the `skipResourceInUseCheck` parameter to `true`.
 */
public suspend inline fun LexModelsV2Client.deleteBot(crossinline block: DeleteBotRequest.Builder.() -> Unit): DeleteBotResponse = deleteBot(DeleteBotRequest.Builder().apply(block).build())

/**
 * Deletes the specified bot alias.
 */
public suspend inline fun LexModelsV2Client.deleteBotAlias(crossinline block: DeleteBotAliasRequest.Builder.() -> Unit): DeleteBotAliasResponse = deleteBotAlias(DeleteBotAliasRequest.Builder().apply(block).build())

/**
 * Removes a locale from a bot.
 *
 * When you delete a locale, all intents, slots, and slot types defined for the locale are also deleted.
 */
public suspend inline fun LexModelsV2Client.deleteBotLocale(crossinline block: DeleteBotLocaleRequest.Builder.() -> Unit): DeleteBotLocaleResponse = deleteBotLocale(DeleteBotLocaleRequest.Builder().apply(block).build())

/**
 * Deletes a specific version of a bot. To delete all versions of a bot, use the [DeleteBot](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DeleteBot.html) operation.
 */
public suspend inline fun LexModelsV2Client.deleteBotVersion(crossinline block: DeleteBotVersionRequest.Builder.() -> Unit): DeleteBotVersionResponse = deleteBotVersion(DeleteBotVersionRequest.Builder().apply(block).build())

/**
 * Removes a custom vocabulary from the specified locale in the specified bot.
 */
public suspend inline fun LexModelsV2Client.deleteCustomVocabulary(crossinline block: DeleteCustomVocabularyRequest.Builder.() -> Unit): DeleteCustomVocabularyResponse = deleteCustomVocabulary(DeleteCustomVocabularyRequest.Builder().apply(block).build())

/**
 * Removes a previous export and the associated files stored in an S3 bucket.
 */
public suspend inline fun LexModelsV2Client.deleteExport(crossinline block: DeleteExportRequest.Builder.() -> Unit): DeleteExportResponse = deleteExport(DeleteExportRequest.Builder().apply(block).build())

/**
 * Removes a previous import and the associated file stored in an S3 bucket.
 */
public suspend inline fun LexModelsV2Client.deleteImport(crossinline block: DeleteImportRequest.Builder.() -> Unit): DeleteImportResponse = deleteImport(DeleteImportRequest.Builder().apply(block).build())

/**
 * Removes the specified intent.
 *
 * Deleting an intent also deletes the slots associated with the intent.
 */
public suspend inline fun LexModelsV2Client.deleteIntent(crossinline block: DeleteIntentRequest.Builder.() -> Unit): DeleteIntentResponse = deleteIntent(DeleteIntentRequest.Builder().apply(block).build())

/**
 * Removes an existing policy from a bot or bot alias. If the resource doesn't have a policy attached, Amazon Lex returns an exception.
 */
public suspend inline fun LexModelsV2Client.deleteResourcePolicy(crossinline block: DeleteResourcePolicyRequest.Builder.() -> Unit): DeleteResourcePolicyResponse = deleteResourcePolicy(DeleteResourcePolicyRequest.Builder().apply(block).build())

/**
 * Deletes a policy statement from a resource policy. If you delete the last statement from a policy, the policy is deleted. If you specify a statement ID that doesn't exist in the policy, or if the bot or bot alias doesn't have a policy attached, Amazon Lex returns an exception.
 */
public suspend inline fun LexModelsV2Client.deleteResourcePolicyStatement(crossinline block: DeleteResourcePolicyStatementRequest.Builder.() -> Unit): DeleteResourcePolicyStatementResponse = deleteResourcePolicyStatement(DeleteResourcePolicyStatementRequest.Builder().apply(block).build())

/**
 * Deletes the specified slot from an intent.
 */
public suspend inline fun LexModelsV2Client.deleteSlot(crossinline block: DeleteSlotRequest.Builder.() -> Unit): DeleteSlotResponse = deleteSlot(DeleteSlotRequest.Builder().apply(block).build())

/**
 * Deletes a slot type from a bot locale.
 *
 * If a slot is using the slot type, Amazon Lex throws a `ResourceInUseException` exception. To avoid the exception, set the `skipResourceInUseCheck` parameter to `true`.
 */
public suspend inline fun LexModelsV2Client.deleteSlotType(crossinline block: DeleteSlotTypeRequest.Builder.() -> Unit): DeleteSlotTypeResponse = deleteSlotType(DeleteSlotTypeRequest.Builder().apply(block).build())

/**
 * The action to delete the selected test set.
 */
public suspend inline fun LexModelsV2Client.deleteTestSet(crossinline block: DeleteTestSetRequest.Builder.() -> Unit): DeleteTestSetResponse = deleteTestSet(DeleteTestSetRequest.Builder().apply(block).build())

/**
 * Deletes stored utterances.
 *
 * Amazon Lex stores the utterances that users send to your bot. Utterances are stored for 15 days for use with the [ListAggregatedUtterances](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html) operation, and then stored indefinitely for use in improving the ability of your bot to respond to user input..
 *
 * Use the `DeleteUtterances` operation to manually delete utterances for a specific session. When you use the `DeleteUtterances` operation, utterances stored for improving your bot's ability to respond to user input are deleted immediately. Utterances stored for use with the `ListAggregatedUtterances` operation are deleted after 15 days.
 */
public suspend inline fun LexModelsV2Client.deleteUtterances(crossinline block: DeleteUtterancesRequest.Builder.() -> Unit): DeleteUtterancesResponse = deleteUtterances(DeleteUtterancesRequest.Builder().apply(block).build())

/**
 * Provides metadata information about a bot.
 */
public suspend inline fun LexModelsV2Client.describeBot(crossinline block: DescribeBotRequest.Builder.() -> Unit): DescribeBotResponse = describeBot(DescribeBotRequest.Builder().apply(block).build())

/**
 * Get information about a specific bot alias.
 */
public suspend inline fun LexModelsV2Client.describeBotAlias(crossinline block: DescribeBotAliasRequest.Builder.() -> Unit): DescribeBotAliasResponse = describeBotAlias(DescribeBotAliasRequest.Builder().apply(block).build())

/**
 * Describes the settings that a bot has for a specific locale.
 */
public suspend inline fun LexModelsV2Client.describeBotLocale(crossinline block: DescribeBotLocaleRequest.Builder.() -> Unit): DescribeBotLocaleResponse = describeBotLocale(DescribeBotLocaleRequest.Builder().apply(block).build())

/**
 * Provides metadata information about a bot recommendation. This information will enable you to get a description on the request inputs, to download associated transcripts after processing is complete, and to download intents and slot-types generated by the bot recommendation.
 */
public suspend inline fun LexModelsV2Client.describeBotRecommendation(crossinline block: DescribeBotRecommendationRequest.Builder.() -> Unit): DescribeBotRecommendationResponse = describeBotRecommendation(DescribeBotRecommendationRequest.Builder().apply(block).build())

/**
 * Returns information about a request to generate a bot through natural language description, made through the `StartBotResource` API. Use the `generatedBotLocaleUrl` to retrieve the Amazon S3 object containing the bot locale configuration. You can then modify and import this configuration.
 */
public suspend inline fun LexModelsV2Client.describeBotResourceGeneration(crossinline block: DescribeBotResourceGenerationRequest.Builder.() -> Unit): DescribeBotResourceGenerationResponse = describeBotResourceGeneration(DescribeBotResourceGenerationRequest.Builder().apply(block).build())

/**
 * Provides metadata about a version of a bot.
 */
public suspend inline fun LexModelsV2Client.describeBotVersion(crossinline block: DescribeBotVersionRequest.Builder.() -> Unit): DescribeBotVersionResponse = describeBotVersion(DescribeBotVersionRequest.Builder().apply(block).build())

/**
 * Provides metadata information about a custom vocabulary.
 */
public suspend inline fun LexModelsV2Client.describeCustomVocabularyMetadata(crossinline block: DescribeCustomVocabularyMetadataRequest.Builder.() -> Unit): DescribeCustomVocabularyMetadataResponse = describeCustomVocabularyMetadata(DescribeCustomVocabularyMetadataRequest.Builder().apply(block).build())

/**
 * Gets information about a specific export.
 */
public suspend inline fun LexModelsV2Client.describeExport(crossinline block: DescribeExportRequest.Builder.() -> Unit): DescribeExportResponse = describeExport(DescribeExportRequest.Builder().apply(block).build())

/**
 * Gets information about a specific import.
 */
public suspend inline fun LexModelsV2Client.describeImport(crossinline block: DescribeImportRequest.Builder.() -> Unit): DescribeImportResponse = describeImport(DescribeImportRequest.Builder().apply(block).build())

/**
 * Returns metadata about an intent.
 */
public suspend inline fun LexModelsV2Client.describeIntent(crossinline block: DescribeIntentRequest.Builder.() -> Unit): DescribeIntentResponse = describeIntent(DescribeIntentRequest.Builder().apply(block).build())

/**
 * Gets the resource policy and policy revision for a bot or bot alias.
 */
public suspend inline fun LexModelsV2Client.describeResourcePolicy(crossinline block: DescribeResourcePolicyRequest.Builder.() -> Unit): DescribeResourcePolicyResponse = describeResourcePolicy(DescribeResourcePolicyRequest.Builder().apply(block).build())

/**
 * Gets metadata information about a slot.
 */
public suspend inline fun LexModelsV2Client.describeSlot(crossinline block: DescribeSlotRequest.Builder.() -> Unit): DescribeSlotResponse = describeSlot(DescribeSlotRequest.Builder().apply(block).build())

/**
 * Gets metadata information about a slot type.
 */
public suspend inline fun LexModelsV2Client.describeSlotType(crossinline block: DescribeSlotTypeRequest.Builder.() -> Unit): DescribeSlotTypeResponse = describeSlotType(DescribeSlotTypeRequest.Builder().apply(block).build())

/**
 * Gets metadata information about the test execution.
 */
public suspend inline fun LexModelsV2Client.describeTestExecution(crossinline block: DescribeTestExecutionRequest.Builder.() -> Unit): DescribeTestExecutionResponse = describeTestExecution(DescribeTestExecutionRequest.Builder().apply(block).build())

/**
 * Gets metadata information about the test set.
 */
public suspend inline fun LexModelsV2Client.describeTestSet(crossinline block: DescribeTestSetRequest.Builder.() -> Unit): DescribeTestSetResponse = describeTestSet(DescribeTestSetRequest.Builder().apply(block).build())

/**
 * Gets metadata information about the test set discrepancy report.
 */
public suspend inline fun LexModelsV2Client.describeTestSetDiscrepancyReport(crossinline block: DescribeTestSetDiscrepancyReportRequest.Builder.() -> Unit): DescribeTestSetDiscrepancyReportResponse = describeTestSetDiscrepancyReport(DescribeTestSetDiscrepancyReportRequest.Builder().apply(block).build())

/**
 * Gets metadata information about the test set generation.
 */
public suspend inline fun LexModelsV2Client.describeTestSetGeneration(crossinline block: DescribeTestSetGenerationRequest.Builder.() -> Unit): DescribeTestSetGenerationResponse = describeTestSetGeneration(DescribeTestSetGenerationRequest.Builder().apply(block).build())

/**
 * Generates sample utterances for an intent.
 */
public suspend inline fun LexModelsV2Client.generateBotElement(crossinline block: GenerateBotElementRequest.Builder.() -> Unit): GenerateBotElementResponse = generateBotElement(GenerateBotElementRequest.Builder().apply(block).build())

/**
 * The pre-signed Amazon S3 URL to download the test execution result artifacts.
 */
public suspend inline fun LexModelsV2Client.getTestExecutionArtifactsUrl(crossinline block: GetTestExecutionArtifactsUrlRequest.Builder.() -> Unit): GetTestExecutionArtifactsUrlResponse = getTestExecutionArtifactsUrl(GetTestExecutionArtifactsUrlRequest.Builder().apply(block).build())

/**
 * Provides a list of utterances that users have sent to the bot.
 *
 * Utterances are aggregated by the text of the utterance. For example, all instances where customers used the phrase "I want to order pizza" are aggregated into the same line in the response.
 *
 * You can see both detected utterances and missed utterances. A detected utterance is where the bot properly recognized the utterance and activated the associated intent. A missed utterance was not recognized by the bot and didn't activate an intent.
 *
 * Utterances can be aggregated for a bot alias or for a bot version, but not both at the same time.
 *
 * Utterances statistics are not generated under the following conditions:
 * + The `childDirected` field was set to true when the bot was created.
 * + You are using slot obfuscation with one or more slots.
 * + You opted out of participating in improving Amazon Lex.
 */
public suspend inline fun LexModelsV2Client.listAggregatedUtterances(crossinline block: ListAggregatedUtterancesRequest.Builder.() -> Unit): ListAggregatedUtterancesResponse = listAggregatedUtterances(ListAggregatedUtterancesRequest.Builder().apply(block).build())

/**
 * Gets a list of aliases for the specified bot.
 */
public suspend inline fun LexModelsV2Client.listBotAliases(crossinline block: ListBotAliasesRequest.Builder.() -> Unit): ListBotAliasesResponse = listBotAliases(ListBotAliasesRequest.Builder().apply(block).build())

/**
 * Gets a list of locales for the specified bot.
 */
public suspend inline fun LexModelsV2Client.listBotLocales(crossinline block: ListBotLocalesRequest.Builder.() -> Unit): ListBotLocalesResponse = listBotLocales(ListBotLocalesRequest.Builder().apply(block).build())

/**
 * Get a list of bot recommendations that meet the specified criteria.
 */
public suspend inline fun LexModelsV2Client.listBotRecommendations(crossinline block: ListBotRecommendationsRequest.Builder.() -> Unit): ListBotRecommendationsResponse = listBotRecommendations(ListBotRecommendationsRequest.Builder().apply(block).build())

/**
 * Lists the generation requests made for a bot locale.
 */
public suspend inline fun LexModelsV2Client.listBotResourceGenerations(crossinline block: ListBotResourceGenerationsRequest.Builder.() -> Unit): ListBotResourceGenerationsResponse = listBotResourceGenerations(ListBotResourceGenerationsRequest.Builder().apply(block).build())

/**
 * Gets information about all of the versions of a bot.
 *
 * The `ListBotVersions` operation returns a summary of each version of a bot. For example, if a bot has three numbered versions, the `ListBotVersions` operation returns for summaries, one for each numbered version and one for the `DRAFT` version.
 *
 * The `ListBotVersions` operation always returns at least one version, the `DRAFT` version.
 */
public suspend inline fun LexModelsV2Client.listBotVersions(crossinline block: ListBotVersionsRequest.Builder.() -> Unit): ListBotVersionsResponse = listBotVersions(ListBotVersionsRequest.Builder().apply(block).build())

/**
 * Gets a list of available bots.
 */
public suspend inline fun LexModelsV2Client.listBots(crossinline block: ListBotsRequest.Builder.() -> Unit): ListBotsResponse = listBots(ListBotsRequest.Builder().apply(block).build())

/**
 * Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
 *
 * To use a built-in intent as a the base for your own intent, include the built-in intent signature in the `parentIntentSignature` parameter when you call the `CreateIntent` operation. For more information, see [CreateIntent](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateIntent.html).
 */
public suspend inline fun LexModelsV2Client.listBuiltInIntents(crossinline block: ListBuiltInIntentsRequest.Builder.() -> Unit): ListBuiltInIntentsResponse = listBuiltInIntents(ListBuiltInIntentsRequest.Builder().apply(block).build())

/**
 * Gets a list of built-in slot types that meet the specified criteria.
 */
public suspend inline fun LexModelsV2Client.listBuiltInSlotTypes(crossinline block: ListBuiltInSlotTypesRequest.Builder.() -> Unit): ListBuiltInSlotTypesResponse = listBuiltInSlotTypes(ListBuiltInSlotTypesRequest.Builder().apply(block).build())

/**
 * Paginated list of custom vocabulary items for a given bot locale's custom vocabulary.
 */
public suspend inline fun LexModelsV2Client.listCustomVocabularyItems(crossinline block: ListCustomVocabularyItemsRequest.Builder.() -> Unit): ListCustomVocabularyItemsResponse = listCustomVocabularyItems(ListCustomVocabularyItemsRequest.Builder().apply(block).build())

/**
 * Lists the exports for a bot, bot locale, or custom vocabulary. Exports are kept in the list for 7 days.
 */
public suspend inline fun LexModelsV2Client.listExports(crossinline block: ListExportsRequest.Builder.() -> Unit): ListExportsResponse = listExports(ListExportsRequest.Builder().apply(block).build())

/**
 * Lists the imports for a bot, bot locale, or custom vocabulary. Imports are kept in the list for 7 days.
 */
public suspend inline fun LexModelsV2Client.listImports(crossinline block: ListImportsRequest.Builder.() -> Unit): ListImportsResponse = listImports(ListImportsRequest.Builder().apply(block).build())

/**
 * Retrieves summary metrics for the intents in your bot. The following fields are required:
 * + `metrics` – A list of [AnalyticsIntentMetric](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsIntentMetric.html) objects. In each object, use the `name` field to specify the metric to calculate, the `statistic` field to specify whether to calculate the `Sum`, `Average`, or `Max` number, and the `order` field to specify whether to sort the results in `Ascending` or `Descending` order.
 * + `startDateTime` and `endDateTime` – Define a time range for which you want to retrieve results.
 *
 * Of the optional fields, you can organize the results in the following ways:
 * + Use the `filters` field to filter the results, the `groupBy` field to specify categories by which to group the results, and the `binBy` field to specify time intervals by which to group the results.
 * + Use the `maxResults` field to limit the number of results to return in a single response and the `nextToken` field to return the next batch of results if the response does not return the full set of results.
 *
 * Note that an `order` field exists in both `binBy` and `metrics`. You can specify only one `order` in a given request.
 */
public suspend inline fun LexModelsV2Client.listIntentMetrics(crossinline block: ListIntentMetricsRequest.Builder.() -> Unit): ListIntentMetricsResponse = listIntentMetrics(ListIntentMetricsRequest.Builder().apply(block).build())

/**
 * Retrieves summary statistics for a path of intents that users take over sessions with your bot. The following fields are required:
 * + `startDateTime` and `endDateTime` – Define a time range for which you want to retrieve results.
 * + `intentPath` – Define an order of intents for which you want to retrieve metrics. Separate intents in the path with a forward slash. For example, populate the `intentPath` field with `/BookCar/BookHotel` to see details about how many times users invoked the `BookCar` and `BookHotel` intents in that order.
 *
 * Use the optional `filters` field to filter the results.
 */
public suspend inline fun LexModelsV2Client.listIntentPaths(crossinline block: ListIntentPathsRequest.Builder.() -> Unit): ListIntentPathsResponse = listIntentPaths(ListIntentPathsRequest.Builder().apply(block).build())

/**
 * Retrieves summary metrics for the stages within intents in your bot. The following fields are required:
 * + `metrics` – A list of [AnalyticsIntentStageMetric](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsIntentStageMetric.html) objects. In each object, use the `name` field to specify the metric to calculate, the `statistic` field to specify whether to calculate the `Sum`, `Average`, or `Max` number, and the `order` field to specify whether to sort the results in `Ascending` or `Descending` order.
 * + `startDateTime` and `endDateTime` – Define a time range for which you want to retrieve results.
 *
 * Of the optional fields, you can organize the results in the following ways:
 * + Use the `filters` field to filter the results, the `groupBy` field to specify categories by which to group the results, and the `binBy` field to specify time intervals by which to group the results.
 * + Use the `maxResults` field to limit the number of results to return in a single response and the `nextToken` field to return the next batch of results if the response does not return the full set of results.
 *
 * Note that an `order` field exists in both `binBy` and `metrics`. You can only specify one `order` in a given request.
 */
public suspend inline fun LexModelsV2Client.listIntentStageMetrics(crossinline block: ListIntentStageMetricsRequest.Builder.() -> Unit): ListIntentStageMetricsResponse = listIntentStageMetrics(ListIntentStageMetricsRequest.Builder().apply(block).build())

/**
 * Get a list of intents that meet the specified criteria.
 */
public suspend inline fun LexModelsV2Client.listIntents(crossinline block: ListIntentsRequest.Builder.() -> Unit): ListIntentsResponse = listIntents(ListIntentsRequest.Builder().apply(block).build())

/**
 * Gets a list of recommended intents provided by the bot recommendation that you can use in your bot. Intents in the response are ordered by relevance.
 */
public suspend inline fun LexModelsV2Client.listRecommendedIntents(crossinline block: ListRecommendedIntentsRequest.Builder.() -> Unit): ListRecommendedIntentsResponse = listRecommendedIntents(ListRecommendedIntentsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of metadata for individual user sessions with your bot. The `startDateTime` and `endDateTime` fields are required. These fields define a time range for which you want to retrieve results. Of the optional fields, you can organize the results in the following ways:
 * + Use the `filters` field to filter the results and the `sortBy` field to specify the values by which to sort the results.
 * + Use the `maxResults` field to limit the number of results to return in a single response and the `nextToken` field to return the next batch of results if the response does not return the full set of results.
 */
public suspend inline fun LexModelsV2Client.listSessionAnalyticsData(crossinline block: ListSessionAnalyticsDataRequest.Builder.() -> Unit): ListSessionAnalyticsDataResponse = listSessionAnalyticsData(ListSessionAnalyticsDataRequest.Builder().apply(block).build())

/**
 * Retrieves summary metrics for the user sessions with your bot. The following fields are required:
 * + `metrics` – A list of [AnalyticsSessionMetric](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsSessionMetric.html) objects. In each object, use the `name` field to specify the metric to calculate, the `statistic` field to specify whether to calculate the `Sum`, `Average`, or `Max` number, and the `order` field to specify whether to sort the results in `Ascending` or `Descending` order.
 * + `startDateTime` and `endDateTime` – Define a time range for which you want to retrieve results.
 *
 * Of the optional fields, you can organize the results in the following ways:
 * + Use the `filters` field to filter the results, the `groupBy` field to specify categories by which to group the results, and the `binBy` field to specify time intervals by which to group the results.
 * + Use the `maxResults` field to limit the number of results to return in a single response and the `nextToken` field to return the next batch of results if the response does not return the full set of results.
 *
 * Note that an `order` field exists in both `binBy` and `metrics`. Currently, you can specify it in either field, but not in both.
 */
public suspend inline fun LexModelsV2Client.listSessionMetrics(crossinline block: ListSessionMetricsRequest.Builder.() -> Unit): ListSessionMetricsResponse = listSessionMetrics(ListSessionMetricsRequest.Builder().apply(block).build())

/**
 * Gets a list of slot types that match the specified criteria.
 */
public suspend inline fun LexModelsV2Client.listSlotTypes(crossinline block: ListSlotTypesRequest.Builder.() -> Unit): ListSlotTypesResponse = listSlotTypes(ListSlotTypesRequest.Builder().apply(block).build())

/**
 * Gets a list of slots that match the specified criteria.
 */
public suspend inline fun LexModelsV2Client.listSlots(crossinline block: ListSlotsRequest.Builder.() -> Unit): ListSlotsResponse = listSlots(ListSlotsRequest.Builder().apply(block).build())

/**
 * Gets a list of tags associated with a resource. Only bots, bot aliases, and bot channels can have tags associated with them.
 */
public suspend inline fun LexModelsV2Client.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Gets a list of test execution result items.
 */
public suspend inline fun LexModelsV2Client.listTestExecutionResultItems(crossinline block: ListTestExecutionResultItemsRequest.Builder.() -> Unit): ListTestExecutionResultItemsResponse = listTestExecutionResultItems(ListTestExecutionResultItemsRequest.Builder().apply(block).build())

/**
 * The list of test set executions.
 */
public suspend inline fun LexModelsV2Client.listTestExecutions(crossinline block: ListTestExecutionsRequest.Builder.() -> Unit): ListTestExecutionsResponse = listTestExecutions(ListTestExecutionsRequest.Builder().apply(block).build())

/**
 * The list of test set records.
 */
public suspend inline fun LexModelsV2Client.listTestSetRecords(crossinline block: ListTestSetRecordsRequest.Builder.() -> Unit): ListTestSetRecordsResponse = listTestSetRecords(ListTestSetRecordsRequest.Builder().apply(block).build())

/**
 * The list of the test sets
 */
public suspend inline fun LexModelsV2Client.listTestSets(crossinline block: ListTestSetsRequest.Builder.() -> Unit): ListTestSetsResponse = listTestSets(ListTestSetsRequest.Builder().apply(block).build())

/**
 * To use this API operation, your IAM role must have permissions to perform the [ListAggregatedUtterances](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html) operation, which provides access to utterance-related analytics. See [Viewing utterance statistics](https://docs.aws.amazon.com/lexv2/latest/dg/monitoring-utterances.html) for the IAM policy to apply to the IAM role.
 *
 * Retrieves a list of metadata for individual user utterances to your bot. The following fields are required:
 * + `startDateTime` and `endDateTime` – Define a time range for which you want to retrieve results.
 *
 * Of the optional fields, you can organize the results in the following ways:
 * + Use the `filters` field to filter the results and the `sortBy` field to specify the values by which to sort the results.
 * + Use the `maxResults` field to limit the number of results to return in a single response and the `nextToken` field to return the next batch of results if the response does not return the full set of results.
 */
public suspend inline fun LexModelsV2Client.listUtteranceAnalyticsData(crossinline block: ListUtteranceAnalyticsDataRequest.Builder.() -> Unit): ListUtteranceAnalyticsDataResponse = listUtteranceAnalyticsData(ListUtteranceAnalyticsDataRequest.Builder().apply(block).build())

/**
 * To use this API operation, your IAM role must have permissions to perform the [ListAggregatedUtterances](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html) operation, which provides access to utterance-related analytics. See [Viewing utterance statistics](https://docs.aws.amazon.com/lexv2/latest/dg/monitoring-utterances.html) for the IAM policy to apply to the IAM role.
 *
 * Retrieves summary metrics for the utterances in your bot. The following fields are required:
 * + `metrics` – A list of [AnalyticsUtteranceMetric](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsUtteranceMetric.html) objects. In each object, use the `name` field to specify the metric to calculate, the `statistic` field to specify whether to calculate the `Sum`, `Average`, or `Max` number, and the `order` field to specify whether to sort the results in `Ascending` or `Descending` order.
 * + `startDateTime` and `endDateTime` – Define a time range for which you want to retrieve results.
 *
 * Of the optional fields, you can organize the results in the following ways:
 * + Use the `filters` field to filter the results, the `groupBy` field to specify categories by which to group the results, and the `binBy` field to specify time intervals by which to group the results.
 * + Use the `maxResults` field to limit the number of results to return in a single response and the `nextToken` field to return the next batch of results if the response does not return the full set of results.
 *
 * Note that an `order` field exists in both `binBy` and `metrics`. Currently, you can specify it in either field, but not in both.
 */
public suspend inline fun LexModelsV2Client.listUtteranceMetrics(crossinline block: ListUtteranceMetricsRequest.Builder.() -> Unit): ListUtteranceMetricsResponse = listUtteranceMetrics(ListUtteranceMetricsRequest.Builder().apply(block).build())

/**
 * Search for associated transcripts that meet the specified criteria.
 */
public suspend inline fun LexModelsV2Client.searchAssociatedTranscripts(crossinline block: SearchAssociatedTranscriptsRequest.Builder.() -> Unit): SearchAssociatedTranscriptsResponse = searchAssociatedTranscripts(SearchAssociatedTranscriptsRequest.Builder().apply(block).build())

/**
 * Use this to provide your transcript data, and to start the bot recommendation process.
 */
public suspend inline fun LexModelsV2Client.startBotRecommendation(crossinline block: StartBotRecommendationRequest.Builder.() -> Unit): StartBotRecommendationResponse = startBotRecommendation(StartBotRecommendationRequest.Builder().apply(block).build())

/**
 * Starts a request for the descriptive bot builder to generate a bot locale configuration based on the prompt you provide it. After you make this call, use the `DescribeBotResourceGeneration` operation to check on the status of the generation and for the `generatedBotLocaleUrl` when the generation is complete. Use that value to retrieve the Amazon S3 object containing the bot locale configuration. You can then modify and import this configuration.
 */
public suspend inline fun LexModelsV2Client.startBotResourceGeneration(crossinline block: StartBotResourceGenerationRequest.Builder.() -> Unit): StartBotResourceGenerationResponse = startBotResourceGeneration(StartBotResourceGenerationRequest.Builder().apply(block).build())

/**
 * Starts importing a bot, bot locale, or custom vocabulary from a zip archive that you uploaded to an S3 bucket.
 */
public suspend inline fun LexModelsV2Client.startImport(crossinline block: StartImportRequest.Builder.() -> Unit): StartImportResponse = startImport(StartImportRequest.Builder().apply(block).build())

/**
 * The action to start test set execution.
 */
public suspend inline fun LexModelsV2Client.startTestExecution(crossinline block: StartTestExecutionRequest.Builder.() -> Unit): StartTestExecutionResponse = startTestExecution(StartTestExecutionRequest.Builder().apply(block).build())

/**
 * The action to start the generation of test set.
 */
public suspend inline fun LexModelsV2Client.startTestSetGeneration(crossinline block: StartTestSetGenerationRequest.Builder.() -> Unit): StartTestSetGenerationResponse = startTestSetGeneration(StartTestSetGenerationRequest.Builder().apply(block).build())

/**
 * Stop an already running Bot Recommendation request.
 */
public suspend inline fun LexModelsV2Client.stopBotRecommendation(crossinline block: StopBotRecommendationRequest.Builder.() -> Unit): StopBotRecommendationResponse = stopBotRecommendation(StopBotRecommendationRequest.Builder().apply(block).build())

/**
 * Adds the specified tags to the specified resource. If a tag key already exists, the existing value is replaced with the new value.
 */
public suspend inline fun LexModelsV2Client.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from a bot, bot alias, or bot channel.
 */
public suspend inline fun LexModelsV2Client.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the configuration of an existing bot.
 */
public suspend inline fun LexModelsV2Client.updateBot(crossinline block: UpdateBotRequest.Builder.() -> Unit): UpdateBotResponse = updateBot(UpdateBotRequest.Builder().apply(block).build())

/**
 * Updates the configuration of an existing bot alias.
 */
public suspend inline fun LexModelsV2Client.updateBotAlias(crossinline block: UpdateBotAliasRequest.Builder.() -> Unit): UpdateBotAliasResponse = updateBotAlias(UpdateBotAliasRequest.Builder().apply(block).build())

/**
 * Updates the settings that a bot has for a specific locale.
 */
public suspend inline fun LexModelsV2Client.updateBotLocale(crossinline block: UpdateBotLocaleRequest.Builder.() -> Unit): UpdateBotLocaleResponse = updateBotLocale(UpdateBotLocaleRequest.Builder().apply(block).build())

/**
 * Updates an existing bot recommendation request.
 */
public suspend inline fun LexModelsV2Client.updateBotRecommendation(crossinline block: UpdateBotRecommendationRequest.Builder.() -> Unit): UpdateBotRecommendationResponse = updateBotRecommendation(UpdateBotRecommendationRequest.Builder().apply(block).build())

/**
 * Updates the password used to protect an export zip archive.
 *
 * The password is not required. If you don't supply a password, Amazon Lex generates a zip file that is not protected by a password. This is the archive that is available at the pre-signed S3 URL provided by the [DescribeExport](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html) operation.
 */
public suspend inline fun LexModelsV2Client.updateExport(crossinline block: UpdateExportRequest.Builder.() -> Unit): UpdateExportResponse = updateExport(UpdateExportRequest.Builder().apply(block).build())

/**
 * Updates the settings for an intent.
 */
public suspend inline fun LexModelsV2Client.updateIntent(crossinline block: UpdateIntentRequest.Builder.() -> Unit): UpdateIntentResponse = updateIntent(UpdateIntentRequest.Builder().apply(block).build())

/**
 * Replaces the existing resource policy for a bot or bot alias with a new one. If the policy doesn't exist, Amazon Lex returns an exception.
 */
public suspend inline fun LexModelsV2Client.updateResourcePolicy(crossinline block: UpdateResourcePolicyRequest.Builder.() -> Unit): UpdateResourcePolicyResponse = updateResourcePolicy(UpdateResourcePolicyRequest.Builder().apply(block).build())

/**
 * Updates the settings for a slot.
 */
public suspend inline fun LexModelsV2Client.updateSlot(crossinline block: UpdateSlotRequest.Builder.() -> Unit): UpdateSlotResponse = updateSlot(UpdateSlotRequest.Builder().apply(block).build())

/**
 * Updates the configuration of an existing slot type.
 */
public suspend inline fun LexModelsV2Client.updateSlotType(crossinline block: UpdateSlotTypeRequest.Builder.() -> Unit): UpdateSlotTypeResponse = updateSlotType(UpdateSlotTypeRequest.Builder().apply(block).build())

/**
 * The action to update the test set.
 */
public suspend inline fun LexModelsV2Client.updateTestSet(crossinline block: UpdateTestSetRequest.Builder.() -> Unit): UpdateTestSetResponse = updateTestSet(UpdateTestSetRequest.Builder().apply(block).build())
