// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.lexmodelsv2.auth.LexModelsV2AuthSchemeProviderAdapter
import aws.sdk.kotlin.services.lexmodelsv2.auth.LexModelsV2IdentityProviderConfigAdapter
import aws.sdk.kotlin.services.lexmodelsv2.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.lexmodelsv2.model.*
import aws.sdk.kotlin.services.lexmodelsv2.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultLexModelsV2Client(override val config: LexModelsV2Client.Config) : LexModelsV2Client {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = LexModelsV2IdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "lex")
        }
        toMap()
    }
    private val authSchemeAdapter = LexModelsV2AuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.lexmodelsv2"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Create a batch of custom vocabulary items for a given bot locale's custom vocabulary.
     */
    override suspend fun batchCreateCustomVocabularyItem(input: BatchCreateCustomVocabularyItemRequest): BatchCreateCustomVocabularyItemResponse {
        val op = SdkHttpOperation.build<BatchCreateCustomVocabularyItemRequest, BatchCreateCustomVocabularyItemResponse> {
            serializer = BatchCreateCustomVocabularyItemOperationSerializer()
            deserializer = BatchCreateCustomVocabularyItemOperationDeserializer()
            operationName = "BatchCreateCustomVocabularyItem"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Delete a batch of custom vocabulary items for a given bot locale's custom vocabulary.
     */
    override suspend fun batchDeleteCustomVocabularyItem(input: BatchDeleteCustomVocabularyItemRequest): BatchDeleteCustomVocabularyItemResponse {
        val op = SdkHttpOperation.build<BatchDeleteCustomVocabularyItemRequest, BatchDeleteCustomVocabularyItemResponse> {
            serializer = BatchDeleteCustomVocabularyItemOperationSerializer()
            deserializer = BatchDeleteCustomVocabularyItemOperationDeserializer()
            operationName = "BatchDeleteCustomVocabularyItem"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Update a batch of custom vocabulary items for a given bot locale's custom vocabulary.
     */
    override suspend fun batchUpdateCustomVocabularyItem(input: BatchUpdateCustomVocabularyItemRequest): BatchUpdateCustomVocabularyItemResponse {
        val op = SdkHttpOperation.build<BatchUpdateCustomVocabularyItemRequest, BatchUpdateCustomVocabularyItemResponse> {
            serializer = BatchUpdateCustomVocabularyItemOperationSerializer()
            deserializer = BatchUpdateCustomVocabularyItemOperationDeserializer()
            operationName = "BatchUpdateCustomVocabularyItem"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Builds a bot, its intents, and its slot types into a specific locale. A bot can be built into multiple locales. At runtime the locale is used to choose a specific build of the bot.
     */
    override suspend fun buildBotLocale(input: BuildBotLocaleRequest): BuildBotLocaleResponse {
        val op = SdkHttpOperation.build<BuildBotLocaleRequest, BuildBotLocaleResponse> {
            serializer = BuildBotLocaleOperationSerializer()
            deserializer = BuildBotLocaleOperationDeserializer()
            operationName = "BuildBotLocale"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon Lex conversational bot.
     */
    override suspend fun createBot(input: CreateBotRequest): CreateBotResponse {
        val op = SdkHttpOperation.build<CreateBotRequest, CreateBotResponse> {
            serializer = CreateBotOperationSerializer()
            deserializer = CreateBotOperationDeserializer()
            operationName = "CreateBot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an alias for the specified version of a bot. Use an alias to enable you to change the version of a bot without updating applications that use the bot.
     *
     * For example, you can create an alias called "PROD" that your applications use to call the Amazon Lex bot.
     */
    override suspend fun createBotAlias(input: CreateBotAliasRequest): CreateBotAliasResponse {
        val op = SdkHttpOperation.build<CreateBotAliasRequest, CreateBotAliasResponse> {
            serializer = CreateBotAliasOperationSerializer()
            deserializer = CreateBotAliasOperationDeserializer()
            operationName = "CreateBotAlias"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a locale in the bot. The locale contains the intents and slot types that the bot uses in conversations with users in the specified language and locale. You must add a locale to a bot before you can add intents and slot types to the bot.
     */
    override suspend fun createBotLocale(input: CreateBotLocaleRequest): CreateBotLocaleResponse {
        val op = SdkHttpOperation.build<CreateBotLocaleRequest, CreateBotLocaleResponse> {
            serializer = CreateBotLocaleOperationSerializer()
            deserializer = CreateBotLocaleOperationDeserializer()
            operationName = "CreateBotLocale"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an immutable version of the bot. When you create the first version of a bot, Amazon Lex sets the version number to 1. Subsequent bot versions increase in an increment of 1. The version number will always represent the total number of versions created of the bot, not the current number of versions. If a bot version is deleted, that bot version number will not be reused.
     */
    override suspend fun createBotVersion(input: CreateBotVersionRequest): CreateBotVersionResponse {
        val op = SdkHttpOperation.build<CreateBotVersionRequest, CreateBotVersionResponse> {
            serializer = CreateBotVersionOperationSerializer()
            deserializer = CreateBotVersionOperationDeserializer()
            operationName = "CreateBotVersion"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a zip archive containing the contents of a bot or a bot locale. The archive contains a directory structure that contains JSON files that define the bot.
     *
     * You can create an archive that contains the complete definition of a bot, or you can specify that the archive contain only the definition of a single bot locale.
     *
     * For more information about exporting bots, and about the structure of the export archive, see [ Importing and exporting bots ](https://docs.aws.amazon.com/lexv2/latest/dg/importing-exporting.html)
     */
    override suspend fun createExport(input: CreateExportRequest): CreateExportResponse {
        val op = SdkHttpOperation.build<CreateExportRequest, CreateExportResponse> {
            serializer = CreateExportOperationSerializer()
            deserializer = CreateExportOperationDeserializer()
            operationName = "CreateExport"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an intent.
     *
     * To define the interaction between the user and your bot, you define one or more intents. For example, for a pizza ordering bot you would create an `OrderPizza` intent.
     *
     * When you create an intent, you must provide a name. You can optionally provide the following:
     * + Sample utterances. For example, "I want to order a pizza" and "Can I order a pizza." You can't provide utterances for built-in intents.
     * + Information to be gathered. You specify slots for the information that you bot requests from the user. You can specify standard slot types, such as date and time, or custom slot types for your application.
     * + How the intent is fulfilled. You can provide a Lambda function or configure the intent to return the intent information to your client application. If you use a Lambda function, Amazon Lex invokes the function when all of the intent information is available.
     * + A confirmation prompt to send to the user to confirm an intent. For example, "Shall I order your pizza?"
     * + A conclusion statement to send to the user after the intent is fulfilled. For example, "I ordered your pizza."
     * + A follow-up prompt that asks the user for additional activity. For example, "Do you want a drink with your pizza?"
     */
    override suspend fun createIntent(input: CreateIntentRequest): CreateIntentResponse {
        val op = SdkHttpOperation.build<CreateIntentRequest, CreateIntentResponse> {
            serializer = CreateIntentOperationSerializer()
            deserializer = CreateIntentOperationDeserializer()
            operationName = "CreateIntent"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new resource policy with the specified policy statements.
     */
    override suspend fun createResourcePolicy(input: CreateResourcePolicyRequest): CreateResourcePolicyResponse {
        val op = SdkHttpOperation.build<CreateResourcePolicyRequest, CreateResourcePolicyResponse> {
            serializer = CreateResourcePolicyOperationSerializer()
            deserializer = CreateResourcePolicyOperationDeserializer()
            operationName = "CreateResourcePolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds a new resource policy statement to a bot or bot alias. If a resource policy exists, the statement is added to the current resource policy. If a policy doesn't exist, a new policy is created.
     *
     * You can't create a resource policy statement that allows cross-account access.
     */
    override suspend fun createResourcePolicyStatement(input: CreateResourcePolicyStatementRequest): CreateResourcePolicyStatementResponse {
        val op = SdkHttpOperation.build<CreateResourcePolicyStatementRequest, CreateResourcePolicyStatementResponse> {
            serializer = CreateResourcePolicyStatementOperationSerializer()
            deserializer = CreateResourcePolicyStatementOperationDeserializer()
            operationName = "CreateResourcePolicyStatement"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a slot in an intent. A slot is a variable needed to fulfill an intent. For example, an `OrderPizza` intent might need slots for size, crust, and number of pizzas. For each slot, you define one or more utterances that Amazon Lex uses to elicit a response from the user.
     */
    override suspend fun createSlot(input: CreateSlotRequest): CreateSlotResponse {
        val op = SdkHttpOperation.build<CreateSlotRequest, CreateSlotResponse> {
            serializer = CreateSlotOperationSerializer()
            deserializer = CreateSlotOperationDeserializer()
            operationName = "CreateSlot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a custom slot type
     *
     *  To create a custom slot type, specify a name for the slot type and a set of enumeration values, the values that a slot of this type can assume.
     */
    override suspend fun createSlotType(input: CreateSlotTypeRequest): CreateSlotTypeResponse {
        val op = SdkHttpOperation.build<CreateSlotTypeRequest, CreateSlotTypeResponse> {
            serializer = CreateSlotTypeOperationSerializer()
            deserializer = CreateSlotTypeOperationDeserializer()
            operationName = "CreateSlotType"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Create a report that describes the differences between the bot and the test set.
     */
    override suspend fun createTestSetDiscrepancyReport(input: CreateTestSetDiscrepancyReportRequest): CreateTestSetDiscrepancyReportResponse {
        val op = SdkHttpOperation.build<CreateTestSetDiscrepancyReportRequest, CreateTestSetDiscrepancyReportResponse> {
            serializer = CreateTestSetDiscrepancyReportOperationSerializer()
            deserializer = CreateTestSetDiscrepancyReportOperationDeserializer()
            operationName = "CreateTestSetDiscrepancyReport"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a pre-signed S3 write URL that you use to upload the zip archive when importing a bot or a bot locale.
     */
    override suspend fun createUploadUrl(input: CreateUploadUrlRequest): CreateUploadUrlResponse {
        val op = SdkHttpOperation.build<CreateUploadUrlRequest, CreateUploadUrlResponse> {
            serializer = CreateUploadUrlOperationSerializer()
            deserializer = CreateUploadUrlOperationDeserializer()
            operationName = "CreateUploadUrl"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes all versions of a bot, including the `Draft` version. To delete a specific version, use the `DeleteBotVersion` operation.
     *
     * When you delete a bot, all of the resources contained in the bot are also deleted. Deleting a bot removes all locales, intents, slot, and slot types defined for the bot.
     *
     * If a bot has an alias, the `DeleteBot` operation returns a `ResourceInUseException` exception. If you want to delete the bot and the alias, set the `skipResourceInUseCheck` parameter to `true`.
     */
    override suspend fun deleteBot(input: DeleteBotRequest): DeleteBotResponse {
        val op = SdkHttpOperation.build<DeleteBotRequest, DeleteBotResponse> {
            serializer = DeleteBotOperationSerializer()
            deserializer = DeleteBotOperationDeserializer()
            operationName = "DeleteBot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified bot alias.
     */
    override suspend fun deleteBotAlias(input: DeleteBotAliasRequest): DeleteBotAliasResponse {
        val op = SdkHttpOperation.build<DeleteBotAliasRequest, DeleteBotAliasResponse> {
            serializer = DeleteBotAliasOperationSerializer()
            deserializer = DeleteBotAliasOperationDeserializer()
            operationName = "DeleteBotAlias"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a locale from a bot.
     *
     * When you delete a locale, all intents, slots, and slot types defined for the locale are also deleted.
     */
    override suspend fun deleteBotLocale(input: DeleteBotLocaleRequest): DeleteBotLocaleResponse {
        val op = SdkHttpOperation.build<DeleteBotLocaleRequest, DeleteBotLocaleResponse> {
            serializer = DeleteBotLocaleOperationSerializer()
            deserializer = DeleteBotLocaleOperationDeserializer()
            operationName = "DeleteBotLocale"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a specific version of a bot. To delete all versions of a bot, use the [DeleteBot](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DeleteBot.html) operation.
     */
    override suspend fun deleteBotVersion(input: DeleteBotVersionRequest): DeleteBotVersionResponse {
        val op = SdkHttpOperation.build<DeleteBotVersionRequest, DeleteBotVersionResponse> {
            serializer = DeleteBotVersionOperationSerializer()
            deserializer = DeleteBotVersionOperationDeserializer()
            operationName = "DeleteBotVersion"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a custom vocabulary from the specified locale in the specified bot.
     */
    override suspend fun deleteCustomVocabulary(input: DeleteCustomVocabularyRequest): DeleteCustomVocabularyResponse {
        val op = SdkHttpOperation.build<DeleteCustomVocabularyRequest, DeleteCustomVocabularyResponse> {
            serializer = DeleteCustomVocabularyOperationSerializer()
            deserializer = DeleteCustomVocabularyOperationDeserializer()
            operationName = "DeleteCustomVocabulary"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a previous export and the associated files stored in an S3 bucket.
     */
    override suspend fun deleteExport(input: DeleteExportRequest): DeleteExportResponse {
        val op = SdkHttpOperation.build<DeleteExportRequest, DeleteExportResponse> {
            serializer = DeleteExportOperationSerializer()
            deserializer = DeleteExportOperationDeserializer()
            operationName = "DeleteExport"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a previous import and the associated file stored in an S3 bucket.
     */
    override suspend fun deleteImport(input: DeleteImportRequest): DeleteImportResponse {
        val op = SdkHttpOperation.build<DeleteImportRequest, DeleteImportResponse> {
            serializer = DeleteImportOperationSerializer()
            deserializer = DeleteImportOperationDeserializer()
            operationName = "DeleteImport"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified intent.
     *
     * Deleting an intent also deletes the slots associated with the intent.
     */
    override suspend fun deleteIntent(input: DeleteIntentRequest): DeleteIntentResponse {
        val op = SdkHttpOperation.build<DeleteIntentRequest, DeleteIntentResponse> {
            serializer = DeleteIntentOperationSerializer()
            deserializer = DeleteIntentOperationDeserializer()
            operationName = "DeleteIntent"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes an existing policy from a bot or bot alias. If the resource doesn't have a policy attached, Amazon Lex returns an exception.
     */
    override suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse {
        val op = SdkHttpOperation.build<DeleteResourcePolicyRequest, DeleteResourcePolicyResponse> {
            serializer = DeleteResourcePolicyOperationSerializer()
            deserializer = DeleteResourcePolicyOperationDeserializer()
            operationName = "DeleteResourcePolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a policy statement from a resource policy. If you delete the last statement from a policy, the policy is deleted. If you specify a statement ID that doesn't exist in the policy, or if the bot or bot alias doesn't have a policy attached, Amazon Lex returns an exception.
     */
    override suspend fun deleteResourcePolicyStatement(input: DeleteResourcePolicyStatementRequest): DeleteResourcePolicyStatementResponse {
        val op = SdkHttpOperation.build<DeleteResourcePolicyStatementRequest, DeleteResourcePolicyStatementResponse> {
            serializer = DeleteResourcePolicyStatementOperationSerializer()
            deserializer = DeleteResourcePolicyStatementOperationDeserializer()
            operationName = "DeleteResourcePolicyStatement"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified slot from an intent.
     */
    override suspend fun deleteSlot(input: DeleteSlotRequest): DeleteSlotResponse {
        val op = SdkHttpOperation.build<DeleteSlotRequest, DeleteSlotResponse> {
            serializer = DeleteSlotOperationSerializer()
            deserializer = DeleteSlotOperationDeserializer()
            operationName = "DeleteSlot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a slot type from a bot locale.
     *
     * If a slot is using the slot type, Amazon Lex throws a `ResourceInUseException` exception. To avoid the exception, set the `skipResourceInUseCheck` parameter to `true`.
     */
    override suspend fun deleteSlotType(input: DeleteSlotTypeRequest): DeleteSlotTypeResponse {
        val op = SdkHttpOperation.build<DeleteSlotTypeRequest, DeleteSlotTypeResponse> {
            serializer = DeleteSlotTypeOperationSerializer()
            deserializer = DeleteSlotTypeOperationDeserializer()
            operationName = "DeleteSlotType"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * The action to delete the selected test set.
     */
    override suspend fun deleteTestSet(input: DeleteTestSetRequest): DeleteTestSetResponse {
        val op = SdkHttpOperation.build<DeleteTestSetRequest, DeleteTestSetResponse> {
            serializer = DeleteTestSetOperationSerializer()
            deserializer = DeleteTestSetOperationDeserializer()
            operationName = "DeleteTestSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes stored utterances.
     *
     * Amazon Lex stores the utterances that users send to your bot. Utterances are stored for 15 days for use with the [ListAggregatedUtterances](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html) operation, and then stored indefinitely for use in improving the ability of your bot to respond to user input..
     *
     * Use the `DeleteUtterances` operation to manually delete utterances for a specific session. When you use the `DeleteUtterances` operation, utterances stored for improving your bot's ability to respond to user input are deleted immediately. Utterances stored for use with the `ListAggregatedUtterances` operation are deleted after 15 days.
     */
    override suspend fun deleteUtterances(input: DeleteUtterancesRequest): DeleteUtterancesResponse {
        val op = SdkHttpOperation.build<DeleteUtterancesRequest, DeleteUtterancesResponse> {
            serializer = DeleteUtterancesOperationSerializer()
            deserializer = DeleteUtterancesOperationDeserializer()
            operationName = "DeleteUtterances"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides metadata information about a bot.
     */
    override suspend fun describeBot(input: DescribeBotRequest): DescribeBotResponse {
        val op = SdkHttpOperation.build<DescribeBotRequest, DescribeBotResponse> {
            serializer = DescribeBotOperationSerializer()
            deserializer = DescribeBotOperationDeserializer()
            operationName = "DescribeBot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get information about a specific bot alias.
     */
    override suspend fun describeBotAlias(input: DescribeBotAliasRequest): DescribeBotAliasResponse {
        val op = SdkHttpOperation.build<DescribeBotAliasRequest, DescribeBotAliasResponse> {
            serializer = DescribeBotAliasOperationSerializer()
            deserializer = DescribeBotAliasOperationDeserializer()
            operationName = "DescribeBotAlias"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the settings that a bot has for a specific locale.
     */
    override suspend fun describeBotLocale(input: DescribeBotLocaleRequest): DescribeBotLocaleResponse {
        val op = SdkHttpOperation.build<DescribeBotLocaleRequest, DescribeBotLocaleResponse> {
            serializer = DescribeBotLocaleOperationSerializer()
            deserializer = DescribeBotLocaleOperationDeserializer()
            operationName = "DescribeBotLocale"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides metadata information about a bot recommendation. This information will enable you to get a description on the request inputs, to download associated transcripts after processing is complete, and to download intents and slot-types generated by the bot recommendation.
     */
    override suspend fun describeBotRecommendation(input: DescribeBotRecommendationRequest): DescribeBotRecommendationResponse {
        val op = SdkHttpOperation.build<DescribeBotRecommendationRequest, DescribeBotRecommendationResponse> {
            serializer = DescribeBotRecommendationOperationSerializer()
            deserializer = DescribeBotRecommendationOperationDeserializer()
            operationName = "DescribeBotRecommendation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a request to generate a bot through natural language description, made through the `StartBotResource` API. Use the `generatedBotLocaleUrl` to retrieve the Amazon S3 object containing the bot locale configuration. You can then modify and import this configuration.
     */
    override suspend fun describeBotResourceGeneration(input: DescribeBotResourceGenerationRequest): DescribeBotResourceGenerationResponse {
        val op = SdkHttpOperation.build<DescribeBotResourceGenerationRequest, DescribeBotResourceGenerationResponse> {
            serializer = DescribeBotResourceGenerationOperationSerializer()
            deserializer = DescribeBotResourceGenerationOperationDeserializer()
            operationName = "DescribeBotResourceGeneration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides metadata about a version of a bot.
     */
    override suspend fun describeBotVersion(input: DescribeBotVersionRequest): DescribeBotVersionResponse {
        val op = SdkHttpOperation.build<DescribeBotVersionRequest, DescribeBotVersionResponse> {
            serializer = DescribeBotVersionOperationSerializer()
            deserializer = DescribeBotVersionOperationDeserializer()
            operationName = "DescribeBotVersion"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides metadata information about a custom vocabulary.
     */
    override suspend fun describeCustomVocabularyMetadata(input: DescribeCustomVocabularyMetadataRequest): DescribeCustomVocabularyMetadataResponse {
        val op = SdkHttpOperation.build<DescribeCustomVocabularyMetadataRequest, DescribeCustomVocabularyMetadataResponse> {
            serializer = DescribeCustomVocabularyMetadataOperationSerializer()
            deserializer = DescribeCustomVocabularyMetadataOperationDeserializer()
            operationName = "DescribeCustomVocabularyMetadata"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a specific export.
     */
    override suspend fun describeExport(input: DescribeExportRequest): DescribeExportResponse {
        val op = SdkHttpOperation.build<DescribeExportRequest, DescribeExportResponse> {
            serializer = DescribeExportOperationSerializer()
            deserializer = DescribeExportOperationDeserializer()
            operationName = "DescribeExport"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a specific import.
     */
    override suspend fun describeImport(input: DescribeImportRequest): DescribeImportResponse {
        val op = SdkHttpOperation.build<DescribeImportRequest, DescribeImportResponse> {
            serializer = DescribeImportOperationSerializer()
            deserializer = DescribeImportOperationDeserializer()
            operationName = "DescribeImport"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata about an intent.
     */
    override suspend fun describeIntent(input: DescribeIntentRequest): DescribeIntentResponse {
        val op = SdkHttpOperation.build<DescribeIntentRequest, DescribeIntentResponse> {
            serializer = DescribeIntentOperationSerializer()
            deserializer = DescribeIntentOperationDeserializer()
            operationName = "DescribeIntent"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the resource policy and policy revision for a bot or bot alias.
     */
    override suspend fun describeResourcePolicy(input: DescribeResourcePolicyRequest): DescribeResourcePolicyResponse {
        val op = SdkHttpOperation.build<DescribeResourcePolicyRequest, DescribeResourcePolicyResponse> {
            serializer = DescribeResourcePolicyOperationSerializer()
            deserializer = DescribeResourcePolicyOperationDeserializer()
            operationName = "DescribeResourcePolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets metadata information about a slot.
     */
    override suspend fun describeSlot(input: DescribeSlotRequest): DescribeSlotResponse {
        val op = SdkHttpOperation.build<DescribeSlotRequest, DescribeSlotResponse> {
            serializer = DescribeSlotOperationSerializer()
            deserializer = DescribeSlotOperationDeserializer()
            operationName = "DescribeSlot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets metadata information about a slot type.
     */
    override suspend fun describeSlotType(input: DescribeSlotTypeRequest): DescribeSlotTypeResponse {
        val op = SdkHttpOperation.build<DescribeSlotTypeRequest, DescribeSlotTypeResponse> {
            serializer = DescribeSlotTypeOperationSerializer()
            deserializer = DescribeSlotTypeOperationDeserializer()
            operationName = "DescribeSlotType"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets metadata information about the test execution.
     */
    override suspend fun describeTestExecution(input: DescribeTestExecutionRequest): DescribeTestExecutionResponse {
        val op = SdkHttpOperation.build<DescribeTestExecutionRequest, DescribeTestExecutionResponse> {
            serializer = DescribeTestExecutionOperationSerializer()
            deserializer = DescribeTestExecutionOperationDeserializer()
            operationName = "DescribeTestExecution"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets metadata information about the test set.
     */
    override suspend fun describeTestSet(input: DescribeTestSetRequest): DescribeTestSetResponse {
        val op = SdkHttpOperation.build<DescribeTestSetRequest, DescribeTestSetResponse> {
            serializer = DescribeTestSetOperationSerializer()
            deserializer = DescribeTestSetOperationDeserializer()
            operationName = "DescribeTestSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets metadata information about the test set discrepancy report.
     */
    override suspend fun describeTestSetDiscrepancyReport(input: DescribeTestSetDiscrepancyReportRequest): DescribeTestSetDiscrepancyReportResponse {
        val op = SdkHttpOperation.build<DescribeTestSetDiscrepancyReportRequest, DescribeTestSetDiscrepancyReportResponse> {
            serializer = DescribeTestSetDiscrepancyReportOperationSerializer()
            deserializer = DescribeTestSetDiscrepancyReportOperationDeserializer()
            operationName = "DescribeTestSetDiscrepancyReport"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets metadata information about the test set generation.
     */
    override suspend fun describeTestSetGeneration(input: DescribeTestSetGenerationRequest): DescribeTestSetGenerationResponse {
        val op = SdkHttpOperation.build<DescribeTestSetGenerationRequest, DescribeTestSetGenerationResponse> {
            serializer = DescribeTestSetGenerationOperationSerializer()
            deserializer = DescribeTestSetGenerationOperationDeserializer()
            operationName = "DescribeTestSetGeneration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Generates sample utterances for an intent.
     */
    override suspend fun generateBotElement(input: GenerateBotElementRequest): GenerateBotElementResponse {
        val op = SdkHttpOperation.build<GenerateBotElementRequest, GenerateBotElementResponse> {
            serializer = GenerateBotElementOperationSerializer()
            deserializer = GenerateBotElementOperationDeserializer()
            operationName = "GenerateBotElement"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * The pre-signed Amazon S3 URL to download the test execution result artifacts.
     */
    override suspend fun getTestExecutionArtifactsUrl(input: GetTestExecutionArtifactsUrlRequest): GetTestExecutionArtifactsUrlResponse {
        val op = SdkHttpOperation.build<GetTestExecutionArtifactsUrlRequest, GetTestExecutionArtifactsUrlResponse> {
            serializer = GetTestExecutionArtifactsUrlOperationSerializer()
            deserializer = GetTestExecutionArtifactsUrlOperationDeserializer()
            operationName = "GetTestExecutionArtifactsUrl"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides a list of utterances that users have sent to the bot.
     *
     * Utterances are aggregated by the text of the utterance. For example, all instances where customers used the phrase "I want to order pizza" are aggregated into the same line in the response.
     *
     * You can see both detected utterances and missed utterances. A detected utterance is where the bot properly recognized the utterance and activated the associated intent. A missed utterance was not recognized by the bot and didn't activate an intent.
     *
     * Utterances can be aggregated for a bot alias or for a bot version, but not both at the same time.
     *
     * Utterances statistics are not generated under the following conditions:
     * + The `childDirected` field was set to true when the bot was created.
     * + You are using slot obfuscation with one or more slots.
     * + You opted out of participating in improving Amazon Lex.
     */
    override suspend fun listAggregatedUtterances(input: ListAggregatedUtterancesRequest): ListAggregatedUtterancesResponse {
        val op = SdkHttpOperation.build<ListAggregatedUtterancesRequest, ListAggregatedUtterancesResponse> {
            serializer = ListAggregatedUtterancesOperationSerializer()
            deserializer = ListAggregatedUtterancesOperationDeserializer()
            operationName = "ListAggregatedUtterances"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of aliases for the specified bot.
     */
    override suspend fun listBotAliases(input: ListBotAliasesRequest): ListBotAliasesResponse {
        val op = SdkHttpOperation.build<ListBotAliasesRequest, ListBotAliasesResponse> {
            serializer = ListBotAliasesOperationSerializer()
            deserializer = ListBotAliasesOperationDeserializer()
            operationName = "ListBotAliases"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of locales for the specified bot.
     */
    override suspend fun listBotLocales(input: ListBotLocalesRequest): ListBotLocalesResponse {
        val op = SdkHttpOperation.build<ListBotLocalesRequest, ListBotLocalesResponse> {
            serializer = ListBotLocalesOperationSerializer()
            deserializer = ListBotLocalesOperationDeserializer()
            operationName = "ListBotLocales"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get a list of bot recommendations that meet the specified criteria.
     */
    override suspend fun listBotRecommendations(input: ListBotRecommendationsRequest): ListBotRecommendationsResponse {
        val op = SdkHttpOperation.build<ListBotRecommendationsRequest, ListBotRecommendationsResponse> {
            serializer = ListBotRecommendationsOperationSerializer()
            deserializer = ListBotRecommendationsOperationDeserializer()
            operationName = "ListBotRecommendations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the generation requests made for a bot locale.
     */
    override suspend fun listBotResourceGenerations(input: ListBotResourceGenerationsRequest): ListBotResourceGenerationsResponse {
        val op = SdkHttpOperation.build<ListBotResourceGenerationsRequest, ListBotResourceGenerationsResponse> {
            serializer = ListBotResourceGenerationsOperationSerializer()
            deserializer = ListBotResourceGenerationsOperationDeserializer()
            operationName = "ListBotResourceGenerations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about all of the versions of a bot.
     *
     * The `ListBotVersions` operation returns a summary of each version of a bot. For example, if a bot has three numbered versions, the `ListBotVersions` operation returns for summaries, one for each numbered version and one for the `DRAFT` version.
     *
     * The `ListBotVersions` operation always returns at least one version, the `DRAFT` version.
     */
    override suspend fun listBotVersions(input: ListBotVersionsRequest): ListBotVersionsResponse {
        val op = SdkHttpOperation.build<ListBotVersionsRequest, ListBotVersionsResponse> {
            serializer = ListBotVersionsOperationSerializer()
            deserializer = ListBotVersionsOperationDeserializer()
            operationName = "ListBotVersions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of available bots.
     */
    override suspend fun listBots(input: ListBotsRequest): ListBotsResponse {
        val op = SdkHttpOperation.build<ListBotsRequest, ListBotsResponse> {
            serializer = ListBotsOperationSerializer()
            deserializer = ListBotsOperationDeserializer()
            operationName = "ListBots"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
     *
     * To use a built-in intent as a the base for your own intent, include the built-in intent signature in the `parentIntentSignature` parameter when you call the `CreateIntent` operation. For more information, see [CreateIntent](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateIntent.html).
     */
    override suspend fun listBuiltInIntents(input: ListBuiltInIntentsRequest): ListBuiltInIntentsResponse {
        val op = SdkHttpOperation.build<ListBuiltInIntentsRequest, ListBuiltInIntentsResponse> {
            serializer = ListBuiltInIntentsOperationSerializer()
            deserializer = ListBuiltInIntentsOperationDeserializer()
            operationName = "ListBuiltInIntents"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of built-in slot types that meet the specified criteria.
     */
    override suspend fun listBuiltInSlotTypes(input: ListBuiltInSlotTypesRequest): ListBuiltInSlotTypesResponse {
        val op = SdkHttpOperation.build<ListBuiltInSlotTypesRequest, ListBuiltInSlotTypesResponse> {
            serializer = ListBuiltInSlotTypesOperationSerializer()
            deserializer = ListBuiltInSlotTypesOperationDeserializer()
            operationName = "ListBuiltInSlotTypes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Paginated list of custom vocabulary items for a given bot locale's custom vocabulary.
     */
    override suspend fun listCustomVocabularyItems(input: ListCustomVocabularyItemsRequest): ListCustomVocabularyItemsResponse {
        val op = SdkHttpOperation.build<ListCustomVocabularyItemsRequest, ListCustomVocabularyItemsResponse> {
            serializer = ListCustomVocabularyItemsOperationSerializer()
            deserializer = ListCustomVocabularyItemsOperationDeserializer()
            operationName = "ListCustomVocabularyItems"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the exports for a bot, bot locale, or custom vocabulary. Exports are kept in the list for 7 days.
     */
    override suspend fun listExports(input: ListExportsRequest): ListExportsResponse {
        val op = SdkHttpOperation.build<ListExportsRequest, ListExportsResponse> {
            serializer = ListExportsOperationSerializer()
            deserializer = ListExportsOperationDeserializer()
            operationName = "ListExports"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the imports for a bot, bot locale, or custom vocabulary. Imports are kept in the list for 7 days.
     */
    override suspend fun listImports(input: ListImportsRequest): ListImportsResponse {
        val op = SdkHttpOperation.build<ListImportsRequest, ListImportsResponse> {
            serializer = ListImportsOperationSerializer()
            deserializer = ListImportsOperationDeserializer()
            operationName = "ListImports"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves summary metrics for the intents in your bot. The following fields are required:
     * + `metrics` – A list of [AnalyticsIntentMetric](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsIntentMetric.html) objects. In each object, use the `name` field to specify the metric to calculate, the `statistic` field to specify whether to calculate the `Sum`, `Average`, or `Max` number, and the `order` field to specify whether to sort the results in `Ascending` or `Descending` order.
     * + `startDateTime` and `endDateTime` – Define a time range for which you want to retrieve results.
     *
     * Of the optional fields, you can organize the results in the following ways:
     * + Use the `filters` field to filter the results, the `groupBy` field to specify categories by which to group the results, and the `binBy` field to specify time intervals by which to group the results.
     * + Use the `maxResults` field to limit the number of results to return in a single response and the `nextToken` field to return the next batch of results if the response does not return the full set of results.
     *
     * Note that an `order` field exists in both `binBy` and `metrics`. You can specify only one `order` in a given request.
     */
    override suspend fun listIntentMetrics(input: ListIntentMetricsRequest): ListIntentMetricsResponse {
        val op = SdkHttpOperation.build<ListIntentMetricsRequest, ListIntentMetricsResponse> {
            serializer = ListIntentMetricsOperationSerializer()
            deserializer = ListIntentMetricsOperationDeserializer()
            operationName = "ListIntentMetrics"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves summary statistics for a path of intents that users take over sessions with your bot. The following fields are required:
     * + `startDateTime` and `endDateTime` – Define a time range for which you want to retrieve results.
     * + `intentPath` – Define an order of intents for which you want to retrieve metrics. Separate intents in the path with a forward slash. For example, populate the `intentPath` field with `/BookCar/BookHotel` to see details about how many times users invoked the `BookCar` and `BookHotel` intents in that order.
     *
     * Use the optional `filters` field to filter the results.
     */
    override suspend fun listIntentPaths(input: ListIntentPathsRequest): ListIntentPathsResponse {
        val op = SdkHttpOperation.build<ListIntentPathsRequest, ListIntentPathsResponse> {
            serializer = ListIntentPathsOperationSerializer()
            deserializer = ListIntentPathsOperationDeserializer()
            operationName = "ListIntentPaths"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves summary metrics for the stages within intents in your bot. The following fields are required:
     * + `metrics` – A list of [AnalyticsIntentStageMetric](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsIntentStageMetric.html) objects. In each object, use the `name` field to specify the metric to calculate, the `statistic` field to specify whether to calculate the `Sum`, `Average`, or `Max` number, and the `order` field to specify whether to sort the results in `Ascending` or `Descending` order.
     * + `startDateTime` and `endDateTime` – Define a time range for which you want to retrieve results.
     *
     * Of the optional fields, you can organize the results in the following ways:
     * + Use the `filters` field to filter the results, the `groupBy` field to specify categories by which to group the results, and the `binBy` field to specify time intervals by which to group the results.
     * + Use the `maxResults` field to limit the number of results to return in a single response and the `nextToken` field to return the next batch of results if the response does not return the full set of results.
     *
     * Note that an `order` field exists in both `binBy` and `metrics`. You can only specify one `order` in a given request.
     */
    override suspend fun listIntentStageMetrics(input: ListIntentStageMetricsRequest): ListIntentStageMetricsResponse {
        val op = SdkHttpOperation.build<ListIntentStageMetricsRequest, ListIntentStageMetricsResponse> {
            serializer = ListIntentStageMetricsOperationSerializer()
            deserializer = ListIntentStageMetricsOperationDeserializer()
            operationName = "ListIntentStageMetrics"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get a list of intents that meet the specified criteria.
     */
    override suspend fun listIntents(input: ListIntentsRequest): ListIntentsResponse {
        val op = SdkHttpOperation.build<ListIntentsRequest, ListIntentsResponse> {
            serializer = ListIntentsOperationSerializer()
            deserializer = ListIntentsOperationDeserializer()
            operationName = "ListIntents"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of recommended intents provided by the bot recommendation that you can use in your bot. Intents in the response are ordered by relevance.
     */
    override suspend fun listRecommendedIntents(input: ListRecommendedIntentsRequest): ListRecommendedIntentsResponse {
        val op = SdkHttpOperation.build<ListRecommendedIntentsRequest, ListRecommendedIntentsResponse> {
            serializer = ListRecommendedIntentsOperationSerializer()
            deserializer = ListRecommendedIntentsOperationDeserializer()
            operationName = "ListRecommendedIntents"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of metadata for individual user sessions with your bot. The `startDateTime` and `endDateTime` fields are required. These fields define a time range for which you want to retrieve results. Of the optional fields, you can organize the results in the following ways:
     * + Use the `filters` field to filter the results and the `sortBy` field to specify the values by which to sort the results.
     * + Use the `maxResults` field to limit the number of results to return in a single response and the `nextToken` field to return the next batch of results if the response does not return the full set of results.
     */
    override suspend fun listSessionAnalyticsData(input: ListSessionAnalyticsDataRequest): ListSessionAnalyticsDataResponse {
        val op = SdkHttpOperation.build<ListSessionAnalyticsDataRequest, ListSessionAnalyticsDataResponse> {
            serializer = ListSessionAnalyticsDataOperationSerializer()
            deserializer = ListSessionAnalyticsDataOperationDeserializer()
            operationName = "ListSessionAnalyticsData"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves summary metrics for the user sessions with your bot. The following fields are required:
     * + `metrics` – A list of [AnalyticsSessionMetric](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsSessionMetric.html) objects. In each object, use the `name` field to specify the metric to calculate, the `statistic` field to specify whether to calculate the `Sum`, `Average`, or `Max` number, and the `order` field to specify whether to sort the results in `Ascending` or `Descending` order.
     * + `startDateTime` and `endDateTime` – Define a time range for which you want to retrieve results.
     *
     * Of the optional fields, you can organize the results in the following ways:
     * + Use the `filters` field to filter the results, the `groupBy` field to specify categories by which to group the results, and the `binBy` field to specify time intervals by which to group the results.
     * + Use the `maxResults` field to limit the number of results to return in a single response and the `nextToken` field to return the next batch of results if the response does not return the full set of results.
     *
     * Note that an `order` field exists in both `binBy` and `metrics`. Currently, you can specify it in either field, but not in both.
     */
    override suspend fun listSessionMetrics(input: ListSessionMetricsRequest): ListSessionMetricsResponse {
        val op = SdkHttpOperation.build<ListSessionMetricsRequest, ListSessionMetricsResponse> {
            serializer = ListSessionMetricsOperationSerializer()
            deserializer = ListSessionMetricsOperationDeserializer()
            operationName = "ListSessionMetrics"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of slot types that match the specified criteria.
     */
    override suspend fun listSlotTypes(input: ListSlotTypesRequest): ListSlotTypesResponse {
        val op = SdkHttpOperation.build<ListSlotTypesRequest, ListSlotTypesResponse> {
            serializer = ListSlotTypesOperationSerializer()
            deserializer = ListSlotTypesOperationDeserializer()
            operationName = "ListSlotTypes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of slots that match the specified criteria.
     */
    override suspend fun listSlots(input: ListSlotsRequest): ListSlotsResponse {
        val op = SdkHttpOperation.build<ListSlotsRequest, ListSlotsResponse> {
            serializer = ListSlotsOperationSerializer()
            deserializer = ListSlotsOperationDeserializer()
            operationName = "ListSlots"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of tags associated with a resource. Only bots, bot aliases, and bot channels can have tags associated with them.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            operationName = "ListTagsForResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of test execution result items.
     */
    override suspend fun listTestExecutionResultItems(input: ListTestExecutionResultItemsRequest): ListTestExecutionResultItemsResponse {
        val op = SdkHttpOperation.build<ListTestExecutionResultItemsRequest, ListTestExecutionResultItemsResponse> {
            serializer = ListTestExecutionResultItemsOperationSerializer()
            deserializer = ListTestExecutionResultItemsOperationDeserializer()
            operationName = "ListTestExecutionResultItems"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * The list of test set executions.
     */
    override suspend fun listTestExecutions(input: ListTestExecutionsRequest): ListTestExecutionsResponse {
        val op = SdkHttpOperation.build<ListTestExecutionsRequest, ListTestExecutionsResponse> {
            serializer = ListTestExecutionsOperationSerializer()
            deserializer = ListTestExecutionsOperationDeserializer()
            operationName = "ListTestExecutions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * The list of test set records.
     */
    override suspend fun listTestSetRecords(input: ListTestSetRecordsRequest): ListTestSetRecordsResponse {
        val op = SdkHttpOperation.build<ListTestSetRecordsRequest, ListTestSetRecordsResponse> {
            serializer = ListTestSetRecordsOperationSerializer()
            deserializer = ListTestSetRecordsOperationDeserializer()
            operationName = "ListTestSetRecords"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * The list of the test sets
     */
    override suspend fun listTestSets(input: ListTestSetsRequest): ListTestSetsResponse {
        val op = SdkHttpOperation.build<ListTestSetsRequest, ListTestSetsResponse> {
            serializer = ListTestSetsOperationSerializer()
            deserializer = ListTestSetsOperationDeserializer()
            operationName = "ListTestSets"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * To use this API operation, your IAM role must have permissions to perform the [ListAggregatedUtterances](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html) operation, which provides access to utterance-related analytics. See [Viewing utterance statistics](https://docs.aws.amazon.com/lexv2/latest/dg/monitoring-utterances.html) for the IAM policy to apply to the IAM role.
     *
     * Retrieves a list of metadata for individual user utterances to your bot. The following fields are required:
     * + `startDateTime` and `endDateTime` – Define a time range for which you want to retrieve results.
     *
     * Of the optional fields, you can organize the results in the following ways:
     * + Use the `filters` field to filter the results and the `sortBy` field to specify the values by which to sort the results.
     * + Use the `maxResults` field to limit the number of results to return in a single response and the `nextToken` field to return the next batch of results if the response does not return the full set of results.
     */
    override suspend fun listUtteranceAnalyticsData(input: ListUtteranceAnalyticsDataRequest): ListUtteranceAnalyticsDataResponse {
        val op = SdkHttpOperation.build<ListUtteranceAnalyticsDataRequest, ListUtteranceAnalyticsDataResponse> {
            serializer = ListUtteranceAnalyticsDataOperationSerializer()
            deserializer = ListUtteranceAnalyticsDataOperationDeserializer()
            operationName = "ListUtteranceAnalyticsData"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * To use this API operation, your IAM role must have permissions to perform the [ListAggregatedUtterances](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html) operation, which provides access to utterance-related analytics. See [Viewing utterance statistics](https://docs.aws.amazon.com/lexv2/latest/dg/monitoring-utterances.html) for the IAM policy to apply to the IAM role.
     *
     * Retrieves summary metrics for the utterances in your bot. The following fields are required:
     * + `metrics` – A list of [AnalyticsUtteranceMetric](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsUtteranceMetric.html) objects. In each object, use the `name` field to specify the metric to calculate, the `statistic` field to specify whether to calculate the `Sum`, `Average`, or `Max` number, and the `order` field to specify whether to sort the results in `Ascending` or `Descending` order.
     * + `startDateTime` and `endDateTime` – Define a time range for which you want to retrieve results.
     *
     * Of the optional fields, you can organize the results in the following ways:
     * + Use the `filters` field to filter the results, the `groupBy` field to specify categories by which to group the results, and the `binBy` field to specify time intervals by which to group the results.
     * + Use the `maxResults` field to limit the number of results to return in a single response and the `nextToken` field to return the next batch of results if the response does not return the full set of results.
     *
     * Note that an `order` field exists in both `binBy` and `metrics`. Currently, you can specify it in either field, but not in both.
     */
    override suspend fun listUtteranceMetrics(input: ListUtteranceMetricsRequest): ListUtteranceMetricsResponse {
        val op = SdkHttpOperation.build<ListUtteranceMetricsRequest, ListUtteranceMetricsResponse> {
            serializer = ListUtteranceMetricsOperationSerializer()
            deserializer = ListUtteranceMetricsOperationDeserializer()
            operationName = "ListUtteranceMetrics"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Search for associated transcripts that meet the specified criteria.
     */
    override suspend fun searchAssociatedTranscripts(input: SearchAssociatedTranscriptsRequest): SearchAssociatedTranscriptsResponse {
        val op = SdkHttpOperation.build<SearchAssociatedTranscriptsRequest, SearchAssociatedTranscriptsResponse> {
            serializer = SearchAssociatedTranscriptsOperationSerializer()
            deserializer = SearchAssociatedTranscriptsOperationDeserializer()
            operationName = "SearchAssociatedTranscripts"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Use this to provide your transcript data, and to start the bot recommendation process.
     */
    override suspend fun startBotRecommendation(input: StartBotRecommendationRequest): StartBotRecommendationResponse {
        val op = SdkHttpOperation.build<StartBotRecommendationRequest, StartBotRecommendationResponse> {
            serializer = StartBotRecommendationOperationSerializer()
            deserializer = StartBotRecommendationOperationDeserializer()
            operationName = "StartBotRecommendation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts a request for the descriptive bot builder to generate a bot locale configuration based on the prompt you provide it. After you make this call, use the `DescribeBotResourceGeneration` operation to check on the status of the generation and for the `generatedBotLocaleUrl` when the generation is complete. Use that value to retrieve the Amazon S3 object containing the bot locale configuration. You can then modify and import this configuration.
     */
    override suspend fun startBotResourceGeneration(input: StartBotResourceGenerationRequest): StartBotResourceGenerationResponse {
        val op = SdkHttpOperation.build<StartBotResourceGenerationRequest, StartBotResourceGenerationResponse> {
            serializer = StartBotResourceGenerationOperationSerializer()
            deserializer = StartBotResourceGenerationOperationDeserializer()
            operationName = "StartBotResourceGeneration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts importing a bot, bot locale, or custom vocabulary from a zip archive that you uploaded to an S3 bucket.
     */
    override suspend fun startImport(input: StartImportRequest): StartImportResponse {
        val op = SdkHttpOperation.build<StartImportRequest, StartImportResponse> {
            serializer = StartImportOperationSerializer()
            deserializer = StartImportOperationDeserializer()
            operationName = "StartImport"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * The action to start test set execution.
     */
    override suspend fun startTestExecution(input: StartTestExecutionRequest): StartTestExecutionResponse {
        val op = SdkHttpOperation.build<StartTestExecutionRequest, StartTestExecutionResponse> {
            serializer = StartTestExecutionOperationSerializer()
            deserializer = StartTestExecutionOperationDeserializer()
            operationName = "StartTestExecution"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * The action to start the generation of test set.
     */
    override suspend fun startTestSetGeneration(input: StartTestSetGenerationRequest): StartTestSetGenerationResponse {
        val op = SdkHttpOperation.build<StartTestSetGenerationRequest, StartTestSetGenerationResponse> {
            serializer = StartTestSetGenerationOperationSerializer()
            deserializer = StartTestSetGenerationOperationDeserializer()
            operationName = "StartTestSetGeneration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Stop an already running Bot Recommendation request.
     */
    override suspend fun stopBotRecommendation(input: StopBotRecommendationRequest): StopBotRecommendationResponse {
        val op = SdkHttpOperation.build<StopBotRecommendationRequest, StopBotRecommendationResponse> {
            serializer = StopBotRecommendationOperationSerializer()
            deserializer = StopBotRecommendationOperationDeserializer()
            operationName = "StopBotRecommendation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds the specified tags to the specified resource. If a tag key already exists, the existing value is replaced with the new value.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            operationName = "TagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes tags from a bot, bot alias, or bot channel.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            operationName = "UntagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the configuration of an existing bot.
     */
    override suspend fun updateBot(input: UpdateBotRequest): UpdateBotResponse {
        val op = SdkHttpOperation.build<UpdateBotRequest, UpdateBotResponse> {
            serializer = UpdateBotOperationSerializer()
            deserializer = UpdateBotOperationDeserializer()
            operationName = "UpdateBot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the configuration of an existing bot alias.
     */
    override suspend fun updateBotAlias(input: UpdateBotAliasRequest): UpdateBotAliasResponse {
        val op = SdkHttpOperation.build<UpdateBotAliasRequest, UpdateBotAliasResponse> {
            serializer = UpdateBotAliasOperationSerializer()
            deserializer = UpdateBotAliasOperationDeserializer()
            operationName = "UpdateBotAlias"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the settings that a bot has for a specific locale.
     */
    override suspend fun updateBotLocale(input: UpdateBotLocaleRequest): UpdateBotLocaleResponse {
        val op = SdkHttpOperation.build<UpdateBotLocaleRequest, UpdateBotLocaleResponse> {
            serializer = UpdateBotLocaleOperationSerializer()
            deserializer = UpdateBotLocaleOperationDeserializer()
            operationName = "UpdateBotLocale"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing bot recommendation request.
     */
    override suspend fun updateBotRecommendation(input: UpdateBotRecommendationRequest): UpdateBotRecommendationResponse {
        val op = SdkHttpOperation.build<UpdateBotRecommendationRequest, UpdateBotRecommendationResponse> {
            serializer = UpdateBotRecommendationOperationSerializer()
            deserializer = UpdateBotRecommendationOperationDeserializer()
            operationName = "UpdateBotRecommendation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the password used to protect an export zip archive.
     *
     * The password is not required. If you don't supply a password, Amazon Lex generates a zip file that is not protected by a password. This is the archive that is available at the pre-signed S3 URL provided by the [DescribeExport](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html) operation.
     */
    override suspend fun updateExport(input: UpdateExportRequest): UpdateExportResponse {
        val op = SdkHttpOperation.build<UpdateExportRequest, UpdateExportResponse> {
            serializer = UpdateExportOperationSerializer()
            deserializer = UpdateExportOperationDeserializer()
            operationName = "UpdateExport"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the settings for an intent.
     */
    override suspend fun updateIntent(input: UpdateIntentRequest): UpdateIntentResponse {
        val op = SdkHttpOperation.build<UpdateIntentRequest, UpdateIntentResponse> {
            serializer = UpdateIntentOperationSerializer()
            deserializer = UpdateIntentOperationDeserializer()
            operationName = "UpdateIntent"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Replaces the existing resource policy for a bot or bot alias with a new one. If the policy doesn't exist, Amazon Lex returns an exception.
     */
    override suspend fun updateResourcePolicy(input: UpdateResourcePolicyRequest): UpdateResourcePolicyResponse {
        val op = SdkHttpOperation.build<UpdateResourcePolicyRequest, UpdateResourcePolicyResponse> {
            serializer = UpdateResourcePolicyOperationSerializer()
            deserializer = UpdateResourcePolicyOperationDeserializer()
            operationName = "UpdateResourcePolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the settings for a slot.
     */
    override suspend fun updateSlot(input: UpdateSlotRequest): UpdateSlotResponse {
        val op = SdkHttpOperation.build<UpdateSlotRequest, UpdateSlotResponse> {
            serializer = UpdateSlotOperationSerializer()
            deserializer = UpdateSlotOperationDeserializer()
            operationName = "UpdateSlot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the configuration of an existing slot type.
     */
    override suspend fun updateSlotType(input: UpdateSlotTypeRequest): UpdateSlotTypeResponse {
        val op = SdkHttpOperation.build<UpdateSlotTypeRequest, UpdateSlotTypeResponse> {
            serializer = UpdateSlotTypeOperationSerializer()
            deserializer = UpdateSlotTypeOperationDeserializer()
            operationName = "UpdateSlotType"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * The action to update the test set.
     */
    override suspend fun updateTestSet(input: UpdateTestSetRequest): UpdateTestSetResponse {
        val op = SdkHttpOperation.build<UpdateTestSetRequest, UpdateTestSetResponse> {
            serializer = UpdateTestSetOperationSerializer()
            deserializer = UpdateTestSetOperationDeserializer()
            operationName = "UpdateTestSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(AwsClientOption.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "lex")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
