// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.waiters

import aws.sdk.kotlin.services.lambda.LambdaClient
import aws.sdk.kotlin.services.lambda.model.GetFunctionConfigurationRequest
import aws.sdk.kotlin.services.lambda.model.GetFunctionConfigurationResponse
import aws.sdk.kotlin.services.lambda.model.GetFunctionRequest
import aws.sdk.kotlin.services.lambda.model.GetFunctionResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType
import aws.smithy.kotlin.runtime.retries.policy.SuccessAcceptor
import kotlin.time.Duration.Companion.milliseconds


/**
 * Waits for the function's State to be Active. This waiter uses GetFunction API. This should be used after new function creation.
 */
public suspend fun LambdaClient.waitUntilFunctionActiveV2(request: GetFunctionRequest): Outcome<GetFunctionResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 1_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<GetFunctionRequest, GetFunctionResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val configuration = it.configuration
            val state = configuration?.state?.value
            state == "Active"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val configuration = it.configuration
            val state = configuration?.state?.value
            state == "Failed"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val configuration = it.configuration
            val state = configuration?.state?.value
            state == "Pending"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getFunction(request) }
}

/**
 * Waits for the function's State to be Active. This waiter uses GetFunction API. This should be used after new function creation.
 */
public suspend fun LambdaClient.waitUntilFunctionActiveV2(block: GetFunctionRequest.Builder.() -> Unit): Outcome<GetFunctionResponse> =
    waitUntilFunctionActiveV2(GetFunctionRequest.Builder().apply(block).build())

public suspend fun LambdaClient.waitUntilFunctionExists(request: GetFunctionRequest): Outcome<GetFunctionResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 1_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<GetFunctionRequest, GetFunctionResponse>>(
        SuccessAcceptor(RetryDirective.TerminateAndSucceed, true),
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "ResourceNotFoundException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getFunction(request) }
}

public suspend fun LambdaClient.waitUntilFunctionExists(block: GetFunctionRequest.Builder.() -> Unit): Outcome<GetFunctionResponse> =
    waitUntilFunctionExists(GetFunctionRequest.Builder().apply(block).build())

/**
 * Waits for the function's LastUpdateStatus to be Successful. This waiter uses GetFunction API. This should be used after function updates.
 */
public suspend fun LambdaClient.waitUntilFunctionUpdatedV2(request: GetFunctionRequest): Outcome<GetFunctionResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 1_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<GetFunctionRequest, GetFunctionResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val configuration = it.configuration
            val lastUpdateStatus = configuration?.lastUpdateStatus?.value
            lastUpdateStatus == "Successful"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val configuration = it.configuration
            val lastUpdateStatus = configuration?.lastUpdateStatus?.value
            lastUpdateStatus == "Failed"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val configuration = it.configuration
            val lastUpdateStatus = configuration?.lastUpdateStatus?.value
            lastUpdateStatus == "InProgress"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getFunction(request) }
}

/**
 * Waits for the function's LastUpdateStatus to be Successful. This waiter uses GetFunction API. This should be used after function updates.
 */
public suspend fun LambdaClient.waitUntilFunctionUpdatedV2(block: GetFunctionRequest.Builder.() -> Unit): Outcome<GetFunctionResponse> =
    waitUntilFunctionUpdatedV2(GetFunctionRequest.Builder().apply(block).build())

/**
 * Waits for the function's State to be Active. This waiter uses GetFunctionConfiguration API. This should be used after new function creation.
 */
public suspend fun LambdaClient.waitUntilFunctionActive(request: GetFunctionConfigurationRequest): Outcome<GetFunctionConfigurationResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 5_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<GetFunctionConfigurationRequest, GetFunctionConfigurationResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val state = it.state?.value
            state == "Active"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val state = it.state?.value
            state == "Failed"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val state = it.state?.value
            state == "Pending"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getFunctionConfiguration(request) }
}

/**
 * Waits for the function's State to be Active. This waiter uses GetFunctionConfiguration API. This should be used after new function creation.
 */
public suspend fun LambdaClient.waitUntilFunctionActive(block: GetFunctionConfigurationRequest.Builder.() -> Unit): Outcome<GetFunctionConfigurationResponse> =
    waitUntilFunctionActive(GetFunctionConfigurationRequest.Builder().apply(block).build())

/**
 * Waits for the function's LastUpdateStatus to be Successful. This waiter uses GetFunctionConfiguration API. This should be used after function updates.
 */
public suspend fun LambdaClient.waitUntilFunctionUpdated(request: GetFunctionConfigurationRequest): Outcome<GetFunctionConfigurationResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 5_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<GetFunctionConfigurationRequest, GetFunctionConfigurationResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val lastUpdateStatus = it.lastUpdateStatus?.value
            lastUpdateStatus == "Successful"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val lastUpdateStatus = it.lastUpdateStatus?.value
            lastUpdateStatus == "Failed"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val lastUpdateStatus = it.lastUpdateStatus?.value
            lastUpdateStatus == "InProgress"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getFunctionConfiguration(request) }
}

/**
 * Waits for the function's LastUpdateStatus to be Successful. This waiter uses GetFunctionConfiguration API. This should be used after function updates.
 */
public suspend fun LambdaClient.waitUntilFunctionUpdated(block: GetFunctionConfigurationRequest.Builder.() -> Unit): Outcome<GetFunctionConfigurationResponse> =
    waitUntilFunctionUpdated(GetFunctionConfigurationRequest.Builder().apply(block).build())

/**
 * Waits for the published version's State to be Active. This waiter uses GetFunctionConfiguration API. This should be used after new version is published.
 */
public suspend fun LambdaClient.waitUntilPublishedVersionActive(request: GetFunctionConfigurationRequest): Outcome<GetFunctionConfigurationResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 5_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<GetFunctionConfigurationRequest, GetFunctionConfigurationResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val state = it.state?.value
            state == "Active"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val state = it.state?.value
            state == "Failed"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val state = it.state?.value
            state == "Pending"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getFunctionConfiguration(request) }
}

/**
 * Waits for the published version's State to be Active. This waiter uses GetFunctionConfiguration API. This should be used after new version is published.
 */
public suspend fun LambdaClient.waitUntilPublishedVersionActive(block: GetFunctionConfigurationRequest.Builder.() -> Unit): Outcome<GetFunctionConfigurationResponse> =
    waitUntilPublishedVersionActive(GetFunctionConfigurationRequest.Builder().apply(block).build())
