// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.serde

import aws.sdk.kotlin.services.lambda.model.Cors
import aws.sdk.kotlin.services.lambda.model.FunctionUrlAuthType
import aws.sdk.kotlin.services.lambda.model.InvokeMode
import aws.sdk.kotlin.services.lambda.model.LambdaException
import aws.sdk.kotlin.services.lambda.model.UpdateFunctionUrlConfigResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateFunctionUrlConfigOperationDeserializer: HttpDeserialize<UpdateFunctionUrlConfigResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateFunctionUrlConfigResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateFunctionUrlConfigError(context, call)
        }
        val builder = UpdateFunctionUrlConfigResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateFunctionUrlConfigOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateFunctionUrlConfigError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LambdaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceConflictException" -> ResourceConflictExceptionDeserializer().deserialize(context, wrappedCall)
        else -> LambdaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateFunctionUrlConfigOperationBody(builder: UpdateFunctionUrlConfigResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTHTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AuthType"))
    val CORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Cors"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CreationTime"))
    val FUNCTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FunctionArn"))
    val FUNCTIONURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FunctionUrl"))
    val INVOKEMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("InvokeMode"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LastModifiedTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHTYPE_DESCRIPTOR)
        field(CORS_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(FUNCTIONARN_DESCRIPTOR)
        field(FUNCTIONURL_DESCRIPTOR)
        field(INVOKEMODE_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTHTYPE_DESCRIPTOR.index -> builder.authType = deserializeString().let { FunctionUrlAuthType.fromValue(it) }
                CORS_DESCRIPTOR.index -> builder.cors = deserializeCorsDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString()
                FUNCTIONARN_DESCRIPTOR.index -> builder.functionArn = deserializeString()
                FUNCTIONURL_DESCRIPTOR.index -> builder.functionUrl = deserializeString()
                INVOKEMODE_DESCRIPTOR.index -> builder.invokeMode = deserializeString().let { InvokeMode.fromValue(it) }
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
