// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.serde

import aws.sdk.kotlin.services.lambda.model.DestinationConfig
import aws.sdk.kotlin.services.lambda.model.LambdaException
import aws.sdk.kotlin.services.lambda.model.UpdateFunctionEventInvokeConfigResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class UpdateFunctionEventInvokeConfigOperationDeserializer: HttpDeserialize<UpdateFunctionEventInvokeConfigResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateFunctionEventInvokeConfigResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateFunctionEventInvokeConfigError(context, call)
        }
        val builder = UpdateFunctionEventInvokeConfigResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateFunctionEventInvokeConfigOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateFunctionEventInvokeConfigError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LambdaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceConflictException" -> ResourceConflictExceptionDeserializer().deserialize(context, wrappedCall)
        else -> LambdaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateFunctionEventInvokeConfigOperationBody(builder: UpdateFunctionEventInvokeConfigResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DESTINATIONCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DestinationConfig"))
    val FUNCTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FunctionArn"))
    val LASTMODIFIED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModified"))
    val MAXIMUMEVENTAGEINSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaximumEventAgeInSeconds"))
    val MAXIMUMRETRYATTEMPTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaximumRetryAttempts"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESTINATIONCONFIG_DESCRIPTOR)
        field(FUNCTIONARN_DESCRIPTOR)
        field(LASTMODIFIED_DESCRIPTOR)
        field(MAXIMUMEVENTAGEINSECONDS_DESCRIPTOR)
        field(MAXIMUMRETRYATTEMPTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DESTINATIONCONFIG_DESCRIPTOR.index -> builder.destinationConfig = deserializeDestinationConfigDocument(deserializer)
                FUNCTIONARN_DESCRIPTOR.index -> builder.functionArn = deserializeString()
                LASTMODIFIED_DESCRIPTOR.index -> builder.lastModified = deserializeString().let { Instant.fromEpochSeconds(it) }
                MAXIMUMEVENTAGEINSECONDS_DESCRIPTOR.index -> builder.maximumEventAgeInSeconds = deserializeInt()
                MAXIMUMRETRYATTEMPTS_DESCRIPTOR.index -> builder.maximumRetryAttempts = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
