// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.serde

import aws.sdk.kotlin.services.lambda.model.DeadLetterConfig
import aws.sdk.kotlin.services.lambda.model.Environment
import aws.sdk.kotlin.services.lambda.model.EphemeralStorage
import aws.sdk.kotlin.services.lambda.model.FileSystemConfig
import aws.sdk.kotlin.services.lambda.model.ImageConfig
import aws.sdk.kotlin.services.lambda.model.LoggingConfig
import aws.sdk.kotlin.services.lambda.model.Runtime
import aws.sdk.kotlin.services.lambda.model.SnapStart
import aws.sdk.kotlin.services.lambda.model.TracingConfig
import aws.sdk.kotlin.services.lambda.model.UpdateFunctionConfigurationRequest
import aws.sdk.kotlin.services.lambda.model.VpcConfig
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateFunctionConfigurationOperationSerializer: HttpSerialize<UpdateFunctionConfigurationRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateFunctionConfigurationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.functionName) { "functionName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("2015-03-31"))
                add(PercentEncoding.Path.encode("functions"))
                add(PercentEncoding.SmithyLabel.encode("${input.functionName}"))
                add(PercentEncoding.Path.encode("configuration"))
            }
        }

        val payload = serializeUpdateFunctionConfigurationOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateFunctionConfigurationOperationBody(context: ExecutionContext, input: UpdateFunctionConfigurationRequest): ByteArray {
    val serializer = JsonSerializer()
    val DEADLETTERCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DeadLetterConfig"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val ENVIRONMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Environment"))
    val EPHEMERALSTORAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("EphemeralStorage"))
    val FILESYSTEMCONFIGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FileSystemConfigs"))
    val HANDLER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Handler"))
    val IMAGECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ImageConfig"))
    val KMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KMSKeyArn"))
    val LAYERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Layers"))
    val LOGGINGCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LoggingConfig"))
    val MEMORYSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MemorySize"))
    val REVISIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RevisionId"))
    val ROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Role"))
    val RUNTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Runtime"))
    val SNAPSTART_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SnapStart"))
    val TIMEOUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("Timeout"))
    val TRACINGCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TracingConfig"))
    val VPCCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("VpcConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEADLETTERCONFIG_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENVIRONMENT_DESCRIPTOR)
        field(EPHEMERALSTORAGE_DESCRIPTOR)
        field(FILESYSTEMCONFIGS_DESCRIPTOR)
        field(HANDLER_DESCRIPTOR)
        field(IMAGECONFIG_DESCRIPTOR)
        field(KMSKEYARN_DESCRIPTOR)
        field(LAYERS_DESCRIPTOR)
        field(LOGGINGCONFIG_DESCRIPTOR)
        field(MEMORYSIZE_DESCRIPTOR)
        field(REVISIONID_DESCRIPTOR)
        field(ROLE_DESCRIPTOR)
        field(RUNTIME_DESCRIPTOR)
        field(SNAPSTART_DESCRIPTOR)
        field(TIMEOUT_DESCRIPTOR)
        field(TRACINGCONFIG_DESCRIPTOR)
        field(VPCCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.deadLetterConfig?.let { field(DEADLETTERCONFIG_DESCRIPTOR, it, ::serializeDeadLetterConfigDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.environment?.let { field(ENVIRONMENT_DESCRIPTOR, it, ::serializeEnvironmentDocument) }
        input.ephemeralStorage?.let { field(EPHEMERALSTORAGE_DESCRIPTOR, it, ::serializeEphemeralStorageDocument) }
        if (input.fileSystemConfigs != null) {
            listField(FILESYSTEMCONFIGS_DESCRIPTOR) {
                for (el0 in input.fileSystemConfigs) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeFileSystemConfigDocument))
                }
            }
        }
        input.handler?.let { field(HANDLER_DESCRIPTOR, it) }
        input.imageConfig?.let { field(IMAGECONFIG_DESCRIPTOR, it, ::serializeImageConfigDocument) }
        input.kmsKeyArn?.let { field(KMSKEYARN_DESCRIPTOR, it) }
        if (input.layers != null) {
            listField(LAYERS_DESCRIPTOR) {
                for (el0 in input.layers) {
                    serializeString(el0)
                }
            }
        }
        input.loggingConfig?.let { field(LOGGINGCONFIG_DESCRIPTOR, it, ::serializeLoggingConfigDocument) }
        input.memorySize?.let { field(MEMORYSIZE_DESCRIPTOR, it) }
        input.revisionId?.let { field(REVISIONID_DESCRIPTOR, it) }
        input.role?.let { field(ROLE_DESCRIPTOR, it) }
        input.runtime?.let { field(RUNTIME_DESCRIPTOR, it.value) }
        input.snapStart?.let { field(SNAPSTART_DESCRIPTOR, it, ::serializeSnapStartDocument) }
        input.timeout?.let { field(TIMEOUT_DESCRIPTOR, it) }
        input.tracingConfig?.let { field(TRACINGCONFIG_DESCRIPTOR, it, ::serializeTracingConfigDocument) }
        input.vpcConfig?.let { field(VPCCONFIG_DESCRIPTOR, it, ::serializeVpcConfigDocument) }
    }
    return serializer.toByteArray()
}
