// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.serde

import aws.sdk.kotlin.services.lambda.model.Architecture
import aws.sdk.kotlin.services.lambda.model.UpdateFunctionCodeRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.text.encoding.encodeBase64String


internal class UpdateFunctionCodeOperationSerializer: HttpSerialize<UpdateFunctionCodeRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateFunctionCodeRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.functionName) { "functionName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("2015-03-31"))
                add(PercentEncoding.Path.encode("functions"))
                add(PercentEncoding.SmithyLabel.encode("${input.functionName}"))
                add(PercentEncoding.Path.encode("code"))
            }
        }

        val payload = serializeUpdateFunctionCodeOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateFunctionCodeOperationBody(context: ExecutionContext, input: UpdateFunctionCodeRequest): ByteArray {
    val serializer = JsonSerializer()
    val ARCHITECTURES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Architectures"))
    val DRYRUN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("DryRun"))
    val IMAGEURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ImageUri"))
    val PUBLISH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("Publish"))
    val REVISIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RevisionId"))
    val S3BUCKET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("S3Bucket"))
    val S3KEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("S3Key"))
    val S3OBJECTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("S3ObjectVersion"))
    val ZIPFILE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, JsonSerialName("ZipFile"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARCHITECTURES_DESCRIPTOR)
        field(DRYRUN_DESCRIPTOR)
        field(IMAGEURI_DESCRIPTOR)
        field(PUBLISH_DESCRIPTOR)
        field(REVISIONID_DESCRIPTOR)
        field(S3BUCKET_DESCRIPTOR)
        field(S3KEY_DESCRIPTOR)
        field(S3OBJECTVERSION_DESCRIPTOR)
        field(ZIPFILE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.architectures != null) {
            listField(ARCHITECTURES_DESCRIPTOR) {
                for (el0 in input.architectures) {
                    serializeString(el0.value)
                }
            }
        }
        input.dryRun?.let { field(DRYRUN_DESCRIPTOR, it) }
        input.imageUri?.let { field(IMAGEURI_DESCRIPTOR, it) }
        input.publish?.let { field(PUBLISH_DESCRIPTOR, it) }
        input.revisionId?.let { field(REVISIONID_DESCRIPTOR, it) }
        input.s3Bucket?.let { field(S3BUCKET_DESCRIPTOR, it) }
        input.s3Key?.let { field(S3KEY_DESCRIPTOR, it) }
        input.s3ObjectVersion?.let { field(S3OBJECTVERSION_DESCRIPTOR, it) }
        input.zipFile?.let { field(ZIPFILE_DESCRIPTOR, it.encodeBase64String()) }
    }
    return serializer.toByteArray()
}
