// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.serde

import aws.sdk.kotlin.services.lambda.model.AllowedPublishers
import aws.sdk.kotlin.services.lambda.model.CodeSigningPolicies
import aws.sdk.kotlin.services.lambda.model.UpdateCodeSigningConfigRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateCodeSigningConfigOperationSerializer: HttpSerialize<UpdateCodeSigningConfigRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateCodeSigningConfigRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.codeSigningConfigArn) { "codeSigningConfigArn is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("2020-04-22"))
                add(PercentEncoding.Path.encode("code-signing-configs"))
                add(PercentEncoding.SmithyLabel.encode("${input.codeSigningConfigArn}"))
            }
        }

        val payload = serializeUpdateCodeSigningConfigOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateCodeSigningConfigOperationBody(context: ExecutionContext, input: UpdateCodeSigningConfigRequest): ByteArray {
    val serializer = JsonSerializer()
    val ALLOWEDPUBLISHERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AllowedPublishers"))
    val CODESIGNINGPOLICIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CodeSigningPolicies"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALLOWEDPUBLISHERS_DESCRIPTOR)
        field(CODESIGNINGPOLICIES_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.allowedPublishers?.let { field(ALLOWEDPUBLISHERS_DESCRIPTOR, it, ::serializeAllowedPublishersDocument) }
        input.codeSigningPolicies?.let { field(CODESIGNINGPOLICIES_DESCRIPTOR, it, ::serializeCodeSigningPoliciesDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
