// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.serde

import aws.sdk.kotlin.services.lambda.model.LambdaException
import aws.sdk.kotlin.services.lambda.model.ProvisionedConcurrencyStatusEnum
import aws.sdk.kotlin.services.lambda.model.PutProvisionedConcurrencyConfigResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutProvisionedConcurrencyConfigOperationDeserializer: HttpDeserialize<PutProvisionedConcurrencyConfigResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): PutProvisionedConcurrencyConfigResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutProvisionedConcurrencyConfigError(context, call)
        }
        val builder = PutProvisionedConcurrencyConfigResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutProvisionedConcurrencyConfigOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwPutProvisionedConcurrencyConfigError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LambdaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceConflictException" -> ResourceConflictExceptionDeserializer().deserialize(context, wrappedCall)
        else -> LambdaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutProvisionedConcurrencyConfigOperationBody(builder: PutProvisionedConcurrencyConfigResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALLOCATEDPROVISIONEDCONCURRENTEXECUTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("AllocatedProvisionedConcurrentExecutions"))
    val AVAILABLEPROVISIONEDCONCURRENTEXECUTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("AvailableProvisionedConcurrentExecutions"))
    val LASTMODIFIED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LastModified"))
    val REQUESTEDPROVISIONEDCONCURRENTEXECUTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("RequestedProvisionedConcurrentExecutions"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val STATUSREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StatusReason"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALLOCATEDPROVISIONEDCONCURRENTEXECUTIONS_DESCRIPTOR)
        field(AVAILABLEPROVISIONEDCONCURRENTEXECUTIONS_DESCRIPTOR)
        field(LASTMODIFIED_DESCRIPTOR)
        field(REQUESTEDPROVISIONEDCONCURRENTEXECUTIONS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSREASON_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALLOCATEDPROVISIONEDCONCURRENTEXECUTIONS_DESCRIPTOR.index -> builder.allocatedProvisionedConcurrentExecutions = deserializeInt()
                AVAILABLEPROVISIONEDCONCURRENTEXECUTIONS_DESCRIPTOR.index -> builder.availableProvisionedConcurrentExecutions = deserializeInt()
                LASTMODIFIED_DESCRIPTOR.index -> builder.lastModified = deserializeString()
                REQUESTEDPROVISIONEDCONCURRENTEXECUTIONS_DESCRIPTOR.index -> builder.requestedProvisionedConcurrentExecutions = deserializeInt()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ProvisionedConcurrencyStatusEnum.fromValue(it) }
                STATUSREASON_DESCRIPTOR.index -> builder.statusReason = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
