// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.serde

import aws.sdk.kotlin.services.lambda.model.Architecture
import aws.sdk.kotlin.services.lambda.model.ListLayerVersionsRequest
import aws.sdk.kotlin.services.lambda.model.Runtime
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class ListLayerVersionsOperationSerializer: HttpSerialize<ListLayerVersionsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListLayerVersionsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            requireNotNull(input.layerName) { "layerName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("2018-10-31"))
                add(PercentEncoding.Path.encode("layers"))
                add(PercentEncoding.SmithyLabel.encode("${input.layerName}"))
                add(PercentEncoding.Path.encode("versions"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.compatibleArchitecture != null) add("CompatibleArchitecture", input.compatibleArchitecture.value)
                if (input.compatibleRuntime != null) add("CompatibleRuntime", input.compatibleRuntime.value)
                if (input.marker != null) add("Marker", input.marker)
                if (input.maxItems != null) add("MaxItems", "${input.maxItems}")
            }
        }

        return builder
    }
}
