// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.serde

import aws.sdk.kotlin.services.lambda.model.InvokeResponseStreamUpdate
import aws.sdk.kotlin.services.lambda.model.InvokeWithResponseStreamResponse
import aws.sdk.kotlin.services.lambda.model.InvokeWithResponseStreamResponseEvent
import aws.sdk.kotlin.services.lambda.model.LambdaException
import aws.smithy.kotlin.runtime.ClientException
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.MessageType
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.decodeFrames
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.type
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.toSdkByteReadChannel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.map


internal class InvokeWithResponseStreamOperationDeserializer: HttpDeserialize<InvokeWithResponseStreamResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): InvokeWithResponseStreamResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwInvokeWithResponseStreamError(context, call)
        }
        val builder = InvokeWithResponseStreamResponse.Builder()

        builder.executedVersion = response.headers["X-Amz-Executed-Version"]
        builder.responseStreamContentType = response.headers["Content-Type"]

        deserializeInvokeWithResponseStreamOperationBody(builder, call)
        builder.statusCode = response.status.value
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwInvokeWithResponseStreamError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LambdaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "KMSNotFoundException" -> KmsNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "RecursiveInvocationException" -> RecursiveInvocationExceptionDeserializer().deserialize(context, wrappedCall)
        "SnapStartException" -> SnapStartExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidSubnetIDException" -> InvalidSubnetIdExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedCall)
        "KMSDisabledException" -> KmsDisabledExceptionDeserializer().deserialize(context, wrappedCall)
        "EFSIOException" -> EfsioExceptionDeserializer().deserialize(context, wrappedCall)
        "EFSMountConnectivityException" -> EfsMountConnectivityExceptionDeserializer().deserialize(context, wrappedCall)
        "EFSMountFailureException" -> EfsMountFailureExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotReadyException" -> ResourceNotReadyExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidZipFileException" -> InvalidZipFileExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestContentException" -> InvalidRequestContentExceptionDeserializer().deserialize(context, wrappedCall)
        "SnapStartTimeoutException" -> SnapStartTimeoutExceptionDeserializer().deserialize(context, wrappedCall)
        "EC2ThrottledException" -> Ec2ThrottledExceptionDeserializer().deserialize(context, wrappedCall)
        "SubnetIPAddressLimitReachedException" -> SubnetIpAddressLimitReachedExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidSecurityGroupIDException" -> InvalidSecurityGroupIdExceptionDeserializer().deserialize(context, wrappedCall)
        "RequestTooLargeException" -> RequestTooLargeExceptionDeserializer().deserialize(context, wrappedCall)
        "UnsupportedMediaTypeException" -> UnsupportedMediaTypeExceptionDeserializer().deserialize(context, wrappedCall)
        "EFSMountTimeoutException" -> EfsMountTimeoutExceptionDeserializer().deserialize(context, wrappedCall)
        "ENILimitReachedException" -> EniLimitReachedExceptionDeserializer().deserialize(context, wrappedCall)
        "SnapStartNotReadyException" -> SnapStartNotReadyExceptionDeserializer().deserialize(context, wrappedCall)
        "EC2UnexpectedException" -> Ec2UnexpectedExceptionDeserializer().deserialize(context, wrappedCall)
        "EC2AccessDeniedException" -> Ec2AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRuntimeException" -> InvalidRuntimeExceptionDeserializer().deserialize(context, wrappedCall)
        "KMSAccessDeniedException" -> KmsAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "KMSInvalidStateException" -> KmsInvalidStateExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceConflictException" -> ResourceConflictExceptionDeserializer().deserialize(context, wrappedCall)
        else -> LambdaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

internal suspend fun deserializeInvokeWithResponseStreamOperationBody(builder: InvokeWithResponseStreamResponse.Builder, call: HttpCall) {
    val chan = call.response.body.toSdkByteReadChannel(call) ?: return
    val frames = decodeFrames(chan)
    val events = frames
        .map { message ->
            when (val mt = message.type()) {
                is MessageType.Event -> when (mt.shapeType) {
                    "PayloadChunk" -> {
                        val eb = InvokeResponseStreamUpdate.Builder()
                        eb.payload = message.payload
                        val e = eb.build()
                        InvokeWithResponseStreamResponseEvent.PayloadChunk(e)
                    }
                    "InvokeComplete" -> {
                        val e = deserializeInvokeWithResponseStreamCompleteEventPayload(message.payload)
                        InvokeWithResponseStreamResponseEvent.InvokeComplete(e)
                    }
                    else -> InvokeWithResponseStreamResponseEvent.SdkUnknown
                }
                is MessageType.Exception -> when (mt.shapeType) {
                    else -> throw LambdaException("error processing event stream, unrecognized errorType: ${mt.shapeType}")
                }
                is MessageType.Error -> throw LambdaException("error processing event stream: errorCode=${mt.errorCode}; message=${mt.message}")
                is MessageType.SdkUnknown -> throw ClientException("unrecognized event stream message `:message-type`: ${mt.messageType}")
            }
        }

    builder.eventStream = events
}
