// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.serde

import aws.sdk.kotlin.services.lambda.model.InvocationType
import aws.sdk.kotlin.services.lambda.model.InvokeRequest
import aws.sdk.kotlin.services.lambda.model.LogType
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class InvokeOperationSerializer: HttpSerialize<InvokeRequest> {
    override suspend fun serialize(context: ExecutionContext, input: InvokeRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.functionName) { "functionName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("2015-03-31"))
                add(PercentEncoding.Path.encode("functions"))
                add(PercentEncoding.SmithyLabel.encode("${input.functionName}"))
                add(PercentEncoding.Path.encode("invocations"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.qualifier != null) add("Qualifier", input.qualifier)
            }
        }

        builder.headers {
            if (input.clientContext?.isNotEmpty() == true) append("X-Amz-Client-Context", input.clientContext)
            if (input.invocationType != null) append("X-Amz-Invocation-Type", input.invocationType.value)
            if (input.logType != null) append("X-Amz-Log-Type", input.logType.value)
        }

        if (input.payload != null) {
            builder.body = HttpBody.fromBytes(input.payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        if (input.payload == null) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        return builder
    }
}
