// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.serde

import aws.sdk.kotlin.services.lambda.model.GetRuntimeManagementConfigResponse
import aws.sdk.kotlin.services.lambda.model.LambdaException
import aws.sdk.kotlin.services.lambda.model.UpdateRuntimeOn
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetRuntimeManagementConfigOperationDeserializer: HttpDeserialize<GetRuntimeManagementConfigResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetRuntimeManagementConfigResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetRuntimeManagementConfigError(context, call)
        }
        val builder = GetRuntimeManagementConfigResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetRuntimeManagementConfigOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetRuntimeManagementConfigError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LambdaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall)
        else -> LambdaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRuntimeManagementConfigOperationBody(builder: GetRuntimeManagementConfigResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FUNCTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FunctionArn"))
    val RUNTIMEVERSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RuntimeVersionArn"))
    val UPDATERUNTIMEON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("UpdateRuntimeOn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FUNCTIONARN_DESCRIPTOR)
        field(RUNTIMEVERSIONARN_DESCRIPTOR)
        field(UPDATERUNTIMEON_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FUNCTIONARN_DESCRIPTOR.index -> builder.functionArn = deserializeString()
                RUNTIMEVERSIONARN_DESCRIPTOR.index -> builder.runtimeVersionArn = deserializeString()
                UPDATERUNTIMEON_DESCRIPTOR.index -> builder.updateRuntimeOn = deserializeString().let { UpdateRuntimeOn.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
