// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.serde

import aws.sdk.kotlin.services.lambda.model.GetLayerVersionPolicyResponse
import aws.sdk.kotlin.services.lambda.model.LambdaException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetLayerVersionPolicyOperationDeserializer: HttpDeserialize<GetLayerVersionPolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetLayerVersionPolicyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetLayerVersionPolicyError(context, call)
        }
        val builder = GetLayerVersionPolicyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetLayerVersionPolicyOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetLayerVersionPolicyError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LambdaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall)
        else -> LambdaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetLayerVersionPolicyOperationBody(builder: GetLayerVersionPolicyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val POLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Policy"))
    val REVISIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RevisionId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(POLICY_DESCRIPTOR)
        field(REVISIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                POLICY_DESCRIPTOR.index -> builder.policy = deserializeString()
                REVISIONID_DESCRIPTOR.index -> builder.revisionId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
