// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.serde

import aws.sdk.kotlin.services.lambda.model.Cors
import aws.sdk.kotlin.services.lambda.model.CreateFunctionUrlConfigRequest
import aws.sdk.kotlin.services.lambda.model.FunctionUrlAuthType
import aws.sdk.kotlin.services.lambda.model.InvokeMode
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateFunctionUrlConfigOperationSerializer: HttpSerialize<CreateFunctionUrlConfigRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateFunctionUrlConfigRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.functionName) { "functionName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("2021-10-31"))
                add(PercentEncoding.Path.encode("functions"))
                add(PercentEncoding.SmithyLabel.encode("${input.functionName}"))
                add(PercentEncoding.Path.encode("url"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.qualifier != null) add("Qualifier", input.qualifier)
            }
        }

        val payload = serializeCreateFunctionUrlConfigOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateFunctionUrlConfigOperationBody(context: ExecutionContext, input: CreateFunctionUrlConfigRequest): ByteArray {
    val serializer = JsonSerializer()
    val AUTHTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AuthType"))
    val CORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Cors"))
    val INVOKEMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("InvokeMode"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHTYPE_DESCRIPTOR)
        field(CORS_DESCRIPTOR)
        field(INVOKEMODE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.authType?.let { field(AUTHTYPE_DESCRIPTOR, it.value) }
        input.cors?.let { field(CORS_DESCRIPTOR, it, ::serializeCorsDocument) }
        input.invokeMode?.let { field(INVOKEMODE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
