// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.serde

import aws.sdk.kotlin.services.lambda.model.Architecture
import aws.sdk.kotlin.services.lambda.model.CreateFunctionRequest
import aws.sdk.kotlin.services.lambda.model.DeadLetterConfig
import aws.sdk.kotlin.services.lambda.model.Environment
import aws.sdk.kotlin.services.lambda.model.EphemeralStorage
import aws.sdk.kotlin.services.lambda.model.FileSystemConfig
import aws.sdk.kotlin.services.lambda.model.FunctionCode
import aws.sdk.kotlin.services.lambda.model.ImageConfig
import aws.sdk.kotlin.services.lambda.model.LoggingConfig
import aws.sdk.kotlin.services.lambda.model.PackageType
import aws.sdk.kotlin.services.lambda.model.Runtime
import aws.sdk.kotlin.services.lambda.model.SnapStart
import aws.sdk.kotlin.services.lambda.model.TracingConfig
import aws.sdk.kotlin.services.lambda.model.VpcConfig
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateFunctionOperationSerializer: HttpSerialize<CreateFunctionRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateFunctionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/2015-03-31/functions"
        }

        val payload = serializeCreateFunctionOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateFunctionOperationBody(context: ExecutionContext, input: CreateFunctionRequest): ByteArray {
    val serializer = JsonSerializer()
    val ARCHITECTURES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Architectures"))
    val CODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Code"))
    val CODESIGNINGCONFIGARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CodeSigningConfigArn"))
    val DEADLETTERCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DeadLetterConfig"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val ENVIRONMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Environment"))
    val EPHEMERALSTORAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("EphemeralStorage"))
    val FILESYSTEMCONFIGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FileSystemConfigs"))
    val FUNCTIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FunctionName"))
    val HANDLER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Handler"))
    val IMAGECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ImageConfig"))
    val KMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KMSKeyArn"))
    val LAYERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Layers"))
    val LOGGINGCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LoggingConfig"))
    val MEMORYSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MemorySize"))
    val PACKAGETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("PackageType"))
    val PUBLISH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("Publish"))
    val ROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Role"))
    val RUNTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Runtime"))
    val SNAPSTART_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SnapStart"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val TIMEOUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("Timeout"))
    val TRACINGCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TracingConfig"))
    val VPCCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("VpcConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARCHITECTURES_DESCRIPTOR)
        field(CODE_DESCRIPTOR)
        field(CODESIGNINGCONFIGARN_DESCRIPTOR)
        field(DEADLETTERCONFIG_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENVIRONMENT_DESCRIPTOR)
        field(EPHEMERALSTORAGE_DESCRIPTOR)
        field(FILESYSTEMCONFIGS_DESCRIPTOR)
        field(FUNCTIONNAME_DESCRIPTOR)
        field(HANDLER_DESCRIPTOR)
        field(IMAGECONFIG_DESCRIPTOR)
        field(KMSKEYARN_DESCRIPTOR)
        field(LAYERS_DESCRIPTOR)
        field(LOGGINGCONFIG_DESCRIPTOR)
        field(MEMORYSIZE_DESCRIPTOR)
        field(PACKAGETYPE_DESCRIPTOR)
        field(PUBLISH_DESCRIPTOR)
        field(ROLE_DESCRIPTOR)
        field(RUNTIME_DESCRIPTOR)
        field(SNAPSTART_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TIMEOUT_DESCRIPTOR)
        field(TRACINGCONFIG_DESCRIPTOR)
        field(VPCCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.architectures != null) {
            listField(ARCHITECTURES_DESCRIPTOR) {
                for (el0 in input.architectures) {
                    serializeString(el0.value)
                }
            }
        }
        input.code?.let { field(CODE_DESCRIPTOR, it, ::serializeFunctionCodeDocument) }
        input.codeSigningConfigArn?.let { field(CODESIGNINGCONFIGARN_DESCRIPTOR, it) }
        input.deadLetterConfig?.let { field(DEADLETTERCONFIG_DESCRIPTOR, it, ::serializeDeadLetterConfigDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.environment?.let { field(ENVIRONMENT_DESCRIPTOR, it, ::serializeEnvironmentDocument) }
        input.ephemeralStorage?.let { field(EPHEMERALSTORAGE_DESCRIPTOR, it, ::serializeEphemeralStorageDocument) }
        if (input.fileSystemConfigs != null) {
            listField(FILESYSTEMCONFIGS_DESCRIPTOR) {
                for (el0 in input.fileSystemConfigs) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeFileSystemConfigDocument))
                }
            }
        }
        input.functionName?.let { field(FUNCTIONNAME_DESCRIPTOR, it) }
        input.handler?.let { field(HANDLER_DESCRIPTOR, it) }
        input.imageConfig?.let { field(IMAGECONFIG_DESCRIPTOR, it, ::serializeImageConfigDocument) }
        input.kmsKeyArn?.let { field(KMSKEYARN_DESCRIPTOR, it) }
        if (input.layers != null) {
            listField(LAYERS_DESCRIPTOR) {
                for (el0 in input.layers) {
                    serializeString(el0)
                }
            }
        }
        input.loggingConfig?.let { field(LOGGINGCONFIG_DESCRIPTOR, it, ::serializeLoggingConfigDocument) }
        input.memorySize?.let { field(MEMORYSIZE_DESCRIPTOR, it) }
        input.packageType?.let { field(PACKAGETYPE_DESCRIPTOR, it.value) }
        input.publish?.let { field(PUBLISH_DESCRIPTOR, it) }
        input.role?.let { field(ROLE_DESCRIPTOR, it) }
        input.runtime?.let { field(RUNTIME_DESCRIPTOR, it.value) }
        input.snapStart?.let { field(SNAPSTART_DESCRIPTOR, it, ::serializeSnapStartDocument) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.timeout?.let { field(TIMEOUT_DESCRIPTOR, it) }
        input.tracingConfig?.let { field(TRACINGCONFIG_DESCRIPTOR, it, ::serializeTracingConfigDocument) }
        input.vpcConfig?.let { field(VPCCONFIG_DESCRIPTOR, it, ::serializeVpcConfigDocument) }
    }
    return serializer.toByteArray()
}
