// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



public class UpdateFunctionUrlConfigRequest private constructor(builder: Builder) {
    /**
     * The type of authentication that your function URL uses. Set to `AWS_IAM` if you want to restrict access to authenticated users only. Set to `NONE` if you want to bypass IAM authentication to create a public endpoint. For more information, see [Security and auth model for Lambda function URLs](https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html).
     */
    public val authType: aws.sdk.kotlin.services.lambda.model.FunctionUrlAuthType? = builder.authType
    /**
     * The [cross-origin resource sharing (CORS)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) settings for your function URL.
     */
    public val cors: aws.sdk.kotlin.services.lambda.model.Cors? = builder.cors
    /**
     * The name of the Lambda function.
     *
     * **Name formats**
     * + **Function name** – `my-function`.
     * + **Function ARN** – `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
     * + **Partial ARN** – `123456789012:function:my-function`.
     *
     * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
     */
    public val functionName: kotlin.String? = builder.functionName
    /**
     * Use one of the following options:
     * + `BUFFERED` – This is the default option. Lambda invokes your function using the `Invoke` API operation. Invocation results are available when the payload is complete. The maximum payload size is 6 MB.
     * + `RESPONSE_STREAM` – Your function streams payload results as they become available. Lambda invokes your function using the `InvokeWithResponseStream` API operation. The maximum response payload size is 20 MB, however, you can [request a quota increase](https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html).
     */
    public val invokeMode: aws.sdk.kotlin.services.lambda.model.InvokeMode? = builder.invokeMode
    /**
     * The alias name.
     */
    public val qualifier: kotlin.String? = builder.qualifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.UpdateFunctionUrlConfigRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFunctionUrlConfigRequest(")
        append("authType=$authType,")
        append("cors=$cors,")
        append("functionName=$functionName,")
        append("invokeMode=$invokeMode,")
        append("qualifier=$qualifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authType?.hashCode() ?: 0
        result = 31 * result + (cors?.hashCode() ?: 0)
        result = 31 * result + (functionName?.hashCode() ?: 0)
        result = 31 * result + (invokeMode?.hashCode() ?: 0)
        result = 31 * result + (qualifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFunctionUrlConfigRequest

        if (authType != other.authType) return false
        if (cors != other.cors) return false
        if (functionName != other.functionName) return false
        if (invokeMode != other.invokeMode) return false
        if (qualifier != other.qualifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.UpdateFunctionUrlConfigRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of authentication that your function URL uses. Set to `AWS_IAM` if you want to restrict access to authenticated users only. Set to `NONE` if you want to bypass IAM authentication to create a public endpoint. For more information, see [Security and auth model for Lambda function URLs](https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html).
         */
        public var authType: aws.sdk.kotlin.services.lambda.model.FunctionUrlAuthType? = null
        /**
         * The [cross-origin resource sharing (CORS)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) settings for your function URL.
         */
        public var cors: aws.sdk.kotlin.services.lambda.model.Cors? = null
        /**
         * The name of the Lambda function.
         *
         * **Name formats**
         * + **Function name** – `my-function`.
         * + **Function ARN** – `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
         * + **Partial ARN** – `123456789012:function:my-function`.
         *
         * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
         */
        public var functionName: kotlin.String? = null
        /**
         * Use one of the following options:
         * + `BUFFERED` – This is the default option. Lambda invokes your function using the `Invoke` API operation. Invocation results are available when the payload is complete. The maximum payload size is 6 MB.
         * + `RESPONSE_STREAM` – Your function streams payload results as they become available. Lambda invokes your function using the `InvokeWithResponseStream` API operation. The maximum response payload size is 20 MB, however, you can [request a quota increase](https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html).
         */
        public var invokeMode: aws.sdk.kotlin.services.lambda.model.InvokeMode? = null
        /**
         * The alias name.
         */
        public var qualifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.UpdateFunctionUrlConfigRequest) : this() {
            this.authType = x.authType
            this.cors = x.cors
            this.functionName = x.functionName
            this.invokeMode = x.invokeMode
            this.qualifier = x.qualifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.UpdateFunctionUrlConfigRequest = UpdateFunctionUrlConfigRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.Cors] inside the given [block]
         */
        public fun cors(block: aws.sdk.kotlin.services.lambda.model.Cors.Builder.() -> kotlin.Unit) {
            this.cors = aws.sdk.kotlin.services.lambda.model.Cors.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
