// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



public class UpdateFunctionEventInvokeConfigRequest private constructor(builder: Builder) {
    /**
     * A destination for events after they have been sent to a function for processing.
     *
     * **Destinations**
     * + **Function** - The Amazon Resource Name (ARN) of a Lambda function.
     * + **Queue** - The ARN of a standard SQS queue.
     * + **Topic** - The ARN of a standard SNS topic.
     * + **Event Bus** - The ARN of an Amazon EventBridge event bus.
     */
    public val destinationConfig: aws.sdk.kotlin.services.lambda.model.DestinationConfig? = builder.destinationConfig
    /**
     * The name of the Lambda function, version, or alias.
     *
     * **Name formats**
     * + **Function name** - `my-function` (name-only), `my-function:v1` (with alias).
     * + **Function ARN** - `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
     * + **Partial ARN** - `123456789012:function:my-function`.
     *
     * You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
     */
    public val functionName: kotlin.String? = builder.functionName
    /**
     * The maximum age of a request that Lambda sends to a function for processing.
     */
    public val maximumEventAgeInSeconds: kotlin.Int? = builder.maximumEventAgeInSeconds
    /**
     * The maximum number of times to retry when the function returns an error.
     */
    public val maximumRetryAttempts: kotlin.Int? = builder.maximumRetryAttempts
    /**
     * A version number or alias name.
     */
    public val qualifier: kotlin.String? = builder.qualifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.UpdateFunctionEventInvokeConfigRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFunctionEventInvokeConfigRequest(")
        append("destinationConfig=$destinationConfig,")
        append("functionName=$functionName,")
        append("maximumEventAgeInSeconds=$maximumEventAgeInSeconds,")
        append("maximumRetryAttempts=$maximumRetryAttempts,")
        append("qualifier=$qualifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationConfig?.hashCode() ?: 0
        result = 31 * result + (functionName?.hashCode() ?: 0)
        result = 31 * result + (maximumEventAgeInSeconds ?: 0)
        result = 31 * result + (maximumRetryAttempts ?: 0)
        result = 31 * result + (qualifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFunctionEventInvokeConfigRequest

        if (destinationConfig != other.destinationConfig) return false
        if (functionName != other.functionName) return false
        if (maximumEventAgeInSeconds != other.maximumEventAgeInSeconds) return false
        if (maximumRetryAttempts != other.maximumRetryAttempts) return false
        if (qualifier != other.qualifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.UpdateFunctionEventInvokeConfigRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A destination for events after they have been sent to a function for processing.
         *
         * **Destinations**
         * + **Function** - The Amazon Resource Name (ARN) of a Lambda function.
         * + **Queue** - The ARN of a standard SQS queue.
         * + **Topic** - The ARN of a standard SNS topic.
         * + **Event Bus** - The ARN of an Amazon EventBridge event bus.
         */
        public var destinationConfig: aws.sdk.kotlin.services.lambda.model.DestinationConfig? = null
        /**
         * The name of the Lambda function, version, or alias.
         *
         * **Name formats**
         * + **Function name** - `my-function` (name-only), `my-function:v1` (with alias).
         * + **Function ARN** - `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
         * + **Partial ARN** - `123456789012:function:my-function`.
         *
         * You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
         */
        public var functionName: kotlin.String? = null
        /**
         * The maximum age of a request that Lambda sends to a function for processing.
         */
        public var maximumEventAgeInSeconds: kotlin.Int? = null
        /**
         * The maximum number of times to retry when the function returns an error.
         */
        public var maximumRetryAttempts: kotlin.Int? = null
        /**
         * A version number or alias name.
         */
        public var qualifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.UpdateFunctionEventInvokeConfigRequest) : this() {
            this.destinationConfig = x.destinationConfig
            this.functionName = x.functionName
            this.maximumEventAgeInSeconds = x.maximumEventAgeInSeconds
            this.maximumRetryAttempts = x.maximumRetryAttempts
            this.qualifier = x.qualifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.UpdateFunctionEventInvokeConfigRequest = UpdateFunctionEventInvokeConfigRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.DestinationConfig] inside the given [block]
         */
        public fun destinationConfig(block: aws.sdk.kotlin.services.lambda.model.DestinationConfig.Builder.() -> kotlin.Unit) {
            this.destinationConfig = aws.sdk.kotlin.services.lambda.model.DestinationConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
