// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



public class UpdateFunctionConfigurationRequest private constructor(builder: Builder) {
    /**
     * A dead-letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing. For more information, see [Dead-letter queues](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-dlq).
     */
    public val deadLetterConfig: aws.sdk.kotlin.services.lambda.model.DeadLetterConfig? = builder.deadLetterConfig
    /**
     * A description of the function.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Environment variables that are accessible from function code during execution.
     */
    public val environment: aws.sdk.kotlin.services.lambda.model.Environment? = builder.environment
    /**
     * The size of the function's `/tmp` directory in MB. The default value is 512, but can be any whole number between 512 and 10,240 MB. For more information, see [Configuring ephemeral storage (console)](https://docs.aws.amazon.com/lambda/latest/dg/configuration-function-common.html#configuration-ephemeral-storage).
     */
    public val ephemeralStorage: aws.sdk.kotlin.services.lambda.model.EphemeralStorage? = builder.ephemeralStorage
    /**
     * Connection settings for an Amazon EFS file system.
     */
    public val fileSystemConfigs: List<FileSystemConfig>? = builder.fileSystemConfigs
    /**
     * The name of the Lambda function.
     *
     * **Name formats**
     * + **Function name** – `my-function`.
     * + **Function ARN** – `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
     * + **Partial ARN** – `123456789012:function:my-function`.
     *
     * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
     */
    public val functionName: kotlin.String? = builder.functionName
    /**
     * The name of the method within your code that Lambda calls to run your function. Handler is required if the deployment package is a .zip file archive. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see [Lambda programming model](https://docs.aws.amazon.com/lambda/latest/dg/foundation-progmodel.html).
     */
    public val handler: kotlin.String? = builder.handler
    /**
     * [Container image configuration values](https://docs.aws.amazon.com/lambda/latest/dg/images-parms.html) that override the values in the container image Docker file.
     */
    public val imageConfig: aws.sdk.kotlin.services.lambda.model.ImageConfig? = builder.imageConfig
    /**
     * The ARN of the Key Management Service (KMS) customer managed key that's used to encrypt your function's [environment variables](https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-encryption). When [Lambda SnapStart](https://docs.aws.amazon.com/lambda/latest/dg/snapstart-security.html) is activated, Lambda also uses this key is to encrypt your function's snapshot. If you deploy your function using a container image, Lambda also uses this key to encrypt your function when it's deployed. Note that this is not the same key that's used to protect your container image in the Amazon Elastic Container Registry (Amazon ECR). If you don't provide a customer managed key, Lambda uses a default service key.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * A list of [function layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html) to add to the function's execution environment. Specify each layer by its ARN, including the version.
     */
    public val layers: List<String>? = builder.layers
    /**
     * The function's Amazon CloudWatch Logs configuration settings.
     */
    public val loggingConfig: aws.sdk.kotlin.services.lambda.model.LoggingConfig? = builder.loggingConfig
    /**
     * The amount of [memory available to the function](https://docs.aws.amazon.com/lambda/latest/dg/configuration-function-common.html#configuration-memory-console) at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.
     */
    public val memorySize: kotlin.Int? = builder.memorySize
    /**
     * Update the function only if the revision ID matches the ID that's specified. Use this option to avoid modifying a function that has changed since you last read it.
     */
    public val revisionId: kotlin.String? = builder.revisionId
    /**
     * The Amazon Resource Name (ARN) of the function's execution role.
     */
    public val role: kotlin.String? = builder.role
    /**
     * The identifier of the function's [runtime](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html). Runtime is required if the deployment package is a .zip file archive.
     *
     * The following list includes deprecated runtimes. For more information, see [Runtime deprecation policy](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy).
     */
    public val runtime: aws.sdk.kotlin.services.lambda.model.Runtime? = builder.runtime
    /**
     * The function's [SnapStart](https://docs.aws.amazon.com/lambda/latest/dg/snapstart.html) setting.
     */
    public val snapStart: aws.sdk.kotlin.services.lambda.model.SnapStart? = builder.snapStart
    /**
     * The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For more information, see [Lambda execution environment](https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html).
     */
    public val timeout: kotlin.Int? = builder.timeout
    /**
     * Set `Mode` to `Active` to sample and trace a subset of incoming requests with [X-Ray](https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html).
     */
    public val tracingConfig: aws.sdk.kotlin.services.lambda.model.TracingConfig? = builder.tracingConfig
    /**
     * For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and subnets in the VPC. When you connect a function to a VPC, it can access resources and the internet only through that VPC. For more information, see [Configuring a Lambda function to access resources in a VPC](https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html).
     */
    public val vpcConfig: aws.sdk.kotlin.services.lambda.model.VpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.UpdateFunctionConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFunctionConfigurationRequest(")
        append("deadLetterConfig=$deadLetterConfig,")
        append("description=$description,")
        append("environment=$environment,")
        append("ephemeralStorage=$ephemeralStorage,")
        append("fileSystemConfigs=$fileSystemConfigs,")
        append("functionName=$functionName,")
        append("handler=$handler,")
        append("imageConfig=$imageConfig,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("layers=$layers,")
        append("loggingConfig=$loggingConfig,")
        append("memorySize=$memorySize,")
        append("revisionId=$revisionId,")
        append("role=$role,")
        append("runtime=$runtime,")
        append("snapStart=$snapStart,")
        append("timeout=$timeout,")
        append("tracingConfig=$tracingConfig,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deadLetterConfig?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (ephemeralStorage?.hashCode() ?: 0)
        result = 31 * result + (fileSystemConfigs?.hashCode() ?: 0)
        result = 31 * result + (functionName?.hashCode() ?: 0)
        result = 31 * result + (handler?.hashCode() ?: 0)
        result = 31 * result + (imageConfig?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (layers?.hashCode() ?: 0)
        result = 31 * result + (loggingConfig?.hashCode() ?: 0)
        result = 31 * result + (memorySize ?: 0)
        result = 31 * result + (revisionId?.hashCode() ?: 0)
        result = 31 * result + (role?.hashCode() ?: 0)
        result = 31 * result + (runtime?.hashCode() ?: 0)
        result = 31 * result + (snapStart?.hashCode() ?: 0)
        result = 31 * result + (timeout ?: 0)
        result = 31 * result + (tracingConfig?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFunctionConfigurationRequest

        if (deadLetterConfig != other.deadLetterConfig) return false
        if (description != other.description) return false
        if (environment != other.environment) return false
        if (ephemeralStorage != other.ephemeralStorage) return false
        if (fileSystemConfigs != other.fileSystemConfigs) return false
        if (functionName != other.functionName) return false
        if (handler != other.handler) return false
        if (imageConfig != other.imageConfig) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (layers != other.layers) return false
        if (loggingConfig != other.loggingConfig) return false
        if (memorySize != other.memorySize) return false
        if (revisionId != other.revisionId) return false
        if (role != other.role) return false
        if (runtime != other.runtime) return false
        if (snapStart != other.snapStart) return false
        if (timeout != other.timeout) return false
        if (tracingConfig != other.tracingConfig) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.UpdateFunctionConfigurationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A dead-letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing. For more information, see [Dead-letter queues](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-dlq).
         */
        public var deadLetterConfig: aws.sdk.kotlin.services.lambda.model.DeadLetterConfig? = null
        /**
         * A description of the function.
         */
        public var description: kotlin.String? = null
        /**
         * Environment variables that are accessible from function code during execution.
         */
        public var environment: aws.sdk.kotlin.services.lambda.model.Environment? = null
        /**
         * The size of the function's `/tmp` directory in MB. The default value is 512, but can be any whole number between 512 and 10,240 MB. For more information, see [Configuring ephemeral storage (console)](https://docs.aws.amazon.com/lambda/latest/dg/configuration-function-common.html#configuration-ephemeral-storage).
         */
        public var ephemeralStorage: aws.sdk.kotlin.services.lambda.model.EphemeralStorage? = null
        /**
         * Connection settings for an Amazon EFS file system.
         */
        public var fileSystemConfigs: List<FileSystemConfig>? = null
        /**
         * The name of the Lambda function.
         *
         * **Name formats**
         * + **Function name** – `my-function`.
         * + **Function ARN** – `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
         * + **Partial ARN** – `123456789012:function:my-function`.
         *
         * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
         */
        public var functionName: kotlin.String? = null
        /**
         * The name of the method within your code that Lambda calls to run your function. Handler is required if the deployment package is a .zip file archive. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see [Lambda programming model](https://docs.aws.amazon.com/lambda/latest/dg/foundation-progmodel.html).
         */
        public var handler: kotlin.String? = null
        /**
         * [Container image configuration values](https://docs.aws.amazon.com/lambda/latest/dg/images-parms.html) that override the values in the container image Docker file.
         */
        public var imageConfig: aws.sdk.kotlin.services.lambda.model.ImageConfig? = null
        /**
         * The ARN of the Key Management Service (KMS) customer managed key that's used to encrypt your function's [environment variables](https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-encryption). When [Lambda SnapStart](https://docs.aws.amazon.com/lambda/latest/dg/snapstart-security.html) is activated, Lambda also uses this key is to encrypt your function's snapshot. If you deploy your function using a container image, Lambda also uses this key to encrypt your function when it's deployed. Note that this is not the same key that's used to protect your container image in the Amazon Elastic Container Registry (Amazon ECR). If you don't provide a customer managed key, Lambda uses a default service key.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * A list of [function layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html) to add to the function's execution environment. Specify each layer by its ARN, including the version.
         */
        public var layers: List<String>? = null
        /**
         * The function's Amazon CloudWatch Logs configuration settings.
         */
        public var loggingConfig: aws.sdk.kotlin.services.lambda.model.LoggingConfig? = null
        /**
         * The amount of [memory available to the function](https://docs.aws.amazon.com/lambda/latest/dg/configuration-function-common.html#configuration-memory-console) at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.
         */
        public var memorySize: kotlin.Int? = null
        /**
         * Update the function only if the revision ID matches the ID that's specified. Use this option to avoid modifying a function that has changed since you last read it.
         */
        public var revisionId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the function's execution role.
         */
        public var role: kotlin.String? = null
        /**
         * The identifier of the function's [runtime](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html). Runtime is required if the deployment package is a .zip file archive.
         *
         * The following list includes deprecated runtimes. For more information, see [Runtime deprecation policy](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy).
         */
        public var runtime: aws.sdk.kotlin.services.lambda.model.Runtime? = null
        /**
         * The function's [SnapStart](https://docs.aws.amazon.com/lambda/latest/dg/snapstart.html) setting.
         */
        public var snapStart: aws.sdk.kotlin.services.lambda.model.SnapStart? = null
        /**
         * The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For more information, see [Lambda execution environment](https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html).
         */
        public var timeout: kotlin.Int? = null
        /**
         * Set `Mode` to `Active` to sample and trace a subset of incoming requests with [X-Ray](https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html).
         */
        public var tracingConfig: aws.sdk.kotlin.services.lambda.model.TracingConfig? = null
        /**
         * For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and subnets in the VPC. When you connect a function to a VPC, it can access resources and the internet only through that VPC. For more information, see [Configuring a Lambda function to access resources in a VPC](https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html).
         */
        public var vpcConfig: aws.sdk.kotlin.services.lambda.model.VpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.UpdateFunctionConfigurationRequest) : this() {
            this.deadLetterConfig = x.deadLetterConfig
            this.description = x.description
            this.environment = x.environment
            this.ephemeralStorage = x.ephemeralStorage
            this.fileSystemConfigs = x.fileSystemConfigs
            this.functionName = x.functionName
            this.handler = x.handler
            this.imageConfig = x.imageConfig
            this.kmsKeyArn = x.kmsKeyArn
            this.layers = x.layers
            this.loggingConfig = x.loggingConfig
            this.memorySize = x.memorySize
            this.revisionId = x.revisionId
            this.role = x.role
            this.runtime = x.runtime
            this.snapStart = x.snapStart
            this.timeout = x.timeout
            this.tracingConfig = x.tracingConfig
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.UpdateFunctionConfigurationRequest = UpdateFunctionConfigurationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.DeadLetterConfig] inside the given [block]
         */
        public fun deadLetterConfig(block: aws.sdk.kotlin.services.lambda.model.DeadLetterConfig.Builder.() -> kotlin.Unit) {
            this.deadLetterConfig = aws.sdk.kotlin.services.lambda.model.DeadLetterConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.Environment] inside the given [block]
         */
        public fun environment(block: aws.sdk.kotlin.services.lambda.model.Environment.Builder.() -> kotlin.Unit) {
            this.environment = aws.sdk.kotlin.services.lambda.model.Environment.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.EphemeralStorage] inside the given [block]
         */
        public fun ephemeralStorage(block: aws.sdk.kotlin.services.lambda.model.EphemeralStorage.Builder.() -> kotlin.Unit) {
            this.ephemeralStorage = aws.sdk.kotlin.services.lambda.model.EphemeralStorage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.ImageConfig] inside the given [block]
         */
        public fun imageConfig(block: aws.sdk.kotlin.services.lambda.model.ImageConfig.Builder.() -> kotlin.Unit) {
            this.imageConfig = aws.sdk.kotlin.services.lambda.model.ImageConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.LoggingConfig] inside the given [block]
         */
        public fun loggingConfig(block: aws.sdk.kotlin.services.lambda.model.LoggingConfig.Builder.() -> kotlin.Unit) {
            this.loggingConfig = aws.sdk.kotlin.services.lambda.model.LoggingConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.SnapStart] inside the given [block]
         */
        public fun snapStart(block: aws.sdk.kotlin.services.lambda.model.SnapStart.Builder.() -> kotlin.Unit) {
            this.snapStart = aws.sdk.kotlin.services.lambda.model.SnapStart.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.TracingConfig] inside the given [block]
         */
        public fun tracingConfig(block: aws.sdk.kotlin.services.lambda.model.TracingConfig.Builder.() -> kotlin.Unit) {
            this.tracingConfig = aws.sdk.kotlin.services.lambda.model.TracingConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.lambda.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.lambda.model.VpcConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
