// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



/**
 * The function's Amazon CloudWatch Logs configuration settings.
 */
public class LoggingConfig private constructor(builder: Builder) {
    /**
     * Set this property to filter the application logs for your function that Lambda sends to CloudWatch. Lambda only sends application logs at the selected level of detail and lower, where `TRACE` is the highest level and `FATAL` is the lowest.
     */
    public val applicationLogLevel: aws.sdk.kotlin.services.lambda.model.ApplicationLogLevel? = builder.applicationLogLevel
    /**
     * The format in which Lambda sends your function's application and system logs to CloudWatch. Select between plain text and structured JSON.
     */
    public val logFormat: aws.sdk.kotlin.services.lambda.model.LogFormat? = builder.logFormat
    /**
     * The name of the Amazon CloudWatch log group the function sends logs to. By default, Lambda functions send logs to a default log group named `/aws/lambda/<function name>`. To use a different log group, enter an existing log group or enter a new log group name.
     */
    public val logGroup: kotlin.String? = builder.logGroup
    /**
     * Set this property to filter the system logs for your function that Lambda sends to CloudWatch. Lambda only sends system logs at the selected level of detail and lower, where `DEBUG` is the highest level and `WARN` is the lowest.
     */
    public val systemLogLevel: aws.sdk.kotlin.services.lambda.model.SystemLogLevel? = builder.systemLogLevel

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.LoggingConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LoggingConfig(")
        append("applicationLogLevel=$applicationLogLevel,")
        append("logFormat=$logFormat,")
        append("logGroup=$logGroup,")
        append("systemLogLevel=$systemLogLevel")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationLogLevel?.hashCode() ?: 0
        result = 31 * result + (logFormat?.hashCode() ?: 0)
        result = 31 * result + (logGroup?.hashCode() ?: 0)
        result = 31 * result + (systemLogLevel?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LoggingConfig

        if (applicationLogLevel != other.applicationLogLevel) return false
        if (logFormat != other.logFormat) return false
        if (logGroup != other.logGroup) return false
        if (systemLogLevel != other.systemLogLevel) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.LoggingConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Set this property to filter the application logs for your function that Lambda sends to CloudWatch. Lambda only sends application logs at the selected level of detail and lower, where `TRACE` is the highest level and `FATAL` is the lowest.
         */
        public var applicationLogLevel: aws.sdk.kotlin.services.lambda.model.ApplicationLogLevel? = null
        /**
         * The format in which Lambda sends your function's application and system logs to CloudWatch. Select between plain text and structured JSON.
         */
        public var logFormat: aws.sdk.kotlin.services.lambda.model.LogFormat? = null
        /**
         * The name of the Amazon CloudWatch log group the function sends logs to. By default, Lambda functions send logs to a default log group named `/aws/lambda/<function name>`. To use a different log group, enter an existing log group or enter a new log group name.
         */
        public var logGroup: kotlin.String? = null
        /**
         * Set this property to filter the system logs for your function that Lambda sends to CloudWatch. Lambda only sends system logs at the selected level of detail and lower, where `DEBUG` is the highest level and `WARN` is the lowest.
         */
        public var systemLogLevel: aws.sdk.kotlin.services.lambda.model.SystemLogLevel? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.LoggingConfig) : this() {
            this.applicationLogLevel = x.applicationLogLevel
            this.logFormat = x.logFormat
            this.logGroup = x.logGroup
            this.systemLogLevel = x.systemLogLevel
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.LoggingConfig = LoggingConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
