// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



/**
 * Details about a function's configuration.
 */
public class FunctionConfiguration private constructor(builder: Builder) {
    /**
     * The instruction set architecture that the function supports. Architecture is a string array with one of the valid values. The default architecture value is `x86_64`.
     */
    public val architectures: List<Architecture>? = builder.architectures
    /**
     * The SHA256 hash of the function's deployment package.
     */
    public val codeSha256: kotlin.String? = builder.codeSha256
    /**
     * The size of the function's deployment package, in bytes.
     */
    public val codeSize: kotlin.Long = builder.codeSize
    /**
     * The function's dead letter queue.
     */
    public val deadLetterConfig: aws.sdk.kotlin.services.lambda.model.DeadLetterConfig? = builder.deadLetterConfig
    /**
     * The function's description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The function's [environment variables](https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html). Omitted from CloudTrail logs.
     */
    public val environment: aws.sdk.kotlin.services.lambda.model.EnvironmentResponse? = builder.environment
    /**
     * The size of the function's `/tmp` directory in MB. The default value is 512, but can be any whole number between 512 and 10,240 MB. For more information, see [Configuring ephemeral storage (console)](https://docs.aws.amazon.com/lambda/latest/dg/configuration-function-common.html#configuration-ephemeral-storage).
     */
    public val ephemeralStorage: aws.sdk.kotlin.services.lambda.model.EphemeralStorage? = builder.ephemeralStorage
    /**
     * Connection settings for an [Amazon EFS file system](https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html).
     */
    public val fileSystemConfigs: List<FileSystemConfig>? = builder.fileSystemConfigs
    /**
     * The function's Amazon Resource Name (ARN).
     */
    public val functionArn: kotlin.String? = builder.functionArn
    /**
     * The name of the function.
     */
    public val functionName: kotlin.String? = builder.functionName
    /**
     * The function that Lambda calls to begin running your function.
     */
    public val handler: kotlin.String? = builder.handler
    /**
     * The function's image configuration values.
     */
    public val imageConfigResponse: aws.sdk.kotlin.services.lambda.model.ImageConfigResponse? = builder.imageConfigResponse
    /**
     * The KMS key that's used to encrypt the function's [environment variables](https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-encryption). When [Lambda SnapStart](https://docs.aws.amazon.com/lambda/latest/dg/snapstart-security.html) is activated, this key is also used to encrypt the function's snapshot. This key is returned only if you've configured a customer managed key.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The date and time that the function was last updated, in [ISO-8601 format](https://www.w3.org/TR/NOTE-datetime) (YYYY-MM-DDThh:mm:ss.sTZD).
     */
    public val lastModified: kotlin.String? = builder.lastModified
    /**
     * The status of the last update that was performed on the function. This is first set to `Successful` after function creation completes.
     */
    public val lastUpdateStatus: aws.sdk.kotlin.services.lambda.model.LastUpdateStatus? = builder.lastUpdateStatus
    /**
     * The reason for the last update that was performed on the function.
     */
    public val lastUpdateStatusReason: kotlin.String? = builder.lastUpdateStatusReason
    /**
     * The reason code for the last update that was performed on the function.
     */
    public val lastUpdateStatusReasonCode: aws.sdk.kotlin.services.lambda.model.LastUpdateStatusReasonCode? = builder.lastUpdateStatusReasonCode
    /**
     * The function's [layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
     */
    public val layers: List<Layer>? = builder.layers
    /**
     * The function's Amazon CloudWatch Logs configuration settings.
     */
    public val loggingConfig: aws.sdk.kotlin.services.lambda.model.LoggingConfig? = builder.loggingConfig
    /**
     * For Lambda@Edge functions, the ARN of the main function.
     */
    public val masterArn: kotlin.String? = builder.masterArn
    /**
     * The amount of memory available to the function at runtime.
     */
    public val memorySize: kotlin.Int? = builder.memorySize
    /**
     * The type of deployment package. Set to `Image` for container image and set `Zip` for .zip file archive.
     */
    public val packageType: aws.sdk.kotlin.services.lambda.model.PackageType? = builder.packageType
    /**
     * The latest updated revision of the function or alias.
     */
    public val revisionId: kotlin.String? = builder.revisionId
    /**
     * The function's execution role.
     */
    public val role: kotlin.String? = builder.role
    /**
     * The identifier of the function's [runtime](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html). Runtime is required if the deployment package is a .zip file archive.
     *
     * The following list includes deprecated runtimes. For more information, see [Runtime deprecation policy](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy).
     */
    public val runtime: aws.sdk.kotlin.services.lambda.model.Runtime? = builder.runtime
    /**
     * The ARN of the runtime and any errors that occured.
     */
    public val runtimeVersionConfig: aws.sdk.kotlin.services.lambda.model.RuntimeVersionConfig? = builder.runtimeVersionConfig
    /**
     * The ARN of the signing job.
     */
    public val signingJobArn: kotlin.String? = builder.signingJobArn
    /**
     * The ARN of the signing profile version.
     */
    public val signingProfileVersionArn: kotlin.String? = builder.signingProfileVersionArn
    /**
     * Set `ApplyOn` to `PublishedVersions` to create a snapshot of the initialized execution environment when you publish a function version. For more information, see [Improving startup performance with Lambda SnapStart](https://docs.aws.amazon.com/lambda/latest/dg/snapstart.html).
     */
    public val snapStart: aws.sdk.kotlin.services.lambda.model.SnapStartResponse? = builder.snapStart
    /**
     * The current state of the function. When the state is `Inactive`, you can reactivate the function by invoking it.
     */
    public val state: aws.sdk.kotlin.services.lambda.model.State? = builder.state
    /**
     * The reason for the function's current state.
     */
    public val stateReason: kotlin.String? = builder.stateReason
    /**
     * The reason code for the function's current state. When the code is `Creating`, you can't invoke or modify the function.
     */
    public val stateReasonCode: aws.sdk.kotlin.services.lambda.model.StateReasonCode? = builder.stateReasonCode
    /**
     * The amount of time in seconds that Lambda allows a function to run before stopping it.
     */
    public val timeout: kotlin.Int? = builder.timeout
    /**
     * The function's X-Ray tracing configuration.
     */
    public val tracingConfig: aws.sdk.kotlin.services.lambda.model.TracingConfigResponse? = builder.tracingConfig
    /**
     * The version of the Lambda function.
     */
    public val version: kotlin.String? = builder.version
    /**
     * The function's networking configuration.
     */
    public val vpcConfig: aws.sdk.kotlin.services.lambda.model.VpcConfigResponse? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.FunctionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FunctionConfiguration(")
        append("architectures=$architectures,")
        append("codeSha256=$codeSha256,")
        append("codeSize=$codeSize,")
        append("deadLetterConfig=$deadLetterConfig,")
        append("description=$description,")
        append("environment=$environment,")
        append("ephemeralStorage=$ephemeralStorage,")
        append("fileSystemConfigs=$fileSystemConfigs,")
        append("functionArn=$functionArn,")
        append("functionName=$functionName,")
        append("handler=$handler,")
        append("imageConfigResponse=$imageConfigResponse,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("lastModified=$lastModified,")
        append("lastUpdateStatus=$lastUpdateStatus,")
        append("lastUpdateStatusReason=$lastUpdateStatusReason,")
        append("lastUpdateStatusReasonCode=$lastUpdateStatusReasonCode,")
        append("layers=$layers,")
        append("loggingConfig=$loggingConfig,")
        append("masterArn=$masterArn,")
        append("memorySize=$memorySize,")
        append("packageType=$packageType,")
        append("revisionId=$revisionId,")
        append("role=$role,")
        append("runtime=$runtime,")
        append("runtimeVersionConfig=$runtimeVersionConfig,")
        append("signingJobArn=$signingJobArn,")
        append("signingProfileVersionArn=$signingProfileVersionArn,")
        append("snapStart=$snapStart,")
        append("state=$state,")
        append("stateReason=$stateReason,")
        append("stateReasonCode=$stateReasonCode,")
        append("timeout=$timeout,")
        append("tracingConfig=$tracingConfig,")
        append("version=$version,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = architectures?.hashCode() ?: 0
        result = 31 * result + (codeSha256?.hashCode() ?: 0)
        result = 31 * result + (codeSize.hashCode())
        result = 31 * result + (deadLetterConfig?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (ephemeralStorage?.hashCode() ?: 0)
        result = 31 * result + (fileSystemConfigs?.hashCode() ?: 0)
        result = 31 * result + (functionArn?.hashCode() ?: 0)
        result = 31 * result + (functionName?.hashCode() ?: 0)
        result = 31 * result + (handler?.hashCode() ?: 0)
        result = 31 * result + (imageConfigResponse?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (lastModified?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateStatus?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateStatusReason?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateStatusReasonCode?.hashCode() ?: 0)
        result = 31 * result + (layers?.hashCode() ?: 0)
        result = 31 * result + (loggingConfig?.hashCode() ?: 0)
        result = 31 * result + (masterArn?.hashCode() ?: 0)
        result = 31 * result + (memorySize ?: 0)
        result = 31 * result + (packageType?.hashCode() ?: 0)
        result = 31 * result + (revisionId?.hashCode() ?: 0)
        result = 31 * result + (role?.hashCode() ?: 0)
        result = 31 * result + (runtime?.hashCode() ?: 0)
        result = 31 * result + (runtimeVersionConfig?.hashCode() ?: 0)
        result = 31 * result + (signingJobArn?.hashCode() ?: 0)
        result = 31 * result + (signingProfileVersionArn?.hashCode() ?: 0)
        result = 31 * result + (snapStart?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateReason?.hashCode() ?: 0)
        result = 31 * result + (stateReasonCode?.hashCode() ?: 0)
        result = 31 * result + (timeout ?: 0)
        result = 31 * result + (tracingConfig?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FunctionConfiguration

        if (architectures != other.architectures) return false
        if (codeSha256 != other.codeSha256) return false
        if (codeSize != other.codeSize) return false
        if (deadLetterConfig != other.deadLetterConfig) return false
        if (description != other.description) return false
        if (environment != other.environment) return false
        if (ephemeralStorage != other.ephemeralStorage) return false
        if (fileSystemConfigs != other.fileSystemConfigs) return false
        if (functionArn != other.functionArn) return false
        if (functionName != other.functionName) return false
        if (handler != other.handler) return false
        if (imageConfigResponse != other.imageConfigResponse) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (lastModified != other.lastModified) return false
        if (lastUpdateStatus != other.lastUpdateStatus) return false
        if (lastUpdateStatusReason != other.lastUpdateStatusReason) return false
        if (lastUpdateStatusReasonCode != other.lastUpdateStatusReasonCode) return false
        if (layers != other.layers) return false
        if (loggingConfig != other.loggingConfig) return false
        if (masterArn != other.masterArn) return false
        if (memorySize != other.memorySize) return false
        if (packageType != other.packageType) return false
        if (revisionId != other.revisionId) return false
        if (role != other.role) return false
        if (runtime != other.runtime) return false
        if (runtimeVersionConfig != other.runtimeVersionConfig) return false
        if (signingJobArn != other.signingJobArn) return false
        if (signingProfileVersionArn != other.signingProfileVersionArn) return false
        if (snapStart != other.snapStart) return false
        if (state != other.state) return false
        if (stateReason != other.stateReason) return false
        if (stateReasonCode != other.stateReasonCode) return false
        if (timeout != other.timeout) return false
        if (tracingConfig != other.tracingConfig) return false
        if (version != other.version) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.FunctionConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The instruction set architecture that the function supports. Architecture is a string array with one of the valid values. The default architecture value is `x86_64`.
         */
        public var architectures: List<Architecture>? = null
        /**
         * The SHA256 hash of the function's deployment package.
         */
        public var codeSha256: kotlin.String? = null
        /**
         * The size of the function's deployment package, in bytes.
         */
        public var codeSize: kotlin.Long = 0L
        /**
         * The function's dead letter queue.
         */
        public var deadLetterConfig: aws.sdk.kotlin.services.lambda.model.DeadLetterConfig? = null
        /**
         * The function's description.
         */
        public var description: kotlin.String? = null
        /**
         * The function's [environment variables](https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html). Omitted from CloudTrail logs.
         */
        public var environment: aws.sdk.kotlin.services.lambda.model.EnvironmentResponse? = null
        /**
         * The size of the function's `/tmp` directory in MB. The default value is 512, but can be any whole number between 512 and 10,240 MB. For more information, see [Configuring ephemeral storage (console)](https://docs.aws.amazon.com/lambda/latest/dg/configuration-function-common.html#configuration-ephemeral-storage).
         */
        public var ephemeralStorage: aws.sdk.kotlin.services.lambda.model.EphemeralStorage? = null
        /**
         * Connection settings for an [Amazon EFS file system](https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html).
         */
        public var fileSystemConfigs: List<FileSystemConfig>? = null
        /**
         * The function's Amazon Resource Name (ARN).
         */
        public var functionArn: kotlin.String? = null
        /**
         * The name of the function.
         */
        public var functionName: kotlin.String? = null
        /**
         * The function that Lambda calls to begin running your function.
         */
        public var handler: kotlin.String? = null
        /**
         * The function's image configuration values.
         */
        public var imageConfigResponse: aws.sdk.kotlin.services.lambda.model.ImageConfigResponse? = null
        /**
         * The KMS key that's used to encrypt the function's [environment variables](https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-encryption). When [Lambda SnapStart](https://docs.aws.amazon.com/lambda/latest/dg/snapstart-security.html) is activated, this key is also used to encrypt the function's snapshot. This key is returned only if you've configured a customer managed key.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The date and time that the function was last updated, in [ISO-8601 format](https://www.w3.org/TR/NOTE-datetime) (YYYY-MM-DDThh:mm:ss.sTZD).
         */
        public var lastModified: kotlin.String? = null
        /**
         * The status of the last update that was performed on the function. This is first set to `Successful` after function creation completes.
         */
        public var lastUpdateStatus: aws.sdk.kotlin.services.lambda.model.LastUpdateStatus? = null
        /**
         * The reason for the last update that was performed on the function.
         */
        public var lastUpdateStatusReason: kotlin.String? = null
        /**
         * The reason code for the last update that was performed on the function.
         */
        public var lastUpdateStatusReasonCode: aws.sdk.kotlin.services.lambda.model.LastUpdateStatusReasonCode? = null
        /**
         * The function's [layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
         */
        public var layers: List<Layer>? = null
        /**
         * The function's Amazon CloudWatch Logs configuration settings.
         */
        public var loggingConfig: aws.sdk.kotlin.services.lambda.model.LoggingConfig? = null
        /**
         * For Lambda@Edge functions, the ARN of the main function.
         */
        public var masterArn: kotlin.String? = null
        /**
         * The amount of memory available to the function at runtime.
         */
        public var memorySize: kotlin.Int? = null
        /**
         * The type of deployment package. Set to `Image` for container image and set `Zip` for .zip file archive.
         */
        public var packageType: aws.sdk.kotlin.services.lambda.model.PackageType? = null
        /**
         * The latest updated revision of the function or alias.
         */
        public var revisionId: kotlin.String? = null
        /**
         * The function's execution role.
         */
        public var role: kotlin.String? = null
        /**
         * The identifier of the function's [runtime](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html). Runtime is required if the deployment package is a .zip file archive.
         *
         * The following list includes deprecated runtimes. For more information, see [Runtime deprecation policy](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy).
         */
        public var runtime: aws.sdk.kotlin.services.lambda.model.Runtime? = null
        /**
         * The ARN of the runtime and any errors that occured.
         */
        public var runtimeVersionConfig: aws.sdk.kotlin.services.lambda.model.RuntimeVersionConfig? = null
        /**
         * The ARN of the signing job.
         */
        public var signingJobArn: kotlin.String? = null
        /**
         * The ARN of the signing profile version.
         */
        public var signingProfileVersionArn: kotlin.String? = null
        /**
         * Set `ApplyOn` to `PublishedVersions` to create a snapshot of the initialized execution environment when you publish a function version. For more information, see [Improving startup performance with Lambda SnapStart](https://docs.aws.amazon.com/lambda/latest/dg/snapstart.html).
         */
        public var snapStart: aws.sdk.kotlin.services.lambda.model.SnapStartResponse? = null
        /**
         * The current state of the function. When the state is `Inactive`, you can reactivate the function by invoking it.
         */
        public var state: aws.sdk.kotlin.services.lambda.model.State? = null
        /**
         * The reason for the function's current state.
         */
        public var stateReason: kotlin.String? = null
        /**
         * The reason code for the function's current state. When the code is `Creating`, you can't invoke or modify the function.
         */
        public var stateReasonCode: aws.sdk.kotlin.services.lambda.model.StateReasonCode? = null
        /**
         * The amount of time in seconds that Lambda allows a function to run before stopping it.
         */
        public var timeout: kotlin.Int? = null
        /**
         * The function's X-Ray tracing configuration.
         */
        public var tracingConfig: aws.sdk.kotlin.services.lambda.model.TracingConfigResponse? = null
        /**
         * The version of the Lambda function.
         */
        public var version: kotlin.String? = null
        /**
         * The function's networking configuration.
         */
        public var vpcConfig: aws.sdk.kotlin.services.lambda.model.VpcConfigResponse? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.FunctionConfiguration) : this() {
            this.architectures = x.architectures
            this.codeSha256 = x.codeSha256
            this.codeSize = x.codeSize
            this.deadLetterConfig = x.deadLetterConfig
            this.description = x.description
            this.environment = x.environment
            this.ephemeralStorage = x.ephemeralStorage
            this.fileSystemConfigs = x.fileSystemConfigs
            this.functionArn = x.functionArn
            this.functionName = x.functionName
            this.handler = x.handler
            this.imageConfigResponse = x.imageConfigResponse
            this.kmsKeyArn = x.kmsKeyArn
            this.lastModified = x.lastModified
            this.lastUpdateStatus = x.lastUpdateStatus
            this.lastUpdateStatusReason = x.lastUpdateStatusReason
            this.lastUpdateStatusReasonCode = x.lastUpdateStatusReasonCode
            this.layers = x.layers
            this.loggingConfig = x.loggingConfig
            this.masterArn = x.masterArn
            this.memorySize = x.memorySize
            this.packageType = x.packageType
            this.revisionId = x.revisionId
            this.role = x.role
            this.runtime = x.runtime
            this.runtimeVersionConfig = x.runtimeVersionConfig
            this.signingJobArn = x.signingJobArn
            this.signingProfileVersionArn = x.signingProfileVersionArn
            this.snapStart = x.snapStart
            this.state = x.state
            this.stateReason = x.stateReason
            this.stateReasonCode = x.stateReasonCode
            this.timeout = x.timeout
            this.tracingConfig = x.tracingConfig
            this.version = x.version
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.FunctionConfiguration = FunctionConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.DeadLetterConfig] inside the given [block]
         */
        public fun deadLetterConfig(block: aws.sdk.kotlin.services.lambda.model.DeadLetterConfig.Builder.() -> kotlin.Unit) {
            this.deadLetterConfig = aws.sdk.kotlin.services.lambda.model.DeadLetterConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.EnvironmentResponse] inside the given [block]
         */
        public fun environment(block: aws.sdk.kotlin.services.lambda.model.EnvironmentResponse.Builder.() -> kotlin.Unit) {
            this.environment = aws.sdk.kotlin.services.lambda.model.EnvironmentResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.EphemeralStorage] inside the given [block]
         */
        public fun ephemeralStorage(block: aws.sdk.kotlin.services.lambda.model.EphemeralStorage.Builder.() -> kotlin.Unit) {
            this.ephemeralStorage = aws.sdk.kotlin.services.lambda.model.EphemeralStorage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.ImageConfigResponse] inside the given [block]
         */
        public fun imageConfigResponse(block: aws.sdk.kotlin.services.lambda.model.ImageConfigResponse.Builder.() -> kotlin.Unit) {
            this.imageConfigResponse = aws.sdk.kotlin.services.lambda.model.ImageConfigResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.LoggingConfig] inside the given [block]
         */
        public fun loggingConfig(block: aws.sdk.kotlin.services.lambda.model.LoggingConfig.Builder.() -> kotlin.Unit) {
            this.loggingConfig = aws.sdk.kotlin.services.lambda.model.LoggingConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.RuntimeVersionConfig] inside the given [block]
         */
        public fun runtimeVersionConfig(block: aws.sdk.kotlin.services.lambda.model.RuntimeVersionConfig.Builder.() -> kotlin.Unit) {
            this.runtimeVersionConfig = aws.sdk.kotlin.services.lambda.model.RuntimeVersionConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.SnapStartResponse] inside the given [block]
         */
        public fun snapStart(block: aws.sdk.kotlin.services.lambda.model.SnapStartResponse.Builder.() -> kotlin.Unit) {
            this.snapStart = aws.sdk.kotlin.services.lambda.model.SnapStartResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.TracingConfigResponse] inside the given [block]
         */
        public fun tracingConfig(block: aws.sdk.kotlin.services.lambda.model.TracingConfigResponse.Builder.() -> kotlin.Unit) {
            this.tracingConfig = aws.sdk.kotlin.services.lambda.model.TracingConfigResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.VpcConfigResponse] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.lambda.model.VpcConfigResponse.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.lambda.model.VpcConfigResponse.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
