// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



/**
 * The results of an operation to update or read environment variables. If the operation succeeds, the response contains the environment variables. If it fails, the response contains details about the error.
 */
public class EnvironmentResponse private constructor(builder: Builder) {
    /**
     * Error messages for environment variables that couldn't be applied.
     */
    public val error: aws.sdk.kotlin.services.lambda.model.EnvironmentError? = builder.error
    /**
     * Environment variable key-value pairs. Omitted from CloudTrail logs.
     */
    public val variables: Map<String, String>? = builder.variables

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.EnvironmentResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EnvironmentResponse(")
        append("error=$error,")
        append("variables=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = error?.hashCode() ?: 0
        result = 31 * result + (variables?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EnvironmentResponse

        if (error != other.error) return false
        if (variables != other.variables) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.EnvironmentResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Error messages for environment variables that couldn't be applied.
         */
        public var error: aws.sdk.kotlin.services.lambda.model.EnvironmentError? = null
        /**
         * Environment variable key-value pairs. Omitted from CloudTrail logs.
         */
        public var variables: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.EnvironmentResponse) : this() {
            this.error = x.error
            this.variables = x.variables
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.EnvironmentResponse = EnvironmentResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.EnvironmentError] inside the given [block]
         */
        public fun error(block: aws.sdk.kotlin.services.lambda.model.EnvironmentError.Builder.() -> kotlin.Unit) {
            this.error = aws.sdk.kotlin.services.lambda.model.EnvironmentError.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
