// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.transform

import aws.sdk.kotlin.services.lambda.model.Cors
import aws.sdk.kotlin.services.lambda.model.FunctionUrlAuthType
import aws.sdk.kotlin.services.lambda.model.LambdaException
import aws.sdk.kotlin.services.lambda.model.UpdateFunctionUrlConfigResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateFunctionUrlConfigOperationDeserializer: HttpDeserialize<UpdateFunctionUrlConfigResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateFunctionUrlConfigResponse {
        if (!response.status.isSuccess()) {
            throwUpdateFunctionUrlConfigError(context, response)
        }
        val builder = UpdateFunctionUrlConfigResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateFunctionUrlConfigOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateFunctionUrlConfigError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LambdaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceConflictException" -> ResourceConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LambdaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateFunctionUrlConfigOperationBody(builder: UpdateFunctionUrlConfigResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTHTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AuthType"))
    val CORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Cors"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CreationTime"))
    val FUNCTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FunctionArn"))
    val FUNCTIONURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FunctionUrl"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LastModifiedTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHTYPE_DESCRIPTOR)
        field(CORS_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(FUNCTIONARN_DESCRIPTOR)
        field(FUNCTIONURL_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTHTYPE_DESCRIPTOR.index -> builder.authType = deserializeString().let { FunctionUrlAuthType.fromValue(it) }
                CORS_DESCRIPTOR.index -> builder.cors = deserializeCorsDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString()
                FUNCTIONARN_DESCRIPTOR.index -> builder.functionArn = deserializeString()
                FUNCTIONURL_DESCRIPTOR.index -> builder.functionUrl = deserializeString()
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
